/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.common.SolrException;

class FloatReplaceFunction
extends FloatValue.AbstractFloatValue {
    private final FloatValue baseExpr;
    private final FloatValue compExpr;
    private final FloatValue fillExpr;
    public static final String name = "replace";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;

    public FloatReplaceFunction(FloatValue baseExpr, FloatValue compExpr, FloatValue fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
    }

    @Override
    public float getFloat() {
        float value = this.baseExpr.getFloat();
        this.exists = this.baseExpr.exists();
        float comp = this.compExpr.getFloat();
        if (value == comp && this.exists == this.compExpr.exists()) {
            value = this.fillExpr.getFloat();
            this.exists = this.fillExpr.exists();
        }
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

