/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.Locale;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.reduction.DatePercentileFunction;
import org.apache.solr.analytics.function.reduction.DoublePercentileFunction;
import org.apache.solr.analytics.function.reduction.FloatPercentileFunction;
import org.apache.solr.analytics.function.reduction.IntPercentileFunction;
import org.apache.solr.analytics.function.reduction.LongPercentileFunction;
import org.apache.solr.analytics.function.reduction.StringPercentileFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.analytics.value.constant.ConstantIntValue;
import org.apache.solr.common.SolrException;

public class PercentileFunction {
    public static final String name = "percentile";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The percentile function requires 2 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream percValue = params[0];
        double perc = 0.0;
        if (percValue instanceof ConstantIntValue) {
            perc = ((IntValue)percValue).getInt();
            if (perc < 0.0 || perc > 99.0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The percentile function requires a percentile between 0 and 99, " + (int)perc + " found.");
            }
            perc /= 100.0;
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The percentile function requires a constant int value (the percentile) as the first argument.");
        }
        AnalyticsValueStream param = params[1];
        if (param instanceof DateValueStream) {
            return new DatePercentileFunction((DateValueStream)param, perc);
        }
        if (param instanceof IntValueStream) {
            return new IntPercentileFunction((IntValueStream)param, perc);
        }
        if (param instanceof LongValueStream) {
            return new LongPercentileFunction((LongValueStream)param, perc);
        }
        if (param instanceof FloatValueStream) {
            return new FloatPercentileFunction((FloatValueStream)param, perc);
        }
        if (param instanceof DoubleValueStream) {
            return new DoublePercentileFunction((DoubleValueStream)param, perc);
        }
        if (param instanceof StringValueStream) {
            return new StringPercentileFunction((StringValueStream)param, perc);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The percentile function requires a comparable parameter.");
    };

    protected static String createPercentileExpressionString(AnalyticsValueStream param, double perc) {
        return String.format(Locale.ROOT, "%s(%s,%s)", name, (int)(perc * 100.0), param.getExpressionStr());
    }
}

