/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.plugin;

import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.util.stats.MetricUtils;

public class AnalyticsStatisticsCollector {
    private final AtomicLong numRequests = new AtomicLong();
    private final AtomicLong numAnalyticsRequests = new AtomicLong();
    private final AtomicLong numStatsRequests = new AtomicLong();
    private final AtomicLong numCollectedStats = new AtomicLong();
    private final AtomicLong numFieldFacets = new AtomicLong();
    private final AtomicLong numRangeFacets = new AtomicLong();
    private final AtomicLong numQueryFacets = new AtomicLong();
    private final AtomicLong numQueries = new AtomicLong();
    private final Timer requestTimes = new Timer();
    public Timer.Context currentTimer;

    public void startRequest() {
        this.numRequests.incrementAndGet();
        this.currentTimer = this.requestTimes.time();
    }

    public void addRequests(long num) {
        this.numAnalyticsRequests.addAndGet(num);
    }

    public void addStatsRequests(long num) {
        this.numStatsRequests.addAndGet(num);
    }

    public void addStatsCollected(long num) {
        this.numCollectedStats.addAndGet(num);
    }

    public void addFieldFacets(long num) {
        this.numFieldFacets.addAndGet(num);
    }

    public void addRangeFacets(long num) {
        this.numRangeFacets.addAndGet(num);
    }

    public void addQueryFacets(long num) {
        this.numQueryFacets.addAndGet(num);
    }

    public void addQueries(long num) {
        this.numQueries.addAndGet(num);
    }

    public void endRequest() {
        this.currentTimer.stop();
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MetricUtils.convertTimer((String)"", (Timer)this.requestTimes, (MetricUtils.PropertyFilter)MetricUtils.PropertyFilter.ALL, (boolean)false, (boolean)false, (k, v) -> map.putAll((Map)v));
        map.put("requests", this.numRequests.longValue());
        map.put("analyticsRequests", this.numAnalyticsRequests.longValue());
        map.put("statsRequests", this.numStatsRequests.longValue());
        map.put("statsCollected", this.numCollectedStats.longValue());
        map.put("fieldFacets", this.numFieldFacets.longValue());
        map.put("rangeFacets", this.numRangeFacets.longValue());
        map.put("queryFacets", this.numQueryFacets.longValue());
        map.put("queriesInQueryFacets", this.numQueries.longValue());
        return map;
    }
}

