/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.ComparableValue;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.StringValue;

public interface FloatValue
extends FloatValueStream,
AnalyticsValue {
    public float getFloat();

    public static abstract class AbstractFloatValue
    implements CastingFloatValue {
        @Override
        public double getDouble() {
            return this.getFloat();
        }

        @Override
        public String getString() {
            float val = this.getFloat();
            return this.exists() ? Float.toString(val) : null;
        }

        @Override
        public Object getObject() {
            float val = this.getFloat();
            return this.exists() ? Float.valueOf(val) : null;
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            float val = this.getFloat();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            double val = this.getDouble();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String val = this.getString();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            Object val = this.getObject();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public ExpressionComparator<Float> getObjectComparator(String expression) {
            return new ExpressionComparator<Float>(expression);
        }
    }

    public static interface CastingFloatValue
    extends FloatValue,
    DoubleValue,
    StringValue,
    ComparableValue {
    }
}

