/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.constant.ConstantStringValue;
import org.apache.solr.common.SolrException;

public class ConcatFunction {
    public static final String name = "concat";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The concat function requires parameters.");
        }
        if (params.length == 1 && params[0] instanceof StringValue) {
            return params[0];
        }
        StringValue[] castedParams = new StringValue[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof StringValue)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The concat function requires that all parameters be single-valued and convertible to string values.");
            }
            castedParams[i] = (StringValue)params[i];
        }
        return LambdaFunction.createStringLambdaFunction(name, (a, b) -> a + b, castedParams, false);
    };

    public static class ConcatSeparatedFunction {
        public static final String name = "concatsep";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
            if (params.length < 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The concatsep function requires at least 2 parameters.");
            }
            if (!(params[0] instanceof ConstantStringValue)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The concatsep function requires that the first parameter to be a constant string.");
            }
            String sep = ((ConstantStringValue)params[0]).getString();
            StringValue[] castedParams = new StringValue[params.length - 1];
            for (int i = 0; i < castedParams.length; ++i) {
                if (!(params[i + 1] instanceof StringValue)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The concatsep function requires that all non-separator parameters be single-valued and convertible to string values.");
                }
                castedParams[i] = (StringValue)params[i + 1];
            }
            return LambdaFunction.createStringLambdaFunction(name, (a, b) -> a + sep + b, castedParams, false);
        };
    }
}

