/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.common.SolrException;

class FloatStreamRemoveFunction
extends FloatValueStream.AbstractFloatValueStream {
    private final FloatValueStream baseExpr;
    private final FloatValue removeExpr;
    public static final String name = "remove";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public FloatStreamRemoveFunction(FloatValueStream baseExpr, FloatValue removeExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.removeExpr = removeExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, removeExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
    }

    @Override
    public void streamFloats(FloatConsumer cons) {
        float removeValue = this.removeExpr.getFloat();
        if (this.removeExpr.exists()) {
            this.baseExpr.streamFloats(value -> {
                if (removeValue == value) {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamFloats(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

