/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.Arrays;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.analytics.value.constant.ConstantValue;
import org.apache.solr.common.SolrException;

public class ConcatFunction {
    public static final String name = "concat";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> ConcatFunction.createConcatFunction(name, name, (a, b) -> a + b, params);

    private static StringValueStream createConcatFunction(String functionName, String uniqueName, LambdaFunction.TwoStringInStringOutLambda lambda, AnalyticsValueStream[] params) {
        if (params.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + functionName + " function requires parameters.");
        }
        if (params.length == 1) {
            if (params[0] instanceof StringValueStream) {
                return LambdaFunction.createStringLambdaFunction(uniqueName, lambda, (StringValueStream)params[0]);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + functionName + " function requires that all parameters be string-castable.");
        }
        if (params.length == 2 && params[0] instanceof StringValueStream && params[1] instanceof StringValueStream && (!(params[0] instanceof StringValue) || !(params[1] instanceof StringValue))) {
            return LambdaFunction.createStringLambdaFunction(uniqueName, lambda, (StringValueStream)params[0], (StringValueStream)params[1]);
        }
        StringValue[] castedParams = new StringValue[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof StringValue)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + functionName + " function requires that all parameters be string-castable, and if more than 2 parameters" + " are provided then all must be single-valued.");
            }
            castedParams[i] = (StringValue)params[i];
        }
        return LambdaFunction.createStringLambdaFunction(uniqueName, lambda, castedParams, false);
    }

    public static class SeparatedConcatFunction {
        public static final String name = "concat_sep";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
            if (params.length < 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The concat_sep function requires at least 2 parameters.");
            }
            if (!(params[0] instanceof StringValue) || !(params[0] instanceof ConstantValue)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The concat_sep function requires that the first parameter to be a constant string.");
            }
            String sep = ((StringValue)params[0]).getString();
            String uniqueName = "concat_sep(" + sep + ")";
            return ConcatFunction.createConcatFunction(name, uniqueName, (a, b) -> a + sep + b, Arrays.copyOfRange(params, 1, params.length));
        };
    }
}

