/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.OrdinalFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;

class FloatOrdinalFunction
extends FloatValue.AbstractFloatValue
implements ReductionFunction {
    private SortedListCollector.SortedFloatListCollector collector;
    private int ordinal;
    public static final String name = "ordinal";
    private final String exprStr;

    public FloatOrdinalFunction(FloatValueStream param, int ordinal) {
        this.collector = new SortedListCollector.SortedFloatListCollector(param);
        this.ordinal = ordinal;
        this.exprStr = OrdinalFunction.createOrdinalExpressionString(param, ordinal);
    }

    @Override
    public float getFloat() {
        int size = this.collector.size();
        if (this.ordinal > 0) {
            return this.ordinal <= size ? ((Float)this.collector.get(this.ordinal - 1)).floatValue() : 0.0f;
        }
        return this.ordinal * -1 <= size ? ((Float)this.collector.get(size + this.ordinal)).floatValue() : 0.0f;
    }

    @Override
    public boolean exists() {
        return (this.ordinal > 0 ? this.ordinal : this.ordinal * -1) <= this.collector.size();
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (SortedListCollector.SortedFloatListCollector)sync.apply(this.collector);
        this.collector.calcOrdinal(this.ordinal);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

