/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.analytics.function.MergingReductionCollectionManager;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.function.field.BooleanField;
import org.apache.solr.analytics.function.field.BooleanMultiField;
import org.apache.solr.analytics.function.field.DateField;
import org.apache.solr.analytics.function.field.DateMultiPointField;
import org.apache.solr.analytics.function.field.DateMultiTrieField;
import org.apache.solr.analytics.function.field.DoubleField;
import org.apache.solr.analytics.function.field.DoubleMultiPointField;
import org.apache.solr.analytics.function.field.DoubleMultiTrieField;
import org.apache.solr.analytics.function.field.FloatField;
import org.apache.solr.analytics.function.field.FloatMultiPointField;
import org.apache.solr.analytics.function.field.FloatMultiTrieField;
import org.apache.solr.analytics.function.field.IntField;
import org.apache.solr.analytics.function.field.IntMultiPointField;
import org.apache.solr.analytics.function.field.IntMultiTrieField;
import org.apache.solr.analytics.function.field.LongField;
import org.apache.solr.analytics.function.field.LongMultiPointField;
import org.apache.solr.analytics.function.field.LongMultiTrieField;
import org.apache.solr.analytics.function.field.StringField;
import org.apache.solr.analytics.function.field.StringMultiField;
import org.apache.solr.analytics.function.mapping.AbsoluteValueFunction;
import org.apache.solr.analytics.function.mapping.AddFunction;
import org.apache.solr.analytics.function.mapping.BottomFunction;
import org.apache.solr.analytics.function.mapping.ComparisonFunction;
import org.apache.solr.analytics.function.mapping.ConcatFunction;
import org.apache.solr.analytics.function.mapping.DateMathFunction;
import org.apache.solr.analytics.function.mapping.DateParseFunction;
import org.apache.solr.analytics.function.mapping.DecimalNumericConversionFunction;
import org.apache.solr.analytics.function.mapping.DivideFunction;
import org.apache.solr.analytics.function.mapping.EqualFunction;
import org.apache.solr.analytics.function.mapping.ExistsFunction;
import org.apache.solr.analytics.function.mapping.FillMissingFunction;
import org.apache.solr.analytics.function.mapping.FilterFunction;
import org.apache.solr.analytics.function.mapping.IfFunction;
import org.apache.solr.analytics.function.mapping.LogFunction;
import org.apache.solr.analytics.function.mapping.LogicFunction;
import org.apache.solr.analytics.function.mapping.MultFunction;
import org.apache.solr.analytics.function.mapping.NegateFunction;
import org.apache.solr.analytics.function.mapping.PowerFunction;
import org.apache.solr.analytics.function.mapping.RemoveFunction;
import org.apache.solr.analytics.function.mapping.ReplaceFunction;
import org.apache.solr.analytics.function.mapping.StringCastFunction;
import org.apache.solr.analytics.function.mapping.SubtractFunction;
import org.apache.solr.analytics.function.mapping.TopFunction;
import org.apache.solr.analytics.function.reduction.CountFunction;
import org.apache.solr.analytics.function.reduction.DocCountFunction;
import org.apache.solr.analytics.function.reduction.MaxFunction;
import org.apache.solr.analytics.function.reduction.MeanFunction;
import org.apache.solr.analytics.function.reduction.MedianFunction;
import org.apache.solr.analytics.function.reduction.MinFunction;
import org.apache.solr.analytics.function.reduction.MissingFunction;
import org.apache.solr.analytics.function.reduction.OrdinalFunction;
import org.apache.solr.analytics.function.reduction.PercentileFunction;
import org.apache.solr.analytics.function.reduction.SumFunction;
import org.apache.solr.analytics.function.reduction.UniqueFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.constant.ConstantValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DatePointField;
import org.apache.solr.schema.DoublePointField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatPointField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IntPointField;
import org.apache.solr.schema.LongPointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;

public class ExpressionFactory {
    private static final Pattern functionNamePattern = Pattern.compile("^\\s*([^().\\s]+)\\s*(?:\\(.*\\)\\s*)?$", 2);
    private static final Pattern functionParamsPattern = Pattern.compile("^\\s*(?:[^(.)]+)\\s*\\(\\s*(.+)\\s*\\)\\s*$", 2);
    private static final String funtionVarParamUniqueName = ".%s_(%d)";
    public static final String variableLengthParamSuffix = "..";
    public static final char variableForEachSep = ':';
    public static final char variableForEachParam = '_';
    private HashMap<String, VariableFunctionInfo> systemVariableFunctions;
    private HashMap<String, VariableFunctionInfo> variableFunctions;
    private HashSet<String> variableFunctionNameHistory;
    private HashMap<String, CreatorFunction> expressionCreators;
    private final ConstantFunction constantCreator;
    private LinkedHashMap<String, ReductionFunction> reductionFunctions;
    private LinkedHashMap<String, ReductionDataCollector<?>> collectors;
    private LinkedHashMap<String, AnalyticsField> fields;
    private HashMap<String, AnalyticsValueStream> expressions;
    private IndexSchema schema;
    private Map<String, ReductionDataCollector<?>> groupedCollectors;
    private Map<String, AnalyticsField> groupedFields;
    private boolean isGrouped;

    public ExpressionFactory(IndexSchema schema) {
        this.schema = schema;
        this.expressionCreators = new HashMap();
        this.systemVariableFunctions = new HashMap();
        this.constantCreator = ConstantValue.creatorFunction;
        this.addSystemFunctions();
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public void startRequest() {
        this.reductionFunctions = new LinkedHashMap();
        this.collectors = new LinkedHashMap();
        this.fields = new LinkedHashMap();
        this.expressions = new HashMap();
        this.variableFunctions = new HashMap();
        this.variableFunctions.putAll(this.systemVariableFunctions);
        this.variableFunctionNameHistory = new HashSet();
        this.isGrouped = false;
    }

    public void startGrouping() {
        this.groupedCollectors = new HashMap();
        this.groupedFields = new HashMap<String, AnalyticsField>();
        this.isGrouped = true;
    }

    public ExpressionFactory addSystemFunction(String functionName, CreatorFunction functionCreator) throws SolrException {
        if (this.expressionCreators.containsKey(functionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "System function " + functionName + " defined twice.");
        }
        this.expressionCreators.put("count", CountFunction.creatorFunction);
        return this;
    }

    public ExpressionFactory addSystemVariableFunction(String functionName, String functionParams, String returnSignature) throws SolrException {
        return this.addVariableFunction(functionName, (String[])Arrays.stream(functionParams.split(",")).map(param -> param.trim()).toArray(String[]::new), returnSignature, this.systemVariableFunctions);
    }

    public ExpressionFactory addUserDefinedVariableFunction(String functionSignature, String returnSignature) throws SolrException {
        return this.addVariableFunction(functionSignature, returnSignature, this.variableFunctions);
    }

    private ExpressionFactory addVariableFunction(String functionSignature, String returnSignature, Map<String, VariableFunctionInfo> variableFunctions) throws SolrException {
        this.addVariableFunction(ExpressionFactory.getFunctionName(functionSignature), ExpressionFactory.getParams(functionSignature, null, null), returnSignature, variableFunctions);
        return this;
    }

    private ExpressionFactory addVariableFunction(String functionName, String[] functionParams, String returnSignature, Map<String, VariableFunctionInfo> variableFunctions) throws SolrException {
        if (this.expressionCreators.containsKey(functionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Users cannot define a variable function with the same name as an existing function: " + functionName);
        }
        VariableFunctionInfo varFuncInfo = new VariableFunctionInfo();
        varFuncInfo.params = functionParams;
        varFuncInfo.returnSignature = returnSignature;
        variableFunctions.put(functionName, varFuncInfo);
        return this;
    }

    public ReductionCollectionManager createReductionManager(boolean isCloudCollection) {
        ReductionDataCollector[] collectorsArr = new ReductionDataCollector[this.collectors.size()];
        this.collectors.values().toArray(collectorsArr);
        if (isCloudCollection) {
            return new MergingReductionCollectionManager(collectorsArr, this.fields.values());
        }
        return new ReductionCollectionManager(collectorsArr, this.fields.values());
    }

    public ReductionCollectionManager createGroupingReductionManager(boolean isCloudCollection) {
        ReductionDataCollector[] collectorsArr = new ReductionDataCollector[this.groupedCollectors.size()];
        this.groupedCollectors.values().toArray(collectorsArr);
        if (isCloudCollection) {
            return new MergingReductionCollectionManager(collectorsArr, this.groupedFields.values());
        }
        return new ReductionCollectionManager(collectorsArr, this.groupedFields.values());
    }

    public AnalyticsValueStream createExpression(String expressionStr) throws SolrException {
        return this.createExpression(expressionStr, new HashMap<String, AnalyticsValueStream>(), null, null);
    }

    private AnalyticsValueStream createExpression(String expressionStr, Map<String, AnalyticsValueStream> varFuncParams, String varFuncVarParamName, String[] varFuncVarParamValues) throws SolrException {
        AnalyticsValueStream expression;
        expressionStr = expressionStr.trim();
        boolean isField = false;
        try {
            expression = this.constantCreator.apply(expressionStr);
        }
        catch (SolrException e1) {
            if (!expressionStr.contains("(")) {
                expression = this.createField(this.schema.getField(expressionStr));
                isField = true;
            }
            expression = this.createFunction(expressionStr, varFuncParams, varFuncVarParamName, varFuncVarParamValues);
        }
        if (this.expressions.containsKey(expression.getExpressionStr())) {
            if ((expression = this.expressions.get(expression.getExpressionStr())).getExpressionType() == AnalyticsValueStream.ExpressionType.REDUCTION && this.isGrouped) {
                ((ReductionFunction)expression).synchronizeDataCollectors(collector -> {
                    this.groupedCollectors.put(collector.getExpressionStr(), (ReductionDataCollector<?>)collector);
                    return collector;
                });
            }
        } else {
            this.expressions.put(expression.getExpressionStr(), expression);
            if (expression.getExpressionType() == AnalyticsValueStream.ExpressionType.REDUCTION) {
                this.reductionFunctions.put(expression.getExpressionStr(), (ReductionFunction)expression);
                ((ReductionFunction)expression).synchronizeDataCollectors(collector -> {
                    String collectorStr = collector.getExpressionStr();
                    ReductionDataCollector usedCollector = this.collectors.get(collectorStr);
                    if (usedCollector == null) {
                        usedCollector = collector;
                        this.collectors.put(collectorStr, (ReductionDataCollector<?>)collector);
                    }
                    if (this.isGrouped) {
                        this.groupedCollectors.put(collectorStr, usedCollector);
                    }
                    return usedCollector;
                });
            }
            if (isField) {
                this.fields.put(expression.getExpressionStr(), (AnalyticsField)expression);
            }
        }
        if (isField && this.isGrouped) {
            this.groupedFields.put(expression.getExpressionStr(), (AnalyticsField)expression);
        }
        return expression;
    }

    private AnalyticsValueStream createFunction(String expressionStr, Map<String, AnalyticsValueStream> varFuncParams, String varFuncVarParamName, String[] varFuncVarParamValues) throws SolrException {
        AnalyticsValueStream expression = null;
        String name = ExpressionFactory.getFunctionName(expressionStr);
        String[] params = ExpressionFactory.getParams(expressionStr, varFuncVarParamName, varFuncVarParamValues);
        AnalyticsValueStream[] paramStreams = new AnalyticsValueStream[params.length];
        boolean allParamsConstant = true;
        for (int i = 0; i < params.length; ++i) {
            paramStreams[i] = varFuncParams.containsKey(params[i]) ? varFuncParams.get(params[i]) : this.createExpression(params[i], varFuncParams, varFuncVarParamName, varFuncVarParamValues);
            allParamsConstant &= paramStreams[i].getExpressionType().equals((Object)AnalyticsValueStream.ExpressionType.CONST);
        }
        if (this.variableFunctions.containsKey(name)) {
            if (this.variableFunctionNameHistory.contains(name)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The following variable function is self referencing : " + name);
            }
            this.variableFunctionNameHistory.add(name);
            VariableFunctionInfo newVarFunc = this.variableFunctions.get(name);
            HashMap<String, AnalyticsValueStream> newVarFuncParams = new HashMap<String, AnalyticsValueStream>();
            boolean varLenEnd = false;
            if (paramStreams.length < newVarFunc.params.length) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The variable function '" + name + "' requires at least " + newVarFunc.params.length + " parameters. Only " + paramStreams.length + " arguments given in the following invocation : " + expressionStr);
            }
            for (int i = 0; i < newVarFunc.params.length; ++i) {
                String variable = newVarFunc.params[i];
                if (variable.endsWith(variableLengthParamSuffix)) {
                    if (i != newVarFunc.params.length - 1) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The following invocation of a variable function has the incorrect number of arguments : " + expressionStr);
                    }
                    variable = variable.substring(0, variable.length() - variableLengthParamSuffix.length()).trim();
                    int numVars = paramStreams.length - i;
                    String[] newVarFuncVarParamValues = new String[numVars];
                    for (int j = 0; j < numVars; ++j) {
                        String paramName;
                        newVarFuncVarParamValues[j] = paramName = String.format(Locale.ROOT, funtionVarParamUniqueName, variable, j);
                        newVarFuncParams.put(paramName, paramStreams[i + j]);
                    }
                    expression = this.createFunction(newVarFunc.returnSignature, newVarFuncParams, variable, newVarFuncVarParamValues);
                    varLenEnd = true;
                    continue;
                }
                newVarFuncParams.put(variable, paramStreams[i]);
            }
            if (!varLenEnd) {
                if (paramStreams.length > newVarFunc.params.length) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The variable function '" + name + "' requires " + newVarFunc.params.length + " parameters. " + paramStreams.length + " arguments given in the following invocation : " + expressionStr);
                }
                expression = this.createExpression(newVarFunc.returnSignature, newVarFuncParams, null, null);
            }
            this.variableFunctionNameHistory.remove(name);
        } else if (this.expressionCreators.containsKey(name)) {
            expression = this.expressionCreators.get(name).apply(paramStreams);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The following function does not exist: " + name);
        }
        expression = expression.convertToConstant();
        return expression;
    }

    private AnalyticsField createField(SchemaField field) throws SolrException {
        AnalyticsField aField;
        String fieldName = field.getName();
        if (this.fields.containsKey(fieldName)) {
            return this.fields.get(fieldName);
        }
        if (!field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The field " + fieldName + " does not have docValues enabled.");
        }
        boolean multivalued = field.multiValued();
        FieldType fieldType = field.getType();
        if (fieldType instanceof BoolField) {
            aField = multivalued ? new BooleanMultiField(fieldName) : new BooleanField(fieldName);
        } else if (fieldType instanceof TrieIntField) {
            aField = multivalued ? new IntMultiTrieField(fieldName) : new IntField(fieldName);
        } else if (fieldType instanceof IntPointField) {
            aField = multivalued ? new IntMultiPointField(fieldName) : new IntField(fieldName);
        } else if (fieldType instanceof TrieLongField) {
            aField = multivalued ? new LongMultiTrieField(fieldName) : new LongField(fieldName);
        } else if (fieldType instanceof LongPointField) {
            aField = multivalued ? new LongMultiPointField(fieldName) : new LongField(fieldName);
        } else if (fieldType instanceof TrieFloatField) {
            aField = multivalued ? new FloatMultiTrieField(fieldName) : new FloatField(fieldName);
        } else if (fieldType instanceof FloatPointField) {
            aField = multivalued ? new FloatMultiPointField(fieldName) : new FloatField(fieldName);
        } else if (fieldType instanceof TrieDoubleField) {
            aField = multivalued ? new DoubleMultiTrieField(fieldName) : new DoubleField(fieldName);
        } else if (fieldType instanceof DoublePointField) {
            aField = multivalued ? new DoubleMultiPointField(fieldName) : new DoubleField(fieldName);
        } else if (fieldType instanceof TrieDateField) {
            aField = multivalued ? new DateMultiTrieField(fieldName) : new DateField(fieldName);
        } else if (fieldType instanceof DatePointField) {
            aField = multivalued ? new DateMultiPointField(fieldName) : new DateField(fieldName);
        } else if (fieldType instanceof StrField) {
            aField = multivalued ? new StringMultiField(fieldName) : new StringField(fieldName);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "FieldType of the following field not supported by analytics: " + fieldName);
        }
        return aField;
    }

    private static String getFunctionName(String expression) throws SolrException {
        Matcher m = functionNamePattern.matcher(expression);
        if (!m.matches()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The following function has no name: " + expression);
        }
        String name = m.group(1);
        return name;
    }

    private static String[] getFunctionParams(String function) throws SolrException {
        return ExpressionFactory.getParams(function, null, null);
    }

    private static String[] getParams(String expression, String varLengthParamName, String[] varLengthParamValues) throws SolrException {
        Matcher m = functionParamsPattern.matcher(expression);
        if (!m.matches()) {
            return new String[0];
        }
        String paramsStr = m.group(1);
        ArrayList<String> paramsList = new ArrayList<String>();
        StringBuilder param = new StringBuilder();
        boolean inForEach = false;
        int forEachStart = -1;
        int forEachIter = -1;
        int forEachLevel = -1;
        int parenCount = 0;
        boolean singleQuoteOn = false;
        boolean doubleQuoteOn = false;
        boolean quoteOn = false;
        boolean escaped = false;
        char[] chars = paramsStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == ' ' && !quoteOn) continue;
            if (c == ',' && parenCount == 0 && !quoteOn) {
                String paramStr = param.toString();
                if (paramStr.length() == 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Empty parameter in expression: " + expression);
                }
                if (paramStr.equals(varLengthParamName)) {
                    for (String paramName : varLengthParamValues) {
                        paramsList.add(paramName);
                    }
                } else {
                    paramsList.add(paramStr);
                }
                param.setLength(0);
                continue;
            }
            if (c == ',' && !quoteOn && inForEach) {
                if (param.charAt(param.length() - 1) == '_' && (param.charAt(param.length() - 2) == '(' || param.charAt(param.length() - 2) == ',')) {
                    param.setLength(param.length() - 1);
                    param.append(varLengthParamValues[forEachIter++]);
                }
            } else if (c == '\"' && !singleQuoteOn) {
                if (doubleQuoteOn && !escaped) {
                    doubleQuoteOn = false;
                    quoteOn = false;
                } else if (!quoteOn) {
                    doubleQuoteOn = true;
                    quoteOn = true;
                } else {
                    escaped = false;
                }
            } else if (c == '\'' && !doubleQuoteOn) {
                if (singleQuoteOn && !escaped) {
                    singleQuoteOn = false;
                    quoteOn = false;
                } else if (!singleQuoteOn) {
                    singleQuoteOn = true;
                    quoteOn = true;
                } else {
                    escaped = false;
                }
            } else if (c == '(' && !quoteOn) {
                ++parenCount;
            } else if (c == ')' && !quoteOn) {
                if (--parenCount < 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The following expression has extra end parens: " + param.toString());
                }
                if (inForEach) {
                    if (param.charAt(param.length() - 1) == '_' && (param.charAt(param.length() - 2) == '(' || param.charAt(param.length() - 2) == ',')) {
                        param.setLength(param.length() - 1);
                        param.append(varLengthParamValues[forEachIter++]);
                    }
                    if (forEachLevel == parenCount) {
                        if (forEachIter == 0) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "For each statement for variable '" + varLengthParamName + "' has no use of lambda variable _");
                        }
                        if (forEachIter < varLengthParamValues.length) {
                            if (parenCount == 0) {
                                param.append(')');
                                paramsList.add(param.toString());
                                param.setLength(0);
                            } else {
                                param.append(')');
                                param.append(',');
                            }
                            i = forEachStart;
                            continue;
                        }
                        inForEach = false;
                    }
                }
            }
            if (c == '\\') {
                if (!quoteOn) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The following expression has escaped characters outside of quotation marks: " + expression.toString());
                }
                if (escaped) {
                    escaped = false;
                } else {
                    escaped = true;
                    if (parenCount == 0) {
                        continue;
                    }
                }
            } else if (escaped) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid escape character '" + c + "' used in the following expression: " + expression.toString());
            }
            if (c == ':' && !quoteOn && varLengthParamName != null) {
                int varStart = param.length() - varLengthParamName.length();
                if (param.subSequence(varStart, param.length()).equals(varLengthParamName)) {
                    inForEach = true;
                    forEachStart = i;
                    forEachIter = 0;
                    forEachLevel = parenCount;
                    param.setLength(varStart);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "For-each called on invalid parameter '" + param.toString().trim());
            }
            param.append(c);
        }
        String paramStr = param.toString().trim();
        if (paramStr.length() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Empty parameter in expression: " + expression);
        }
        if (parenCount > 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The following expression needs more end parens: " + param.toString());
        }
        if (quoteOn) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Misplaced quotation marks in expression: " + expression);
        }
        if (paramStr.equals(varLengthParamName)) {
            for (String paramName : varLengthParamValues) {
                paramsList.add(paramName);
            }
        } else {
            paramsList.add(paramStr);
        }
        return paramsList.toArray(new String[paramsList.size()]);
    }

    public void addSystemFunctions() {
        this.expressionCreators.put("abs", AbsoluteValueFunction.creatorFunction);
        this.expressionCreators.put("and", LogicFunction.AndFunction.creatorFunction);
        this.expressionCreators.put("add", AddFunction.creatorFunction);
        this.expressionCreators.put("bottom", BottomFunction.creatorFunction);
        this.expressionCreators.put("ceil", DecimalNumericConversionFunction.CeilingFunction.creatorFunction);
        this.expressionCreators.put("concat", ConcatFunction.creatorFunction);
        this.expressionCreators.put("concat_sep", ConcatFunction.SeparatedConcatFunction.creatorFunction);
        this.expressionCreators.put("date_math", DateMathFunction.creatorFunction);
        this.expressionCreators.put("date", DateParseFunction.creatorFunction);
        this.expressionCreators.put("div", DivideFunction.creatorFunction);
        this.expressionCreators.put("equal", EqualFunction.creatorFunction);
        this.expressionCreators.put("exists", ExistsFunction.creatorFunction);
        this.expressionCreators.put("fill_missing", FillMissingFunction.creatorFunction);
        this.expressionCreators.put("filter", FilterFunction.creatorFunction);
        this.expressionCreators.put("floor", DecimalNumericConversionFunction.FloorFunction.creatorFunction);
        this.expressionCreators.put("gt", ComparisonFunction.GTFunction.creatorFunction);
        this.expressionCreators.put("gte", ComparisonFunction.GTEFunction.creatorFunction);
        this.expressionCreators.put("if", IfFunction.creatorFunction);
        this.expressionCreators.put("log", LogFunction.creatorFunction);
        this.expressionCreators.put("lt", ComparisonFunction.LTFunction.creatorFunction);
        this.expressionCreators.put("lte", ComparisonFunction.LTEFunction.creatorFunction);
        this.expressionCreators.put("mult", MultFunction.creatorFunction);
        this.expressionCreators.put("neg", NegateFunction.creatorFunction);
        this.expressionCreators.put("or", LogicFunction.OrFunction.creatorFunction);
        this.expressionCreators.put("pow", PowerFunction.creatorFunction);
        this.expressionCreators.put("replace", ReplaceFunction.creatorFunction);
        this.expressionCreators.put("remove", RemoveFunction.creatorFunction);
        this.expressionCreators.put("round", DecimalNumericConversionFunction.RoundFunction.creatorFunction);
        this.expressionCreators.put("string", StringCastFunction.creatorFunction);
        this.expressionCreators.put("sub", SubtractFunction.creatorFunction);
        this.expressionCreators.put("top", TopFunction.creatorFunction);
        this.expressionCreators.put("count", CountFunction.creatorFunction);
        this.expressionCreators.put("doc_count", DocCountFunction.creatorFunction);
        this.expressionCreators.put("max", MaxFunction.creatorFunction);
        this.expressionCreators.put("mean", MeanFunction.creatorFunction);
        this.expressionCreators.put("median", MedianFunction.creatorFunction);
        this.expressionCreators.put("min", MinFunction.creatorFunction);
        this.expressionCreators.put("missing", MissingFunction.creatorFunction);
        this.expressionCreators.put("ordinal", OrdinalFunction.creatorFunction);
        this.expressionCreators.put("percentile", PercentileFunction.creatorFunction);
        this.expressionCreators.put("sum", SumFunction.creatorFunction);
        this.expressionCreators.put("unique", UniqueFunction.creatorFunction);
        this.addSystemVariableFunction("wmean", "a,b", "div(sum(mult(a,b)),sum(filter(b,exists(a))))");
        this.addSystemVariableFunction("sumofsquares", "a", "sum(pow(a,2))");
        this.addSystemVariableFunction("sqrt", "a", "pow(a,0.5)");
        this.addSystemVariableFunction("variance", "a", "sub(mean(pow(a,2)),pow(mean(a),2))");
        this.addSystemVariableFunction("stddev", "a", "sqrt(variance(a))");
        this.addSystemVariableFunction("csv", "a..", "concat_sep(',',a)");
        this.addSystemVariableFunction("csv_output", "a..", "concat_sep(',',a:fill_missing(concat_sep(';',_),''))");
    }

    static class CSVOutputVariableFunction {
        public static final String name = "csv_output";
        public static final String params = "a..";
        public static final String function = "concat_sep(',',a:fill_missing(concat_sep(';',_),''))";

        CSVOutputVariableFunction() {
        }
    }

    static class CSVVariableFunction {
        public static final String name = "csv";
        public static final String params = "a..";
        public static final String function = "concat_sep(',',a)";

        CSVVariableFunction() {
        }
    }

    static class SandardDeviationVariableFunction {
        public static final String name = "stddev";
        public static final String params = "a";
        public static final String function = "sqrt(variance(a))";

        SandardDeviationVariableFunction() {
        }
    }

    static class VarianceVariableFunction {
        public static final String name = "variance";
        public static final String params = "a";
        public static final String function = "sub(mean(pow(a,2)),pow(mean(a),2))";

        VarianceVariableFunction() {
        }
    }

    static class SquareRootVariableFunction {
        public static final String name = "sqrt";
        public static final String params = "a";
        public static final String function = "pow(a,0.5)";

        SquareRootVariableFunction() {
        }
    }

    static class SumOfSquaresVariableFunction {
        public static final String name = "sumofsquares";
        public static final String params = "a";
        public static final String function = "sum(pow(a,2))";

        SumOfSquaresVariableFunction() {
        }
    }

    static class WeightedMeanVariableFunction {
        public static final String name = "wmean";
        public static final String params = "a,b";
        public static final String function = "div(sum(mult(a,b)),sum(filter(b,exists(a))))";

        WeightedMeanVariableFunction() {
        }
    }

    static class VariableFunctionInfo {
        public String[] params;
        public String returnSignature;

        VariableFunctionInfo() {
        }
    }

    @FunctionalInterface
    public static interface ConstantFunction {
        public AnalyticsValueStream apply(String var1) throws SolrException;
    }

    @FunctionalInterface
    public static interface CreatorFunction {
        public AnalyticsValueStream apply(AnalyticsValueStream[] var1) throws SolrException;
    }
}

