/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.analytics.AnalyticsDriver;
import org.apache.solr.analytics.AnalyticsRequestManager;
import org.apache.solr.analytics.AnalyticsRequestParser;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.TimeExceededStubException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.AnalyticsShardResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrQueryTimeoutImpl;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;

public class AnalyticsHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    public static final String NAME = "/analytics";
    private IndexSchema indexSchema;

    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    public void inform(SolrCore core) {
        core.registerResponseWriter("analytics_shard_stream", (QueryResponseWriter)new AnalyticsShardResponseWriter());
        this.indexSchema = core.getLatestSchema();
        AnalyticsRequestParser.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrQueryTimeoutImpl.set((SolrQueryRequest)req);
        try {
            DocSet docs;
            try {
                docs = this.getDocuments(req);
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            AnalyticsRequestManager manager = AnalyticsRequestParser.parse(req.getParams().get("analytics"), new ExpressionFactory(this.indexSchema), false);
            SolrIndexSearcher searcher = req.getSearcher();
            AnalyticsDriver.drive(manager, searcher, docs, req);
            rsp.addResponse((Object)new AnalyticsShardResponseWriter.AnalyticsResponse(manager));
        }
        catch (SolrException e) {
            rsp.addResponse((Object)new AnalyticsShardResponseWriter.AnalyticsResponse(e));
        }
        catch (ExitableDirectoryReader.ExitingReaderException e) {
            rsp.addResponse((Object)new AnalyticsShardResponseWriter.AnalyticsResponse(new TimeExceededStubException(e)));
        }
        finally {
            SolrQueryTimeoutImpl.reset();
        }
    }

    private DocSet getDocuments(SolrQueryRequest req) throws SyntaxError, IOException {
        String defType;
        SolrParams params = req.getParams();
        ArrayList<Query> queries = new ArrayList<Query>();
        String queryString = params.get("q");
        QParser parser = QParser.getParser((String)queryString, (String)(defType = params.get("defType", "lucene")), (SolrQueryRequest)req);
        Query query = parser.getQuery();
        if (query == null) {
            query = new MatchNoDocsQuery();
        }
        queries.add(query);
        queries.addAll(QueryUtils.parseFilterQueries((SolrQueryRequest)req, (boolean)false));
        return req.getSearcher().getDocSet(queries);
    }

    public String getDescription() {
        return NAME;
    }

    public String getSource() {
        return null;
    }
}

