/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

public class LogFunction {
    public static final String name = "log";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The log function requires at least 1.");
        }
        if (params.length == 1) {
            return LambdaFunction.createDoubleLambdaFunction(name, a -> Math.log(a), (DoubleValueStream)params[0]);
        }
        if (params.length == 2) {
            return LambdaFunction.createDoubleLambdaFunction(name, (a, b) -> Math.log(a) / Math.log(b), (DoubleValueStream)params[0], (DoubleValueStream)params[1]);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The log function accepts at most 2 paramaters, " + params.length + " found.");
    };
}

