/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DateUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.handler.extraction.ExtractingDocumentLoader;
import org.apache.solr.handler.extraction.SolrContentHandlerFactory;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractingRequestHandler
extends ContentStreamHandlerBase
implements SolrCoreAware {
    private static transient Logger log = LoggerFactory.getLogger(ExtractingRequestHandler.class);
    public static final String CONFIG_LOCATION = "tika.config";
    public static final String DATE_FORMATS = "date.formats";
    protected TikaConfig config;
    protected Collection<String> dateFormats = DateUtil.DEFAULT_DATE_FORMATS;
    protected SolrContentHandlerFactory factory;

    public void init(NamedList args) {
        super.init(args);
    }

    public void inform(SolrCore core) {
        if (this.initArgs != null) {
            String tikaConfigLoc = (String)this.initArgs.get(CONFIG_LOCATION);
            if (tikaConfigLoc != null) {
                File configFile = new File(tikaConfigLoc);
                if (!configFile.isAbsolute()) {
                    configFile = new File(core.getResourceLoader().getConfigDir(), configFile.getPath());
                }
                try {
                    this.config = new TikaConfig(configFile);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
            try {
                this.config = TikaConfig.getDefaultConfig();
            }
            catch (TikaException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            NamedList configDateFormats = (NamedList)this.initArgs.get(DATE_FORMATS);
            if (configDateFormats != null && configDateFormats.size() > 0) {
                this.dateFormats = new HashSet<String>();
                while (configDateFormats.iterator().hasNext()) {
                    String format = (String)configDateFormats.iterator().next();
                    log.info("Adding Date Format: " + format);
                    this.dateFormats.add(format);
                }
            }
        } else {
            try {
                this.config = TikaConfig.getDefaultConfig();
            }
            catch (TikaException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        this.factory = this.createFactory();
    }

    protected SolrContentHandlerFactory createFactory() {
        return new SolrContentHandlerFactory(this.dateFormats);
    }

    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        return new ExtractingDocumentLoader(req, processor, this.config, this.factory);
    }

    public String getDescription() {
        return "Add/Update Rich document";
    }

    public String getVersion() {
        return "$Revision:$";
    }

    public String getSourceId() {
        return "$Id:$";
    }

    public String getSource() {
        return "$URL:$";
    }
}

