/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DateUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.extraction.ExtractingDocumentLoader;
import org.apache.solr.handler.extraction.SolrContentHandlerFactory;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MimeTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractingRequestHandler
extends ContentStreamHandlerBase
implements SolrCoreAware {
    private static transient Logger log = LoggerFactory.getLogger(ExtractingRequestHandler.class);
    public static final String CONFIG_LOCATION = "tika.config";
    public static final String DATE_FORMATS = "date.formats";
    protected TikaConfig config;
    protected Collection<String> dateFormats = DateUtil.DEFAULT_DATE_FORMATS;
    protected SolrContentHandlerFactory factory;

    public void init(NamedList args) {
        super.init(args);
    }

    public void inform(SolrCore core) {
        if (this.initArgs != null) {
            NamedList configDateFormats;
            String tikaConfigLoc = (String)this.initArgs.get(CONFIG_LOCATION);
            if (tikaConfigLoc != null) {
                File configFile = new File(tikaConfigLoc);
                if (!configFile.isAbsolute()) {
                    configFile = new File(core.getResourceLoader().getConfigDir(), configFile.getPath());
                }
                try {
                    this.config = new TikaConfig(configFile);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
            if ((configDateFormats = (NamedList)this.initArgs.get(DATE_FORMATS)) != null && configDateFormats.size() > 0) {
                this.dateFormats = new HashSet<String>();
                Iterator it = configDateFormats.iterator();
                while (it.hasNext()) {
                    String format = (String)((Map.Entry)it.next()).getValue();
                    log.info("Adding Date Format: " + format);
                    this.dateFormats.add(format);
                }
            }
        }
        if (this.config == null) {
            try {
                this.config = this.getDefaultConfig(core.getResourceLoader().getClassLoader());
            }
            catch (MimeTypeException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        this.factory = this.createFactory();
    }

    private TikaConfig getDefaultConfig(ClassLoader classLoader) throws MimeTypeException, IOException {
        return new TikaConfig(classLoader);
    }

    protected SolrContentHandlerFactory createFactory() {
        return new SolrContentHandlerFactory(this.dateFormats);
    }

    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        return new ExtractingDocumentLoader(req, processor, this.config, this.factory);
    }

    public String getDescription() {
        return "Add/Update Rich document";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_5/solr/contrib/extraction/src/java/org/apache/solr/handler/extraction/ExtractingRequestHandler.java $";
    }
}

