/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.TabularResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.ReturnFields;

class XLSXWriter
extends TabularResponseWriter {
    private SerialWriteWorkbook wb = new SerialWriteWorkbook();
    private Map<String, XLField> xlFields = new LinkedHashMap<String, XLField>();
    List tmpList;

    public XLSXWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
    }

    public void writeResponse(OutputStream out, LinkedHashMap<String, String> colNamesMap, LinkedHashMap<String, Integer> colWidthsMap) throws IOException {
        Collection fields = this.getFields();
        for (String field : fields) {
            if (!this.returnFields.wantsField(field)) continue;
            if (field.equals("score")) {
                XLField xlField = new XLField();
                xlField.name = "score";
                this.xlFields.put("score", xlField);
                continue;
            }
            if (this.shouldSkipField(field)) continue;
            SchemaField sf = this.schema.getFieldOrNull(field);
            if (sf == null) {
                StrField ft = new StrField();
                sf = new SchemaField(field, (FieldType)ft);
            }
            XLField xlField = new XLField();
            xlField.name = field;
            xlField.sf = sf;
            this.xlFields.put(field, xlField);
        }
        this.wb.addRow();
        for (XLField xlField : this.xlFields.values()) {
            Integer niceWidth;
            String printName = xlField.name;
            int colWidth = 14;
            String niceName = colNamesMap.get(xlField.name);
            if (niceName != null) {
                printName = niceName;
            }
            if ((niceWidth = colWidthsMap.get(xlField.name)) != null) {
                colWidth = niceWidth;
            }
            this.writeStr(xlField.name, printName, false);
            this.wb.setColWidth(colWidth);
            this.wb.setHeaderCell();
        }
        this.wb.setHeaderRow();
        this.wb.addRow();
        this.writeResponse(this.rsp.getResponse());
        this.wb.flush(out);
        this.wb = null;
    }

    public void close() throws IOException {
        super.close();
    }

    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        if (this.tmpList == null) {
            this.tmpList = new ArrayList(1);
            this.tmpList.add(null);
        }
        for (XLField xlField : this.xlFields.values()) {
            Collection values;
            int nVals;
            Object val = doc.getFieldValue(xlField.name);
            int n = val instanceof Collection ? ((Collection)val).size() : (nVals = val == null ? 0 : 1);
            if (nVals == 0) {
                this.writeNull(xlField.name);
                continue;
            }
            if (xlField.sf != null && xlField.sf.multiValued() || nVals > 1) {
                if (val instanceof Collection) {
                    values = (Collection)val;
                } else {
                    this.tmpList.set(0, val);
                    values = this.tmpList;
                }
                this.writeArray(xlField.name, values.iterator());
                continue;
            }
            if (val instanceof Collection) {
                values = (Collection)val;
                val = values.iterator().next();
            }
            this.writeVal(xlField.name, val);
        }
        this.wb.addRow();
    }

    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        this.wb.writeCell(val);
    }

    public void writeArray(String name, Iterator val) throws IOException {
        StringBuffer output = new StringBuffer();
        while (val.hasNext()) {
            Object v = val.next();
            if (v instanceof IndexableField) {
                IndexableField f = (IndexableField)v;
                if (v instanceof Date) {
                    output.append(((Date)((Object)val)).toInstant().toString() + "; ");
                    continue;
                }
                output.append(f.stringValue() + "; ");
                continue;
            }
            output.append(v.toString() + "; ");
        }
        if (output.length() > 0) {
            output.deleteCharAt(output.length() - 1);
            output.deleteCharAt(output.length() - 1);
        }
        this.writeStr(name, output.toString(), false);
    }

    public void writeNull(String name) throws IOException {
        this.wb.writeCell("");
    }

    public void writeInt(String name, String val) throws IOException {
        this.wb.writeCell(val);
    }

    public void writeLong(String name, String val) throws IOException {
        this.wb.writeCell(val);
    }

    public void writeBool(String name, String val) throws IOException {
        this.wb.writeCell(val);
    }

    public void writeFloat(String name, String val) throws IOException {
        this.wb.writeCell(val);
    }

    public void writeDouble(String name, String val) throws IOException {
        this.wb.writeCell(val);
    }

    public void writeDate(String name, String val) throws IOException {
        this.wb.writeCell(val);
    }

    static class XLField {
        String name;
        SchemaField sf;

        XLField() {
        }
    }

    static class SerialWriteWorkbook {
        SXSSFWorkbook swb = new SXSSFWorkbook(100);
        Sheet sh = this.swb.createSheet();
        XSSFCellStyle headerStyle = (XSSFCellStyle)this.swb.createCellStyle();
        int rowIndex = 0;
        Row curRow;
        int cellIndex;

        SerialWriteWorkbook() {
            this.headerStyle.setFillBackgroundColor(IndexedColors.BLACK.getIndex());
            this.headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            Font headerFont = this.swb.createFont();
            headerFont.setFontHeightInPoints((short)14);
            headerFont.setBold(true);
            headerFont.setColor(IndexedColors.WHITE.getIndex());
            this.headerStyle.setFont(headerFont);
        }

        void addRow() {
            this.curRow = this.sh.createRow(this.rowIndex++);
            this.cellIndex = 0;
        }

        void setHeaderRow() {
            this.curRow.setHeightInPoints(21.0f);
        }

        void setHeaderCell() {
            this.curRow.getCell(this.cellIndex - 1).setCellStyle((CellStyle)this.headerStyle);
        }

        void setColWidth(int charWidth) {
            this.sh.setColumnWidth(this.cellIndex - 1, 256 * charWidth);
        }

        void writeCell(String value) {
            Cell cell = this.curRow.createCell(this.cellIndex++);
            cell.setCellValue(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flush(OutputStream out) {
            try {
                this.swb.write(out);
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String string = sw.toString();
            }
            finally {
                this.swb.dispose();
            }
        }
    }
}

