/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering.carrot2;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.clustering.SearchClusteringEngine;
import org.apache.solr.handler.clustering.carrot2.CarrotParams;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.SolrIndexSearcher;
import org.carrot2.core.CachingController;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.IClusteringAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarrotClusteringEngine
extends SearchClusteringEngine {
    private static transient Logger log = LoggerFactory.getLogger(CarrotClusteringEngine.class);
    private CachingController controller = new CachingController(new Class[0]);
    private Class<? extends IClusteringAlgorithm> clusteringAlgorithmClass;
    private String idFieldName;

    @Override
    public Object cluster(Query query, DocList docList, SolrQueryRequest sreq) {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            List<Document> documents = this.getDocuments(docList, query, sreq);
            attributes.put("documents", documents);
            attributes.put("query", query.toString());
            this.extractCarrotAttributes(sreq.getParams(), attributes);
            return this.clustersToNamedList(this.controller.process(attributes, new Class[]{this.clusteringAlgorithmClass}).getClusters(), sreq.getParams());
        }
        catch (Exception e) {
            log.error("Carrot2 clustering failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String init(NamedList config, SolrCore core) {
        String result = super.init(config, core);
        SolrParams initParams = SolrParams.toSolrParams((NamedList)config);
        HashMap<String, Object> initAttributes = new HashMap<String, Object>();
        this.extractCarrotAttributes(initParams, initAttributes);
        this.controller.init(initAttributes);
        this.idFieldName = core.getSchema().getUniqueKeyField().getName();
        String carrotAlgorithmClassName = initParams.get("carrot.algorithm");
        Class algorithmClass = core.getResourceLoader().findClass(carrotAlgorithmClassName, new String[0]);
        if (!IClusteringAlgorithm.class.isAssignableFrom(algorithmClass)) {
            throw new IllegalArgumentException("Class provided as carrot.algorithm must implement " + IClusteringAlgorithm.class.getName());
        }
        this.clusteringAlgorithmClass = algorithmClass;
        return result;
    }

    private List<Document> getDocuments(DocList docList, Query query, final SolrQueryRequest sreq) throws IOException {
        SolrHighlighter highligher = null;
        SolrParams solrParams = sreq.getParams();
        SolrCore core = sreq.getCore();
        String urlField = solrParams.get("carrot.url", "url");
        String titleField = solrParams.get("carrot.title", "title");
        String snippetField = solrParams.get("carrot.snippet", titleField);
        if (StringUtils.isBlank((String)snippetField)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "carrot.snippet must not be blank.");
        }
        HashSet fieldsToLoad = Sets.newHashSet((Object[])new String[]{urlField, titleField, snippetField, this.idFieldName});
        DocIterator docsIter = docList.iterator();
        boolean produceSummary = solrParams.getBool("carrot.produceSummary", false);
        LocalSolrQueryRequest req = null;
        String[] snippetFieldAry = null;
        if (produceSummary) {
            highligher = core.getHighlighter();
            HashMap<String, Object> args = new HashMap<String, Object>();
            snippetFieldAry = new String[]{snippetField};
            args.put("hl.fl", snippetFieldAry);
            args.put("hl", "true");
            req = new LocalSolrQueryRequest(core, query.toString(), "", 0, 1, args){

                public SolrIndexSearcher getSearcher() {
                    return sreq.getSearcher();
                }
            };
        }
        SolrIndexSearcher searcher = sreq.getSearcher();
        ArrayList<Document> result = new ArrayList<Document>(docList.size());
        SetBasedFieldSelector fieldSelector = new SetBasedFieldSelector((Set)fieldsToLoad, Collections.emptySet());
        float[] scores = new float[]{1.0f};
        int[] docsHolder = new int[1];
        Query theQuery = query;
        while (docsIter.hasNext()) {
            Integer id = (Integer)docsIter.next();
            org.apache.lucene.document.Document doc = searcher.doc(id.intValue(), (FieldSelector)fieldSelector);
            String snippet = this.getValue(doc, snippetField);
            if (produceSummary) {
                docsHolder[0] = id;
                DocSlice docAsList = new DocSlice(0, 1, docsHolder, scores, 1, 1.0f);
                highligher.doHighlighting((DocList)docAsList, theQuery, (SolrQueryRequest)req, snippetFieldAry);
            }
            Document carrotDocument = new Document(this.getValue(doc, titleField), snippet, doc.get(urlField));
            carrotDocument.addField("solrId", (Object)doc.get(this.idFieldName));
            result.add(carrotDocument);
        }
        return result;
    }

    protected String getValue(org.apache.lucene.document.Document doc, String field) {
        StringBuilder result = new StringBuilder();
        String[] vals = doc.getValues(field);
        for (int i = 0; i < vals.length; ++i) {
            result.append(vals[i]).append(" . ");
        }
        return result.toString().trim();
    }

    private List clustersToNamedList(List<Cluster> carrotClusters, SolrParams solrParams) {
        ArrayList result = new ArrayList();
        this.clustersToNamedList(carrotClusters, result, solrParams.getBool("carrot.outputSubClusters", true), solrParams.getInt("carrot.numDescriptions", Integer.MAX_VALUE));
        return result;
    }

    private void clustersToNamedList(List<Cluster> outputClusters, List parent, boolean outputSubClusters, int maxLabels) {
        for (Cluster outCluster : outputClusters) {
            SimpleOrderedMap cluster = new SimpleOrderedMap();
            parent.add(cluster);
            List labels = outCluster.getPhrases();
            if (labels.size() > maxLabels) {
                labels = labels.subList(0, maxLabels);
            }
            cluster.add("labels", (Object)labels);
            List docs = outputSubClusters ? outCluster.getDocuments() : outCluster.getAllDocuments();
            ArrayList<Object> docList = new ArrayList<Object>();
            cluster.add("docs", docList);
            for (Document doc : docs) {
                docList.add(doc.getField("solrId"));
            }
            if (!outputSubClusters) continue;
            ArrayList subclusters = new ArrayList();
            cluster.add("clusters", subclusters);
            this.clustersToNamedList(outCluster.getSubclusters(), subclusters, outputSubClusters, maxLabels);
        }
    }

    private void extractCarrotAttributes(SolrParams solrParams, Map<String, Object> attributes) {
        Iterator paramNames = solrParams.getParameterNamesIterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            if (CarrotParams.CARROT_PARAM_NAMES.contains(paramName)) continue;
            attributes.put(paramName, solrParams.get(paramName));
        }
    }
}

