/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering.carrot2;

import java.nio.CharBuffer;
import java.util.HashMap;
import org.apache.lucene.analysis.ar.ArabicNormalizer;
import org.apache.lucene.analysis.ar.ArabicStemmer;
import org.carrot2.core.LanguageCode;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.linguistic.IStemmerFactory;
import org.carrot2.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.DanishStemmer;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FinnishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.GermanStemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.NorwegianStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;

public class LuceneCarrot2StemmerFactory
implements IStemmerFactory {
    static final Logger logger = LoggerFactory.getLogger(LuceneCarrot2StemmerFactory.class);

    public IStemmer getStemmer(LanguageCode language) {
        switch (language) {
            case ARABIC: {
                return ArabicStemmerFactory.createStemmer();
            }
            case CHINESE_SIMPLIFIED: {
                return IdentityStemmer.INSTANCE;
            }
        }
        return SnowballStemmerFactory.createStemmer(language);
    }

    private static class IdentityStemmer
    implements IStemmer {
        private static final IdentityStemmer INSTANCE = new IdentityStemmer();

        private IdentityStemmer() {
        }

        public CharSequence stem(CharSequence word) {
            return null;
        }
    }

    private static class ArabicStemmerFactory {
        private ArabicStemmerFactory() {
        }

        public static IStemmer createStemmer() {
            try {
                return new LuceneStemmerAdapter();
            }
            catch (Exception e) {
                return IdentityStemmer.INSTANCE;
            }
        }

        static {
            try {
                ReflectionUtils.classForName((String)ArabicStemmer.class.getName(), (boolean)false);
                ReflectionUtils.classForName((String)ArabicNormalizer.class.getName(), (boolean)false);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Could not instantiate Lucene stemmer for Arabic, clustering quality of Arabic content may be degraded. For best quality clusters, make sure Lucene's Arabic analyzer JAR is in the classpath", (Throwable)e);
            }
        }

        private static class LuceneStemmerAdapter
        implements IStemmer {
            private final ArabicStemmer delegate;
            private final ArabicNormalizer normalizer;
            private char[] buffer = new char[0];

            private LuceneStemmerAdapter() {
                this.delegate = new ArabicStemmer();
                this.normalizer = new ArabicNormalizer();
            }

            public CharSequence stem(CharSequence word) {
                if (word.length() > this.buffer.length) {
                    this.buffer = new char[word.length()];
                }
                for (int i = 0; i < word.length(); ++i) {
                    this.buffer[i] = word.charAt(i);
                }
                int newLen = this.normalizer.normalize(this.buffer, word.length());
                if ((newLen = this.delegate.stem(this.buffer, newLen)) != word.length() || !this.equals(this.buffer, newLen, word)) {
                    return CharBuffer.wrap(this.buffer, 0, newLen);
                }
                return null;
            }

            private boolean equals(char[] buffer, int len, CharSequence word) {
                assert (len == word.length());
                for (int i = 0; i < len; ++i) {
                    if (buffer[i] == word.charAt(i)) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private static final class SnowballStemmerFactory {
        private static HashMap<LanguageCode, Class<? extends SnowballProgram>> snowballStemmerClasses = new HashMap();

        private SnowballStemmerFactory() {
        }

        public static IStemmer createStemmer(LanguageCode language) {
            Class<? extends SnowballProgram> stemmerClazz = snowballStemmerClasses.get(language);
            if (stemmerClazz == null) {
                logger.warn("No Snowball stemmer class for: " + language.name() + ". Quality of clustering may be degraded.");
                return IdentityStemmer.INSTANCE;
            }
            try {
                return new SnowballStemmerAdapter(stemmerClazz.newInstance());
            }
            catch (Exception e) {
                logger.warn("Could not instantiate snowball stemmer for language: " + language.name() + ". Quality of clustering may be degraded.", (Throwable)e);
                return IdentityStemmer.INSTANCE;
            }
        }

        static {
            snowballStemmerClasses.put(LanguageCode.DANISH, DanishStemmer.class);
            snowballStemmerClasses.put(LanguageCode.DUTCH, DutchStemmer.class);
            snowballStemmerClasses.put(LanguageCode.ENGLISH, EnglishStemmer.class);
            snowballStemmerClasses.put(LanguageCode.FINNISH, FinnishStemmer.class);
            snowballStemmerClasses.put(LanguageCode.FRENCH, FrenchStemmer.class);
            snowballStemmerClasses.put(LanguageCode.GERMAN, GermanStemmer.class);
            snowballStemmerClasses.put(LanguageCode.HUNGARIAN, HungarianStemmer.class);
            snowballStemmerClasses.put(LanguageCode.ITALIAN, ItalianStemmer.class);
            snowballStemmerClasses.put(LanguageCode.NORWEGIAN, NorwegianStemmer.class);
            snowballStemmerClasses.put(LanguageCode.PORTUGUESE, PortugueseStemmer.class);
            snowballStemmerClasses.put(LanguageCode.ROMANIAN, RomanianStemmer.class);
            snowballStemmerClasses.put(LanguageCode.RUSSIAN, RussianStemmer.class);
            snowballStemmerClasses.put(LanguageCode.SPANISH, SpanishStemmer.class);
            snowballStemmerClasses.put(LanguageCode.SWEDISH, SwedishStemmer.class);
            snowballStemmerClasses.put(LanguageCode.TURKISH, TurkishStemmer.class);
        }

        private static class SnowballStemmerAdapter
        implements IStemmer {
            private final SnowballProgram snowballStemmer;

            public SnowballStemmerAdapter(SnowballProgram snowballStemmer) {
                this.snowballStemmer = snowballStemmer;
            }

            public CharSequence stem(CharSequence word) {
                this.snowballStemmer.setCurrent(word.toString());
                if (this.snowballStemmer.stem()) {
                    return this.snowballStemmer.getCurrent();
                }
                return null;
            }
        }
    }
}

