/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering.carrot2;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.commongrams.CommonGramsFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.linguistic.DefaultLexicalDataFactory;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.linguistic.ILexicalDataFactory;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable
public class SolrStopwordsCarrot2LexicalDataFactory
implements ILexicalDataFactory {
    static final Logger logger = LoggerFactory.getLogger(SolrStopwordsCarrot2LexicalDataFactory.class);
    @Init
    @Input
    @Attribute(key="solrIndexSchema")
    @ImplementingClasses(classes={IndexSchema.class, ManagedIndexSchema.class})
    private IndexSchema schema;
    @Processing
    @Input
    @Attribute(key="solrFieldNames")
    private Set<String> fieldNames;
    private Multimap<String, CharArraySet> solrStopWords = HashMultimap.create();
    private DefaultLexicalDataFactory carrot2LexicalDataFactory = new DefaultLexicalDataFactory();

    private Collection<CharArraySet> getSolrStopWordsForField(String fieldName) {
        Analyzer fieldAnalyzer;
        if (!this.solrStopWords.containsKey((Object)fieldName) && (fieldAnalyzer = this.schema.getFieldType(fieldName).getAnalyzer()) instanceof TokenizerChain) {
            TokenFilterFactory[] filterFactories;
            for (TokenFilterFactory factory : filterFactories = ((TokenizerChain)fieldAnalyzer).getTokenFilterFactories()) {
                if (factory instanceof StopFilterFactory) {
                    this.solrStopWords.put((Object)fieldName, (Object)((StopFilterFactory)factory).getStopWords());
                }
                if (!(factory instanceof CommonGramsFilterFactory)) continue;
                this.solrStopWords.put((Object)fieldName, (Object)((CommonGramsFilterFactory)factory).getCommonWords());
            }
        }
        return this.solrStopWords.get((Object)fieldName);
    }

    public ILexicalData getLexicalData(LanguageCode languageCode) {
        final ILexicalData carrot2LexicalData = this.carrot2LexicalDataFactory.getLexicalData(languageCode);
        return new ILexicalData(){

            public boolean isStopLabel(CharSequence word) {
                return carrot2LexicalData.isStopLabel(word);
            }

            public boolean isCommonWord(MutableCharArray word) {
                for (String fieldName : SolrStopwordsCarrot2LexicalDataFactory.this.fieldNames) {
                    for (CharArraySet stopWords : SolrStopwordsCarrot2LexicalDataFactory.this.getSolrStopWordsForField(fieldName)) {
                        if (!stopWords.contains((CharSequence)word)) continue;
                        return true;
                    }
                }
                return carrot2LexicalData.isCommonWord(word);
            }
        };
    }
}

