/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.clustering.ClusteringEngine;
import org.apache.solr.handler.clustering.DocumentClusteringEngine;
import org.apache.solr.handler.clustering.SearchClusteringEngine;
import org.apache.solr.handler.clustering.carrot2.CarrotClusteringEngine;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringComponent
extends SearchComponent
implements SolrCoreAware {
    private static transient Logger log = LoggerFactory.getLogger(ClusteringComponent.class);
    public static final String COMPONENT_NAME = "clustering";
    private final LinkedHashMap<String, SearchClusteringEngine> searchClusteringEngines = Maps.newLinkedHashMap();
    private final LinkedHashMap<String, DocumentClusteringEngine> documentClusteringEngines = Maps.newLinkedHashMap();
    private final Map<String, SearchClusteringEngine> searchClusteringEnginesView = Collections.unmodifiableMap(this.searchClusteringEngines);
    private NamedList<Object> initParams;

    public void init(NamedList args) {
        this.initParams = args;
        super.init(args);
    }

    public void inform(SolrCore core) {
        if (this.initParams != null) {
            log.info("Initializing Clustering Engines");
            SolrResourceLoader loader = core.getResourceLoader();
            for (Map.Entry entry : this.initParams) {
                ClusteringEngine previousEntry;
                if (!"engine".equals(entry.getKey())) continue;
                NamedList engineInitParams = (NamedList)entry.getValue();
                String engineClassName = StringUtils.defaultIfBlank((String)((String)engineInitParams.get("classname")), (String)CarrotClusteringEngine.class.getName());
                ClusteringEngine engine = (ClusteringEngine)loader.newInstance(engineClassName, ClusteringEngine.class);
                String name = StringUtils.defaultIfBlank((String)engine.init(engineInitParams, core), (String)"");
                if (engine instanceof SearchClusteringEngine) {
                    previousEntry = this.searchClusteringEngines.put(name, (SearchClusteringEngine)engine);
                } else if (engine instanceof DocumentClusteringEngine) {
                    previousEntry = this.documentClusteringEngines.put(name, (DocumentClusteringEngine)engine);
                } else {
                    log.warn("Unknown type of a clustering engine for class: " + engineClassName);
                    continue;
                }
                if (previousEntry == null) continue;
                log.warn("Duplicate clustering engine component named '" + name + "'.");
            }
            ClusteringComponent.setupDefaultEngine("search results clustering", this.searchClusteringEngines);
            ClusteringComponent.setupDefaultEngine("document clustering", this.documentClusteringEngines);
            log.info("Finished Initializing Clustering Engines");
        }
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        boolean useCollection;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        String name = this.getClusteringEngineName(rb);
        boolean useResults = params.getBool("clustering.results", false);
        if (useResults) {
            SearchClusteringEngine engine = this.getSearchClusteringEngine(rb);
            if (engine != null) {
                DocListAndSet results = rb.getResults();
                HashMap docIds = Maps.newHashMapWithExpectedSize((int)results.docList.size());
                SolrDocumentList solrDocList = SolrPluginUtils.docListToSolrDocumentList((DocList)results.docList, (SolrIndexSearcher)rb.req.getSearcher(), engine.getFieldsToLoad(rb.req), (Map)docIds);
                Object clusters = engine.cluster(rb.getQuery(), solrDocList, docIds, rb.req);
                rb.rsp.add("clusters", clusters);
            } else {
                log.warn("No engine for: " + name);
            }
        }
        if (useCollection = params.getBool("clustering.collection", false)) {
            DocumentClusteringEngine engine = this.documentClusteringEngines.get(name);
            if (engine != null) {
                boolean useDocSet = params.getBool("clustering.docs.useDocSet", false);
                NamedList<?> nl = null;
                nl = useDocSet ? engine.cluster(rb.getResults().docSet, params) : engine.cluster(params);
                rb.rsp.add("clusters", nl);
            } else {
                log.warn("No engine for " + name);
            }
        }
    }

    private SearchClusteringEngine getSearchClusteringEngine(ResponseBuilder rb) {
        return this.searchClusteringEngines.get(this.getClusteringEngineName(rb));
    }

    private String getClusteringEngineName(ResponseBuilder rb) {
        return rb.req.getParams().get("clustering.engine", "default");
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || !params.getBool("clustering.results", false)) {
            return;
        }
        sreq.params.remove(COMPONENT_NAME);
        if ((sreq.purpose & 0x40) != 0) {
            String fl = sreq.params.get("fl", "*");
            if (fl.indexOf(42) >= 0) {
                return;
            }
            Set<String> fields = this.getSearchClusteringEngine(rb).getFieldsToLoad(rb.req);
            if (fields == null || fields.size() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String[] flparams = fl.split("[,\\s]+");
            HashSet<String> flParamSet = new HashSet<String>(flparams.length);
            for (String flparam : flparams) {
                flParamSet.add(flparam);
            }
            for (String aFieldToLoad : fields) {
                if (flParamSet.contains(aFieldToLoad)) continue;
                sb.append(',').append(aFieldToLoad);
            }
            if (sb.length() > 0) {
                sreq.params.set("fl", new String[]{fl + sb.toString()});
            }
        }
    }

    public void finishStage(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || !params.getBool("clustering.results", false)) {
            return;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            SearchClusteringEngine engine = this.getSearchClusteringEngine(rb);
            if (engine != null) {
                SolrDocumentList solrDocList = (SolrDocumentList)rb.rsp.getValues().get("response");
                Map<SolrDocument, Integer> docIds = null;
                Object clusters = engine.cluster(rb.getQuery(), solrDocList, docIds, rb.req);
                rb.rsp.add("clusters", clusters);
            } else {
                String name = this.getClusteringEngineName(rb);
                log.warn("No engine for: " + name);
            }
        }
    }

    Map<String, SearchClusteringEngine> getSearchClusteringEngines() {
        return this.searchClusteringEnginesView;
    }

    public String getDescription() {
        return "A Clustering component";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_7/solr/contrib/clustering/src/java/org/apache/solr/handler/clustering/ClusteringComponent.java $";
    }

    private static <T extends ClusteringEngine> void setupDefaultEngine(String type, LinkedHashMap<String, T> map) {
        if (map.containsKey("default")) {
            return;
        }
        if (!map.isEmpty()) {
            Map.Entry<String, T> first = map.entrySet().iterator().next();
            map.put("default", first.getValue());
            log.info("Default engine for " + type + ": " + first.getKey());
        }
    }
}

