/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.clustering.EngineContext;
import org.apache.solr.handler.clustering.EngineParameters;
import org.apache.solr.handler.clustering.FlatKeysAttrVisitor;
import org.apache.solr.handler.clustering.InputDocument;
import org.carrot2.attrs.AttrVisitor;
import org.carrot2.clustering.Cluster;
import org.carrot2.clustering.ClusteringAlgorithm;
import org.carrot2.language.LanguageComponents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Engine {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private EngineContext engineContext;

    Engine() {
    }

    boolean init(String engineName, SolrCore core, EngineParameters defaultParams) {
        log.info("Initializing clustering engine: {}", (Object)engineName);
        this.engineContext = new EngineContext(defaultParams.resources(), core);
        ClusteringAlgorithm defaultAlgorithm = this.engineContext.getAlgorithm(defaultParams.algorithmName());
        LanguageComponents defaultLanguage = this.engineContext.getLanguage(defaultParams.language());
        if (defaultAlgorithm == null) {
            log.warn("The default clustering algorithm for engine '{}' is not available: {}", (Object)engineName, (Object)defaultParams.algorithmName());
        }
        if (defaultLanguage == null) {
            log.warn("The default language for engine {} is not available: {}", (Object)engineName, (Object)defaultParams.language());
        }
        return defaultAlgorithm != null && defaultLanguage != null;
    }

    List<Cluster<InputDocument>> cluster(EngineParameters parameters, Query query, List<InputDocument> documents) {
        try {
            this.checkParameters(parameters);
            ClusteringAlgorithm algorithm = this.engineContext.getAlgorithm(parameters.algorithmName());
            this.populateAlgorithmParameters(query, parameters, algorithm);
            documents.sort(Comparator.comparing(a -> a.getId().toString()));
            String defaultLanguage = parameters.language();
            Map<String, List<InputDocument>> documentsByLanguage = documents.stream().collect(Collectors.groupingBy(doc -> {
                String lang = doc.language();
                return lang == null ? defaultLanguage : lang;
            }));
            HashSet<String> warnOnce = new HashSet<String>();
            LinkedHashMap<String, List> clustersByLanguage = new LinkedHashMap<String, List>();
            for (Map.Entry<String, List<InputDocument>> e2 : documentsByLanguage.entrySet()) {
                String lang = e2.getKey();
                if (!this.engineContext.isLanguageSupported(lang)) {
                    if (!warnOnce.add(lang)) continue;
                    log.warn("Language '{}' is not supported, documents in this language will not be clustered.", (Object)lang);
                    continue;
                }
                LanguageComponents langComponents = this.engineContext.getLanguage(lang);
                if (!algorithm.supports(langComponents)) {
                    if (!warnOnce.add(lang)) continue;
                    log.warn("Language '{}' is not supported by algorithm '{}', documents in this language will not be clustered.", (Object)lang, (Object)parameters.algorithmName());
                    continue;
                }
                clustersByLanguage.put(lang, algorithm.cluster(e2.getValue().stream(), langComponents));
            }
            List clusters = clustersByLanguage.size() == 1 ? (List)clustersByLanguage.values().iterator().next() : clustersByLanguage.entrySet().stream().map(e -> {
                Cluster cluster = new Cluster();
                cluster.addLabel((String)e.getKey());
                ((List)e.getValue()).forEach(arg_0 -> ((Cluster)cluster).addCluster(arg_0));
                return cluster;
            }).collect(Collectors.toList());
            return clusters;
        }
        catch (Exception e3) {
            log.error("Clustering request failed.", (Throwable)e3);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Carrot2 clustering failed", (Throwable)e3);
        }
    }

    private void populateAlgorithmParameters(Query query, EngineParameters requestParameters, ClusteringAlgorithm algorithm) {
        LinkedHashMap<String, String> attrs = requestParameters.otherParameters();
        if (!attrs.containsKey("queryHint")) {
            final LinkedHashSet termSet = new LinkedHashSet();
            query.visit(new QueryVisitor(){

                public void consumeTerms(Query query, Term ... terms) {
                    for (Term t : terms) {
                        termSet.add(t.text());
                    }
                }
            });
            attrs.put("queryHint", String.join((CharSequence)" ", termSet));
        }
        algorithm.accept((AttrVisitor)new FlatKeysAttrVisitor(attrs));
    }

    private void checkParameters(EngineParameters parameters) {
        ClusteringAlgorithm algorithm = this.engineContext.getAlgorithm(parameters.algorithmName());
        if (algorithm == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Algorithm '%s' not found.", parameters.algorithmName()));
        }
        String defaultLanguage = parameters.language();
        LanguageComponents languageComponents = this.engineContext.getLanguage(defaultLanguage);
        if (languageComponents == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Language '%s' is not supported.", defaultLanguage));
        }
        if (!algorithm.supports(languageComponents)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Language '%s' is not supported by algorithm '%s'.", defaultLanguage, parameters.algorithmName()));
        }
        if (parameters.fields().isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "At least one field name specifying content for clustering is required in parameter '%s'.", "clustering.fields"));
        }
    }
}

