/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import com.sun.mail.imap.IMAPMessage;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.SearchTerm;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailEntityProcessor
extends EntityProcessorBase {
    private String user;
    private String password;
    private String host;
    private String protocol;
    private String folderNames;
    private List<String> exclude = new ArrayList<String>();
    private List<String> include = new ArrayList<String>();
    private boolean recurse;
    private int batchSize;
    private int fetchSize;
    private int cTimeout;
    private int rTimeout;
    private Date fetchMailsSince;
    private String customFilter;
    private boolean processAttachment = true;
    private Tika tika;
    private Store mailbox;
    private boolean connected = false;
    private FolderIterator folderIter;
    private MessageIterator msgIter;
    private List<CustomFilter> filters = new ArrayList<CustomFilter>();
    private static FetchProfile fp = new FetchProfile();
    private static final Logger LOG = LoggerFactory.getLogger(DataImporter.class);
    private int rowCount = 0;
    private static final String MESSAGE_ID = "messageId";
    private static final String SUBJECT = "subject";
    private static final String FROM = "from";
    private static final String SENT_DATE = "sentDate";
    private static final String XMAILER = "xMailer";
    private static final String TO_CC_BCC = "allTo";
    private static final String FLAGS = "flags";
    private static final String CONTENT = "content";
    private static final String ATTACHMENT = "attachment";
    private static final String ATTACHMENT_NAMES = "attachmentNames";
    private static final String FLAG_ANSWERED = "answered";
    private static final String FLAG_DELETED = "deleted";
    private static final String FLAG_DRAFT = "draft";
    private static final String FLAG_FLAGGED = "flagged";
    private static final String FLAG_RECENT = "recent";
    private static final String FLAG_SEEN = "seen";

    public void init(Context context) {
        String includes;
        super.init(context);
        this.user = this.getStringFromContext("user", null);
        this.password = this.getStringFromContext("password", null);
        this.host = this.getStringFromContext("host", null);
        this.protocol = this.getStringFromContext("protocol", null);
        this.folderNames = this.getStringFromContext("folders", null);
        if (this.host == null || this.protocol == null || this.user == null || this.password == null || this.folderNames == null) {
            throw new DataImportHandlerException(500, "'user|password|protocol|host|folders' are required attributes");
        }
        this.recurse = this.getBoolFromContext("recurse", true);
        String excludes = this.getStringFromContext("exclude", "");
        if (excludes != null && !excludes.trim().equals("")) {
            this.exclude = Arrays.asList(excludes.split(","));
        }
        if ((includes = this.getStringFromContext("include", "")) != null && !includes.trim().equals("")) {
            this.include = Arrays.asList(includes.split(","));
        }
        this.batchSize = this.getIntFromContext("batchSize", 20);
        this.customFilter = this.getStringFromContext("customFilter", "");
        String s = this.getStringFromContext("fetchMailsSince", null);
        if (s != null) {
            try {
                this.fetchMailsSince = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT).parse(s);
            }
            catch (ParseException e) {
                throw new DataImportHandlerException(500, "Invalid value for fetchMailSince: " + s, (Throwable)e);
            }
        }
        this.fetchSize = this.getIntFromContext("fetchSize", 32768);
        this.cTimeout = this.getIntFromContext("connectTimeout", 30000);
        this.rTimeout = this.getIntFromContext("readTimeout", 60000);
        this.processAttachment = this.getBoolFromContext(this.getStringFromContext("processAttachment", null) == null ? "processAttachement" : "processAttachment", true);
        this.tika = new Tika();
        this.logConfig();
    }

    public Map<String, Object> nextRow() {
        Message mail;
        Map<String, Object> row = null;
        do {
            if ((mail = this.getNextMail()) == null) continue;
            row = this.getDocumentFromMail(mail);
        } while (row == null && mail != null);
        return row;
    }

    private Message getNextMail() {
        if (!this.connected) {
            if (!this.connectToMailBox()) {
                return null;
            }
            this.connected = true;
        }
        if (this.folderIter == null) {
            this.createFilters();
            this.folderIter = new FolderIterator(this.mailbox);
        }
        while (this.msgIter == null || !this.msgIter.hasNext()) {
            Folder next;
            Folder folder = next = this.folderIter.hasNext() ? this.folderIter.next() : null;
            if (next == null) {
                return null;
            }
            this.msgIter = new MessageIterator(next, this.batchSize);
        }
        return this.msgIter.next();
    }

    private Map<String, Object> getDocumentFromMail(Message mail) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        try {
            this.addPartToDocument((Part)mail, row, true);
            return row;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addPartToDocument(Part part, Map<String, Object> row, boolean outerMost) throws Exception {
        if (part instanceof Message) {
            this.addEnvelopToDocument(part, row);
        }
        String ct = part.getContentType();
        ContentType ctype = new ContentType(ct);
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            if (part.isMimeType("multipart/alternative")) {
                count = 1;
            }
            for (int i = 0; i < count; ++i) {
                this.addPartToDocument((Part)mp.getBodyPart(i), row, false);
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.addPartToDocument((Part)part.getContent(), row, false);
        } else {
            String disp = part.getDisposition();
            if (!this.processAttachment || disp != null && disp.equalsIgnoreCase(ATTACHMENT)) {
                return;
            }
            InputStream is = part.getInputStream();
            String fileName = part.getFileName();
            Metadata md = new Metadata();
            md.set("Content-Type", ctype.getBaseType().toLowerCase(Locale.ROOT));
            md.set("resourceName", fileName);
            String content = this.tika.parseToString(is, md);
            if (disp != null && disp.equalsIgnoreCase(ATTACHMENT)) {
                if (row.get(ATTACHMENT) == null) {
                    row.put(ATTACHMENT, new ArrayList());
                }
                List contents = (List)row.get(ATTACHMENT);
                contents.add(content);
                row.put(ATTACHMENT, contents);
                if (row.get(ATTACHMENT_NAMES) == null) {
                    row.put(ATTACHMENT_NAMES, new ArrayList());
                }
                List names = (List)row.get(ATTACHMENT_NAMES);
                names.add(fileName);
                row.put(ATTACHMENT_NAMES, names);
            } else {
                if (row.get(CONTENT) == null) {
                    row.put(CONTENT, new ArrayList());
                }
                List contents = (List)row.get(CONTENT);
                contents.add(content);
                row.put(CONTENT, contents);
            }
        }
    }

    private void addEnvelopToDocument(Part part, Map<String, Object> row) throws MessagingException {
        MimeMessage mail = (MimeMessage)part;
        Address[] adresses = mail.getFrom();
        if (adresses != null && adresses.length > 0) {
            row.put(FROM, adresses[0].toString());
        }
        ArrayList<String> to = new ArrayList<String>();
        adresses = mail.getRecipients(Message.RecipientType.TO);
        if (adresses != null) {
            this.addAddressToList(adresses, to);
        }
        if ((adresses = mail.getRecipients(Message.RecipientType.CC)) != null) {
            this.addAddressToList(adresses, to);
        }
        if ((adresses = mail.getRecipients(Message.RecipientType.BCC)) != null) {
            this.addAddressToList(adresses, to);
        }
        if (to.size() > 0) {
            row.put(TO_CC_BCC, to);
        }
        row.put(MESSAGE_ID, mail.getMessageID());
        row.put(SUBJECT, mail.getSubject());
        Date d = mail.getSentDate();
        if (d != null) {
            row.put(SENT_DATE, d);
        }
        ArrayList<String> flags = new ArrayList<String>();
        for (Flags.Flag flag : mail.getFlags().getSystemFlags()) {
            if (flag == Flags.Flag.ANSWERED) {
                flags.add(FLAG_ANSWERED);
                continue;
            }
            if (flag == Flags.Flag.DELETED) {
                flags.add(FLAG_DELETED);
                continue;
            }
            if (flag == Flags.Flag.DRAFT) {
                flags.add(FLAG_DRAFT);
                continue;
            }
            if (flag == Flags.Flag.FLAGGED) {
                flags.add(FLAG_FLAGGED);
                continue;
            }
            if (flag == Flags.Flag.RECENT) {
                flags.add(FLAG_RECENT);
                continue;
            }
            if (flag != Flags.Flag.SEEN) continue;
            flags.add(FLAG_SEEN);
        }
        flags.addAll(Arrays.asList(mail.getFlags().getUserFlags()));
        row.put(FLAGS, flags);
        String[] hdrs = mail.getHeader("X-Mailer");
        if (hdrs != null) {
            row.put(XMAILER, hdrs[0]);
        }
    }

    private void addAddressToList(Address[] adresses, List<String> to) throws AddressException {
        for (Address address : adresses) {
            InternetAddress[] group;
            to.add(address.toString());
            InternetAddress ia = (InternetAddress)address;
            if (!ia.isGroup()) continue;
            for (InternetAddress member : group = ia.getGroup(false)) {
                to.add(member.toString());
            }
        }
    }

    private boolean connectToMailBox() {
        try {
            Properties props = new Properties();
            props.setProperty("mail.store.protocol", this.protocol);
            props.setProperty("mail.imap.fetchsize", "" + this.fetchSize);
            props.setProperty("mail.imap.timeout", "" + this.rTimeout);
            props.setProperty("mail.imap.connectiontimeout", "" + this.cTimeout);
            Session session = Session.getDefaultInstance((Properties)props, null);
            this.mailbox = session.getStore(this.protocol);
            this.mailbox.connect(this.host, this.user, this.password);
            LOG.info("Connected to mailbox");
            return true;
        }
        catch (MessagingException e) {
            throw new DataImportHandlerException(500, "Connection failed", (Throwable)e);
        }
    }

    private void createFilters() {
        if (this.fetchMailsSince != null) {
            this.filters.add(new MailsSinceLastCheckFilter(this.fetchMailsSince));
        }
        if (this.customFilter != null && !this.customFilter.equals("")) {
            try {
                Class<?> cf = Class.forName(this.customFilter);
                Object obj = cf.newInstance();
                if (obj instanceof CustomFilter) {
                    this.filters.add((CustomFilter)obj);
                }
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Custom filter could not be created", (Throwable)e);
            }
        }
    }

    private void logConfig() {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        StringBuffer config = new StringBuffer();
        config.append("user : ").append(this.user).append(System.getProperty("line.separator"));
        config.append("pwd : ").append(this.password).append(System.getProperty("line.separator"));
        config.append("protocol : ").append(this.protocol).append(System.getProperty("line.separator"));
        config.append("host : ").append(this.host).append(System.getProperty("line.separator"));
        config.append("folders : ").append(this.folderNames).append(System.getProperty("line.separator"));
        config.append("recurse : ").append(this.recurse).append(System.getProperty("line.separator"));
        config.append("exclude : ").append(this.exclude.toString()).append(System.getProperty("line.separator"));
        config.append("include : ").append(this.include.toString()).append(System.getProperty("line.separator"));
        config.append("batchSize : ").append(this.batchSize).append(System.getProperty("line.separator"));
        config.append("fetchSize : ").append(this.fetchSize).append(System.getProperty("line.separator"));
        config.append("read timeout : ").append(this.rTimeout).append(System.getProperty("line.separator"));
        config.append("conection timeout : ").append(this.cTimeout).append(System.getProperty("line.separator"));
        config.append("custom filter : ").append(this.customFilter).append(System.getProperty("line.separator"));
        config.append("fetch mail since : ").append(this.fetchMailsSince).append(System.getProperty("line.separator"));
        LOG.info(config.toString());
    }

    private int getIntFromContext(String prop, int ifNull) {
        int v = ifNull;
        try {
            String val = this.context.getEntityAttribute(prop);
            if (val != null) {
                val = this.context.replaceTokens(val);
                v = Integer.valueOf(val);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return v;
    }

    private boolean getBoolFromContext(String prop, boolean ifNull) {
        boolean v = ifNull;
        String val = this.context.getEntityAttribute(prop);
        if (val != null) {
            val = this.context.replaceTokens(val);
            v = Boolean.valueOf(val);
        }
        return v;
    }

    private String getStringFromContext(String prop, String ifNull) {
        String v = ifNull;
        String val = this.context.getEntityAttribute(prop);
        if (val != null) {
            v = val = this.context.replaceTokens(val);
        }
        return v;
    }

    static {
        fp.add(FetchProfile.Item.ENVELOPE);
        fp.add(FetchProfile.Item.FLAGS);
        fp.add("X-Mailer");
    }

    class MailsSinceLastCheckFilter
    implements CustomFilter {
        private Date since;

        public MailsSinceLastCheckFilter(Date date) {
            this.since = date;
        }

        @Override
        public SearchTerm getCustomSearch(Folder folder) {
            return new ReceivedDateTerm(6, this.since);
        }
    }

    class MessageIterator
    implements Iterator<Message> {
        private Folder folder;
        private Message[] messagesInCurBatch;
        private int current = 0;
        private int currentBatch = 0;
        private int batchSize = 0;
        private int totalInFolder = 0;
        private boolean doBatching = true;

        public MessageIterator(Folder folder, int batchSize) {
            try {
                this.folder = folder;
                this.batchSize = batchSize;
                SearchTerm st = this.getSearchTerm();
                if (st != null) {
                    this.doBatching = false;
                    this.messagesInCurBatch = folder.search(st);
                    this.totalInFolder = this.messagesInCurBatch.length;
                    folder.fetch(this.messagesInCurBatch, fp);
                    this.current = 0;
                    LOG.info("Total messages : " + this.totalInFolder);
                    LOG.info("Search criteria applied. Batching disabled");
                } else {
                    this.totalInFolder = folder.getMessageCount();
                    LOG.info("Total messages : " + this.totalInFolder);
                    this.getNextBatch(batchSize, folder);
                }
            }
            catch (MessagingException e) {
                throw new DataImportHandlerException(500, "Message retreival failed", (Throwable)e);
            }
        }

        private void getNextBatch(int batchSize, Folder folder) throws MessagingException {
            int lastMsg;
            if (this.messagesInCurBatch != null) {
                for (Message m : this.messagesInCurBatch) {
                    if (!(m instanceof IMAPMessage)) continue;
                    ((IMAPMessage)m).invalidateHeaders();
                }
            }
            lastMsg = (lastMsg = (this.currentBatch + 1) * batchSize) > this.totalInFolder ? this.totalInFolder : lastMsg;
            this.messagesInCurBatch = folder.getMessages(this.currentBatch * batchSize + 1, lastMsg);
            folder.fetch(this.messagesInCurBatch, fp);
            this.current = 0;
            ++this.currentBatch;
            LOG.info("Current Batch  : " + this.currentBatch);
            LOG.info("Messages in this batch  : " + this.messagesInCurBatch.length);
        }

        @Override
        public boolean hasNext() {
            boolean hasMore;
            boolean bl = hasMore = this.current < this.messagesInCurBatch.length;
            if (!hasMore && this.doBatching && this.currentBatch * this.batchSize < this.totalInFolder) {
                try {
                    this.getNextBatch(this.batchSize, this.folder);
                    hasMore = this.current < this.messagesInCurBatch.length;
                }
                catch (MessagingException e) {
                    throw new DataImportHandlerException(500, "Message retreival failed", (Throwable)e);
                }
            }
            return hasMore;
        }

        @Override
        public Message next() {
            return this.hasNext() ? this.messagesInCurBatch[this.current++] : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Its read only mode...");
        }

        private SearchTerm getSearchTerm() {
            if (MailEntityProcessor.this.filters.size() == 0) {
                return null;
            }
            if (MailEntityProcessor.this.filters.size() == 1) {
                return ((CustomFilter)MailEntityProcessor.this.filters.get(0)).getCustomSearch(this.folder);
            }
            SearchTerm last = ((CustomFilter)MailEntityProcessor.this.filters.get(0)).getCustomSearch(this.folder);
            for (int i = 1; i < MailEntityProcessor.this.filters.size(); ++i) {
                CustomFilter filter = (CustomFilter)MailEntityProcessor.this.filters.get(i);
                SearchTerm st = filter.getCustomSearch(this.folder);
                if (st == null) continue;
                last = new AndTerm(last, st);
            }
            return last;
        }
    }

    class FolderIterator
    implements Iterator<Folder> {
        private Store mailbox;
        private List<String> topLevelFolders;
        private List<Folder> folders = null;
        private Folder lastFolder = null;

        public FolderIterator(Store mailBox) {
            this.mailbox = mailBox;
            this.folders = new ArrayList<Folder>();
            this.getTopLevelFolders(mailBox);
        }

        @Override
        public boolean hasNext() {
            return !this.folders.isEmpty();
        }

        @Override
        public Folder next() {
            try {
                Folder next;
                boolean hasMessages = false;
                do {
                    if (this.lastFolder != null) {
                        this.lastFolder.close(false);
                        this.lastFolder = null;
                    }
                    if (this.folders.isEmpty()) {
                        this.mailbox.close();
                        return null;
                    }
                    next = this.folders.remove(0);
                    if (next == null) continue;
                    String fullName = next.getFullName();
                    if (!this.excludeFolder(fullName)) {
                        hasMessages = (next.getType() & 1) != 0;
                        next.open(1);
                        this.lastFolder = next;
                        LOG.info("Opened folder : " + fullName);
                    }
                    if (!MailEntityProcessor.this.recurse || (next.getType() & 2) == 0) continue;
                    Folder[] children = next.list();
                    LOG.info("Added its children to list  : ");
                    for (int i = children.length - 1; i >= 0; --i) {
                        this.folders.add(0, children[i]);
                        LOG.info("child name : " + children[i].getFullName());
                    }
                    if (children.length != 0) continue;
                    LOG.info("NO children : ");
                } while (!hasMessages);
                return next;
            }
            catch (MessagingException messagingException) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Its read only mode...");
        }

        private void getTopLevelFolders(Store mailBox) {
            if (MailEntityProcessor.this.folderNames != null) {
                this.topLevelFolders = Arrays.asList(MailEntityProcessor.this.folderNames.split(","));
            }
            for (int i = 0; this.topLevelFolders != null && i < this.topLevelFolders.size(); ++i) {
                try {
                    this.folders.add(this.mailbox.getFolder(this.topLevelFolders.get(i)));
                    continue;
                }
                catch (MessagingException e) {
                    if (this.folders.size() != 0 || i != this.topLevelFolders.size() - 1) continue;
                    throw new DataImportHandlerException(500, "Folder retreival failed");
                }
            }
            if (this.topLevelFolders == null || this.topLevelFolders.size() == 0) {
                try {
                    this.folders.add(mailBox.getDefaultFolder());
                }
                catch (MessagingException e) {
                    throw new DataImportHandlerException(500, "Folder retreival failed");
                }
            }
        }

        private boolean excludeFolder(String name) {
            for (String s : MailEntityProcessor.this.exclude) {
                if (!name.matches(s)) continue;
                return true;
            }
            for (String s : MailEntityProcessor.this.include) {
                if (!name.matches(s)) continue;
                return false;
            }
            return MailEntityProcessor.this.include.size() > 0;
        }
    }

    public static interface CustomFilter {
        public SearchTerm getCustomSearch(Folder var1);
    }
}

