/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import com.sun.mail.gimap.GmailFolder;
import com.sun.mail.gimap.GmailRawSearchTerm;
import com.sun.mail.imap.IMAPMessage;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.DateTerm;
import javax.mail.search.SearchTerm;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.apache.solr.util.RTimer;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailEntityProcessor
extends EntityProcessorBase {
    private static final SimpleDateFormat sinceDateParser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    private static final SimpleDateFormat afterFmt = new SimpleDateFormat("yyyy/MM/dd", Locale.ROOT);
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String user;
    private String password;
    private String host;
    private String protocol;
    private String folderNames;
    private List<String> exclude = new ArrayList<String>();
    private List<String> include = new ArrayList<String>();
    private boolean recurse;
    private int batchSize;
    private int fetchSize;
    private int cTimeout;
    private int rTimeout;
    private Date fetchMailsSince;
    private String customFilter;
    private boolean processAttachment = true;
    private boolean includeContent = true;
    private boolean includeOtherUserFolders = false;
    private boolean includeSharedFolders = false;
    private Store mailbox;
    private boolean connected = false;
    private FolderIterator folderIter;
    private MessageIterator msgIter;
    private List<CustomFilter> filters = new ArrayList<CustomFilter>();
    private static FetchProfile fp = new FetchProfile();
    private static final String MESSAGE_ID = "messageId";
    private static final String SUBJECT = "subject";
    private static final String FROM = "from";
    private static final String SENT_DATE = "sentDate";
    private static final String XMAILER = "xMailer";
    private static final String TO_CC_BCC = "allTo";
    private static final String FLAGS = "flags";
    private static final String CONTENT = "content";
    private static final String ATTACHMENT = "attachment";
    private static final String ATTACHMENT_NAMES = "attachmentNames";
    private static final String FLAG_NONE = "none";
    private static final String FLAG_ANSWERED = "answered";
    private static final String FLAG_DELETED = "deleted";
    private static final String FLAG_DRAFT = "draft";
    private static final String FLAG_FLAGGED = "flagged";
    private static final String FLAG_RECENT = "recent";
    private static final String FLAG_SEEN = "seen";

    public void init(Context context) {
        Object tmp;
        super.init(context);
        this.user = this.getStringFromContext("user", null);
        this.password = this.getStringFromContext("password", null);
        this.host = this.getStringFromContext("host", null);
        this.protocol = this.getStringFromContext("protocol", null);
        this.folderNames = this.getStringFromContext("folders", null);
        if (this.host == null || this.protocol == null || this.user == null || this.password == null || this.folderNames == null) {
            throw new DataImportHandlerException(500, "'user|password|protocol|host|folders' are required attributes");
        }
        this.recurse = this.getBoolFromContext("recurse", true);
        this.exclude.clear();
        String excludes = this.getStringFromContext("exclude", "");
        if (excludes != null && !excludes.trim().equals("")) {
            this.exclude = Arrays.asList(excludes.split(","));
        }
        this.include.clear();
        String includes = this.getStringFromContext("include", "");
        if (includes != null && !includes.trim().equals("")) {
            this.include = Arrays.asList(includes.split(","));
        }
        this.batchSize = this.getIntFromContext("batchSize", 20);
        this.customFilter = this.getStringFromContext("customFilter", "");
        if (this.filters != null) {
            this.filters.clear();
        }
        this.folderIter = null;
        this.msgIter = null;
        String lastIndexTime = null;
        String command = String.valueOf(context.getRequestParameters().get("command"));
        if (!"full-import".equals(command)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " only supports " + "full-import");
        }
        String cname = this.getStringFromContext("name", "mailimporter");
        String varName = "dih." + cname + "." + "last_index_time";
        Object varValue = context.getVariableResolver().resolve(varName);
        LOG.info(varName + "=" + varValue);
        if (varValue != null && !"".equals(varValue) && !"".equals(this.getStringFromContext("fetchMailsSince", ""))) {
            tmp = null;
            try {
                tmp = sinceDateParser.parse((String)varValue);
                if (((Date)tmp).getTime() == 0L) {
                    LOG.info("Ignoring initial value " + varValue + " for " + varName + " in favor of fetchMailsSince config parameter");
                    tmp = null;
                }
            }
            catch (ParseException e) {
                LOG.warn("Failed to parse " + varValue + " from " + varName + " due to: " + e);
            }
            if (tmp == null) {
                varValue = this.getStringFromContext("fetchMailsSince", "");
                LOG.info("fetchMailsSince=" + varValue);
            }
        }
        if (varValue == null || "".equals(varValue)) {
            varName = "dih.last_index_time";
            varValue = context.getVariableResolver().resolve(varName);
            LOG.info(varName + "=" + varValue);
        }
        if (varValue != null && varValue instanceof String && (lastIndexTime = (String)varValue) != null && lastIndexTime.length() == 0) {
            lastIndexTime = null;
        }
        if (lastIndexTime == null) {
            lastIndexTime = this.getStringFromContext("fetchMailsSince", "");
        }
        LOG.info("Using lastIndexTime " + lastIndexTime + " for mail import");
        this.fetchMailsSince = null;
        if (lastIndexTime != null && lastIndexTime.length() > 0) {
            try {
                this.fetchMailsSince = sinceDateParser.parse(lastIndexTime);
                LOG.info("Parsed fetchMailsSince=" + lastIndexTime);
            }
            catch (ParseException e) {
                throw new DataImportHandlerException(500, "Invalid value for fetchMailSince: " + lastIndexTime, (Throwable)e);
            }
        }
        this.fetchSize = this.getIntFromContext("fetchSize", 32768);
        this.cTimeout = this.getIntFromContext("connectTimeout", 30000);
        this.rTimeout = this.getIntFromContext("readTimeout", 60000);
        tmp = context.getEntityAttribute("includeOtherUserFolders");
        this.includeOtherUserFolders = tmp != null && Boolean.valueOf(((String)tmp).trim()) != false;
        tmp = context.getEntityAttribute("includeSharedFolders");
        this.includeSharedFolders = tmp != null && Boolean.valueOf(((String)tmp).trim()) != false;
        this.setProcessAttachmentConfig();
        this.includeContent = this.getBoolFromContext("includeContent", true);
        this.logConfig();
    }

    private void setProcessAttachmentConfig() {
        this.processAttachment = true;
        String tbval = this.context.getEntityAttribute("processAttachments");
        if (tbval == null) {
            tbval = this.context.getEntityAttribute("processAttachement");
            if (tbval != null) {
                this.processAttachment = Boolean.valueOf(tbval);
            }
        } else {
            this.processAttachment = Boolean.valueOf(tbval);
        }
    }

    public Map<String, Object> nextRow() {
        Message mail = null;
        Map<String, Object> row = null;
        do {
            if ((mail = this.getNextMail()) != null) {
                row = this.getDocumentFromMail(mail);
            }
            if (row == null || row.get("folder") != null) continue;
            row.put("folder", mail.getFolder().getFullName());
        } while (row == null && mail != null);
        return row;
    }

    private Message getNextMail() {
        if (!this.connected) {
            if (!this.connectToMailBox()) {
                return null;
            }
            this.connected = true;
        }
        if (this.folderIter == null) {
            this.createFilters();
            this.folderIter = new FolderIterator(this.mailbox);
        }
        while (this.msgIter == null || !this.msgIter.hasNext()) {
            Folder next;
            Folder folder = next = this.folderIter.hasNext() ? this.folderIter.next() : null;
            if (next == null) {
                return null;
            }
            this.msgIter = new MessageIterator(next, this.batchSize);
        }
        return this.msgIter.next();
    }

    private Map<String, Object> getDocumentFromMail(Message mail) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        try {
            this.addPartToDocument((Part)mail, row, true);
            return row;
        }
        catch (Exception e) {
            LOG.error("Failed to convert message [" + mail.toString() + "] to document due to: " + e, (Throwable)e);
            return null;
        }
    }

    public void addPartToDocument(Part part, Map<String, Object> row, boolean outerMost) throws Exception {
        if (part instanceof Message) {
            this.addEnvelopeToDocument(part, row);
        }
        String ct = part.getContentType().toLowerCase(Locale.ROOT);
        ContentType ctype = new ContentType(ct);
        if (part.isMimeType("multipart/*")) {
            Object content = part.getContent();
            if (content != null && content instanceof Multipart) {
                Multipart mp = (Multipart)part.getContent();
                int count = mp.getCount();
                if (part.isMimeType("multipart/alternative")) {
                    count = 1;
                }
                for (int i = 0; i < count; ++i) {
                    this.addPartToDocument((Part)mp.getBodyPart(i), row, false);
                }
            } else {
                LOG.warn("Multipart content is a not an instance of Multipart! Content is: " + (content != null ? content.getClass().getName() : "null") + ". Typically, this is due to the Java Activation JAR being loaded by the wrong classloader.");
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.addPartToDocument((Part)part.getContent(), row, false);
        } else {
            InputStream is;
            String disp = part.getDisposition();
            if (this.includeContent && (disp == null || !disp.equalsIgnoreCase(ATTACHMENT))) {
                is = part.getInputStream();
                Metadata contentTypeHint = new Metadata();
                contentTypeHint.set("Content-Type", ctype.getBaseType().toLowerCase(Locale.ENGLISH));
                String content = new Tika().parseToString(is, contentTypeHint);
                if (row.get(CONTENT) == null) {
                    row.put(CONTENT, new ArrayList());
                }
                List contents = (List)row.get(CONTENT);
                contents.add(content.trim());
                row.put(CONTENT, contents);
            }
            if (!this.processAttachment || disp == null || !disp.equalsIgnoreCase(ATTACHMENT)) {
                return;
            }
            is = part.getInputStream();
            String fileName = part.getFileName();
            Metadata contentTypeHint = new Metadata();
            contentTypeHint.set("Content-Type", ctype.getBaseType().toLowerCase(Locale.ENGLISH));
            String content = new Tika().parseToString(is, contentTypeHint);
            if (content == null || content.trim().length() == 0) {
                return;
            }
            if (row.get(ATTACHMENT) == null) {
                row.put(ATTACHMENT, new ArrayList());
            }
            List contents = (List)row.get(ATTACHMENT);
            contents.add(content.trim());
            row.put(ATTACHMENT, contents);
            if (row.get(ATTACHMENT_NAMES) == null) {
                row.put(ATTACHMENT_NAMES, new ArrayList());
            }
            List names = (List)row.get(ATTACHMENT_NAMES);
            names.add(fileName);
            row.put(ATTACHMENT_NAMES, names);
        }
    }

    private void addEnvelopeToDocument(Part part, Map<String, Object> row) throws MessagingException {
        MimeMessage mail = (MimeMessage)part;
        Address[] adresses = mail.getFrom();
        if (adresses != null && adresses.length > 0) {
            row.put(FROM, adresses[0].toString());
        }
        ArrayList<String> to = new ArrayList<String>();
        adresses = mail.getRecipients(Message.RecipientType.TO);
        if (adresses != null) {
            this.addAddressToList(adresses, to);
        }
        if ((adresses = mail.getRecipients(Message.RecipientType.CC)) != null) {
            this.addAddressToList(adresses, to);
        }
        if ((adresses = mail.getRecipients(Message.RecipientType.BCC)) != null) {
            this.addAddressToList(adresses, to);
        }
        if (to.size() > 0) {
            row.put(TO_CC_BCC, to);
        }
        row.put(MESSAGE_ID, mail.getMessageID());
        row.put(SUBJECT, mail.getSubject());
        Date d = mail.getSentDate();
        if (d != null) {
            row.put(SENT_DATE, d);
        }
        ArrayList<String> flags = new ArrayList<String>();
        for (Flags.Flag flag : mail.getFlags().getSystemFlags()) {
            if (flag == Flags.Flag.ANSWERED) {
                flags.add(FLAG_ANSWERED);
                continue;
            }
            if (flag == Flags.Flag.DELETED) {
                flags.add(FLAG_DELETED);
                continue;
            }
            if (flag == Flags.Flag.DRAFT) {
                flags.add(FLAG_DRAFT);
                continue;
            }
            if (flag == Flags.Flag.FLAGGED) {
                flags.add(FLAG_FLAGGED);
                continue;
            }
            if (flag == Flags.Flag.RECENT) {
                flags.add(FLAG_RECENT);
                continue;
            }
            if (flag != Flags.Flag.SEEN) continue;
            flags.add(FLAG_SEEN);
        }
        flags.addAll(Arrays.asList(mail.getFlags().getUserFlags()));
        if (flags.size() == 0) {
            flags.add(FLAG_NONE);
        }
        row.put(FLAGS, flags);
        String[] hdrs = mail.getHeader("X-Mailer");
        if (hdrs != null) {
            row.put(XMAILER, hdrs[0]);
        }
    }

    private void addAddressToList(Address[] adresses, List<String> to) throws AddressException {
        for (Address address : adresses) {
            InternetAddress[] group;
            to.add(address.toString());
            InternetAddress ia = (InternetAddress)address;
            if (!ia.isGroup()) continue;
            for (InternetAddress member : group = ia.getGroup(false)) {
                to.add(member.toString());
            }
        }
    }

    private boolean connectToMailBox() {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Properties props = new Properties();
            if (System.getProperty("mail.debug") != null) {
                props.setProperty("mail.debug", System.getProperty("mail.debug"));
            }
            if (("imap".equals(this.protocol) || "imaps".equals(this.protocol)) && "imap.gmail.com".equals(this.host)) {
                LOG.info("Consider using 'gimaps' protocol instead of '" + this.protocol + "' for enabling GMail specific extensions for " + this.host);
            }
            props.setProperty("mail.store.protocol", this.protocol);
            String imapPropPrefix = this.protocol.startsWith("gimap") ? "gimap" : "imap";
            props.setProperty("mail." + imapPropPrefix + ".fetchsize", "" + this.fetchSize);
            props.setProperty("mail." + imapPropPrefix + ".timeout", "" + this.rTimeout);
            props.setProperty("mail." + imapPropPrefix + ".connectiontimeout", "" + this.cTimeout);
            int port = -1;
            int colonAt = this.host.indexOf(":");
            if (colonAt != -1) {
                port = Integer.parseInt(this.host.substring(colonAt + 1));
                this.host = this.host.substring(0, colonAt);
            }
            Session session = Session.getDefaultInstance((Properties)props, null);
            this.mailbox = session.getStore(this.protocol);
            if (port != -1) {
                this.mailbox.connect(this.host, port, this.user, this.password);
            } else {
                this.mailbox.connect(this.host, this.user, this.password);
            }
            LOG.info("Connected to " + this.user + "'s mailbox on " + this.host);
            return true;
        }
        catch (MessagingException e) {
            String errMsg = String.format(Locale.ENGLISH, "Failed to connect to %s server %s as user %s due to: %s", this.protocol, this.host, this.user, e.toString());
            LOG.error(errMsg, (Throwable)e);
            throw new DataImportHandlerException(500, errMsg, (Throwable)e);
        }
    }

    private void createFilters() {
        if (this.fetchMailsSince != null) {
            this.filters.add(new MailsSinceLastCheckFilter(this.fetchMailsSince));
        }
        if (this.customFilter != null && !this.customFilter.equals("")) {
            try {
                Class<?> cf = Class.forName(this.customFilter);
                Object obj = cf.newInstance();
                if (obj instanceof CustomFilter) {
                    this.filters.add((CustomFilter)obj);
                }
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Custom filter could not be created", (Throwable)e);
            }
        }
    }

    private void logConfig() {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        String lineSep = System.getProperty("line.separator");
        StringBuffer config = new StringBuffer();
        config.append("user : ").append(this.user).append(lineSep);
        config.append("pwd : ").append(this.password != null && this.password.length() > 0 ? "<non-null>" : "<null>").append(lineSep);
        config.append("protocol : ").append(this.protocol).append(lineSep);
        config.append("host : ").append(this.host).append(lineSep);
        config.append("folders : ").append(this.folderNames).append(lineSep);
        config.append("recurse : ").append(this.recurse).append(lineSep);
        config.append("exclude : ").append(this.exclude.toString()).append(lineSep);
        config.append("include : ").append(this.include.toString()).append(lineSep);
        config.append("batchSize : ").append(this.batchSize).append(lineSep);
        config.append("fetchSize : ").append(this.fetchSize).append(lineSep);
        config.append("read timeout : ").append(this.rTimeout).append(lineSep);
        config.append("conection timeout : ").append(this.cTimeout).append(lineSep);
        config.append("custom filter : ").append(this.customFilter).append(lineSep);
        config.append("fetch mail since : ").append(this.fetchMailsSince).append(lineSep);
        config.append("includeContent : ").append(this.includeContent).append(lineSep);
        config.append("processAttachments : ").append(this.processAttachment).append(lineSep);
        config.append("includeOtherUserFolders : ").append(this.includeOtherUserFolders).append(lineSep);
        config.append("includeSharedFolders : ").append(this.includeSharedFolders).append(lineSep);
        LOG.info(config.toString());
    }

    private int getIntFromContext(String prop, int ifNull) {
        int v = ifNull;
        try {
            String val = this.context.getEntityAttribute(prop);
            if (val != null) {
                val = this.context.replaceTokens(val);
                v = Integer.parseInt(val);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return v;
    }

    private boolean getBoolFromContext(String prop, boolean ifNull) {
        boolean v = ifNull;
        String val = this.context.getEntityAttribute(prop);
        if (val != null) {
            val = this.context.replaceTokens(val);
            v = Boolean.valueOf(val);
        }
        return v;
    }

    private String getStringFromContext(String prop, String ifNull) {
        String v = ifNull;
        String val = this.context.getEntityAttribute(prop);
        if (val != null) {
            v = val = this.context.replaceTokens(val);
        }
        return v;
    }

    static {
        fp.add(FetchProfile.Item.ENVELOPE);
        fp.add(FetchProfile.Item.FLAGS);
        fp.add("X-Mailer");
    }

    class MailsSinceLastCheckFilter
    implements CustomFilter {
        private Date since;

        public MailsSinceLastCheckFilter(Date date) {
            this.since = date;
        }

        @Override
        public SearchTerm getCustomSearch(Folder folder) {
            LOG.info("Building mail filter for messages in " + folder.getName() + " that occur after " + sinceDateParser.format(this.since));
            return new DateTerm(6, this.since){
                private int matched;
                private int seen;
                {
                    this.matched = 0;
                    this.seen = 0;
                }

                public boolean match(Message msg) {
                    boolean isMatch = false;
                    ++this.seen;
                    try {
                        Date msgDate = msg.getReceivedDate();
                        if (msgDate == null) {
                            msgDate = msg.getSentDate();
                        }
                        if (msgDate != null && msgDate.getTime() >= MailsSinceLastCheckFilter.this.since.getTime()) {
                            ++this.matched;
                            isMatch = true;
                        } else {
                            String msgDateStr = msgDate != null ? sinceDateParser.format(msgDate) : "null";
                            String sinceDateStr = MailsSinceLastCheckFilter.this.since != null ? sinceDateParser.format(MailsSinceLastCheckFilter.this.since) : "null";
                            LOG.debug("Message " + msg.getSubject() + " was received at [" + msgDateStr + "], since filter is [" + sinceDateStr + "]");
                        }
                    }
                    catch (MessagingException e) {
                        LOG.warn("Failed to process message due to: " + (Object)((Object)e), (Throwable)e);
                    }
                    if (this.seen % 100 == 0) {
                        LOG.info("Matched " + this.matched + " of " + this.seen + " messages since: " + sinceDateParser.format(MailsSinceLastCheckFilter.this.since));
                    }
                    return isMatch;
                }
            };
        }
    }

    class MessageIterator
    extends SearchTerm
    implements Iterator<Message> {
        private Folder folder;
        private Message[] messagesInCurBatch = null;
        private int current = 0;
        private int currentBatch = 0;
        private int batchSize = 0;
        private int totalInFolder = 0;
        private boolean doBatching = true;

        public MessageIterator(Folder folder, int batchSize) {
            try {
                this.folder = folder;
                this.batchSize = batchSize;
                SearchTerm st = this.getSearchTerm();
                LOG.info("SearchTerm=" + st);
                if (st != null || folder instanceof GmailFolder) {
                    this.doBatching = false;
                    LOG.info("Searching folder " + folder.getName() + " for messages");
                    RTimer searchTimer = new RTimer();
                    if (folder instanceof GmailFolder && MailEntityProcessor.this.fetchMailsSince != null) {
                        String afterCrit = "after:" + afterFmt.format(MailEntityProcessor.this.fetchMailsSince);
                        LOG.info("Added server-side gmail filter: " + afterCrit);
                        Message[] afterMessages = folder.search((SearchTerm)new GmailRawSearchTerm(afterCrit));
                        LOG.info("GMail server-side filter found " + afterMessages.length + " messages received " + afterCrit + " in folder " + folder.getName());
                        this.messagesInCurBatch = folder.search((SearchTerm)(st != null ? st : this), afterMessages);
                    } else {
                        this.messagesInCurBatch = folder.search(st);
                    }
                    this.totalInFolder = this.messagesInCurBatch.length;
                    folder.fetch(this.messagesInCurBatch, fp);
                    this.current = 0;
                    LOG.info("Total messages : " + this.totalInFolder);
                    LOG.info("Search criteria applied. Batching disabled. Took {} (ms)", (Object)searchTimer.getTime());
                } else {
                    this.totalInFolder = folder.getMessageCount();
                    LOG.info("Total messages : " + this.totalInFolder);
                    this.getNextBatch(batchSize, folder);
                }
            }
            catch (MessagingException e) {
                throw new DataImportHandlerException(500, "Message retreival failed", (Throwable)e);
            }
        }

        private void getNextBatch(int batchSize, Folder folder) throws MessagingException {
            int lastMsg;
            if (this.messagesInCurBatch != null) {
                for (Message m : this.messagesInCurBatch) {
                    if (!(m instanceof IMAPMessage)) continue;
                    ((IMAPMessage)m).invalidateHeaders();
                }
            }
            lastMsg = (lastMsg = (this.currentBatch + 1) * batchSize) > this.totalInFolder ? this.totalInFolder : lastMsg;
            this.messagesInCurBatch = folder.getMessages(this.currentBatch * batchSize + 1, lastMsg);
            folder.fetch(this.messagesInCurBatch, fp);
            this.current = 0;
            ++this.currentBatch;
            LOG.info("Current Batch  : " + this.currentBatch);
            LOG.info("Messages in this batch  : " + this.messagesInCurBatch.length);
        }

        @Override
        public boolean hasNext() {
            boolean hasMore;
            boolean bl = hasMore = this.current < this.messagesInCurBatch.length;
            if (!hasMore && this.doBatching && this.currentBatch * this.batchSize < this.totalInFolder) {
                try {
                    this.getNextBatch(this.batchSize, this.folder);
                    hasMore = this.current < this.messagesInCurBatch.length;
                }
                catch (MessagingException e) {
                    throw new DataImportHandlerException(500, "Message retreival failed", (Throwable)e);
                }
            }
            return hasMore;
        }

        @Override
        public Message next() {
            return this.hasNext() ? this.messagesInCurBatch[this.current++] : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("It's read only mode...");
        }

        private SearchTerm getSearchTerm() {
            if (MailEntityProcessor.this.filters.size() == 0) {
                return null;
            }
            if (MailEntityProcessor.this.filters.size() == 1) {
                return ((CustomFilter)MailEntityProcessor.this.filters.get(0)).getCustomSearch(this.folder);
            }
            SearchTerm last = ((CustomFilter)MailEntityProcessor.this.filters.get(0)).getCustomSearch(this.folder);
            for (int i = 1; i < MailEntityProcessor.this.filters.size(); ++i) {
                CustomFilter filter = (CustomFilter)MailEntityProcessor.this.filters.get(i);
                SearchTerm st = filter.getCustomSearch(this.folder);
                if (st == null) continue;
                last = new AndTerm(last, st);
            }
            return last;
        }

        public boolean match(Message message) {
            return true;
        }
    }

    class FolderIterator
    implements Iterator<Folder> {
        private Store mailbox;
        private List<String> topLevelFolders;
        private List<Folder> folders = null;
        private Folder lastFolder = null;

        public FolderIterator(Store mailBox) {
            this.mailbox = mailBox;
            this.folders = new ArrayList<Folder>();
            this.getTopLevelFolders(mailBox);
            if (MailEntityProcessor.this.includeOtherUserFolders) {
                this.getOtherUserFolders();
            }
            if (MailEntityProcessor.this.includeSharedFolders) {
                this.getSharedFolders();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.folders.isEmpty();
        }

        @Override
        public Folder next() {
            try {
                Folder next;
                boolean hasMessages = false;
                do {
                    if (this.lastFolder != null) {
                        this.lastFolder.close(false);
                        this.lastFolder = null;
                    }
                    if (this.folders.isEmpty()) {
                        this.mailbox.close();
                        return null;
                    }
                    next = this.folders.remove(0);
                    if (next == null) continue;
                    String fullName = next.getFullName();
                    if (!this.excludeFolder(fullName)) {
                        hasMessages = (next.getType() & 1) != 0;
                        next.open(1);
                        this.lastFolder = next;
                        LOG.info("Opened folder : " + fullName);
                    }
                    if (!MailEntityProcessor.this.recurse || (next.getType() & 2) == 0) continue;
                    Folder[] children = next.list();
                    LOG.info("Added its children to list  : ");
                    for (int i = children.length - 1; i >= 0; --i) {
                        this.folders.add(0, children[i]);
                        LOG.info("child name : " + children[i].getFullName());
                    }
                    if (children.length != 0) continue;
                    LOG.info("NO children : ");
                } while (!hasMessages);
                return next;
            }
            catch (Exception e) {
                LOG.warn("Failed to read folders due to: " + e);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("It's read only mode...");
        }

        private void getTopLevelFolders(Store mailBox) {
            if (MailEntityProcessor.this.folderNames != null) {
                this.topLevelFolders = Arrays.asList(MailEntityProcessor.this.folderNames.split(","));
            }
            for (int i = 0; this.topLevelFolders != null && i < this.topLevelFolders.size(); ++i) {
                try {
                    this.folders.add(this.mailbox.getFolder(this.topLevelFolders.get(i)));
                    continue;
                }
                catch (MessagingException e) {
                    if (this.folders.size() != 0 || i != this.topLevelFolders.size() - 1) continue;
                    throw new DataImportHandlerException(500, "Folder retreival failed");
                }
            }
            if (this.topLevelFolders == null || this.topLevelFolders.size() == 0) {
                try {
                    this.folders.add(mailBox.getDefaultFolder());
                }
                catch (MessagingException e) {
                    throw new DataImportHandlerException(500, "Folder retreival failed");
                }
            }
        }

        private void getOtherUserFolders() {
            try {
                Folder[] ufldrs = this.mailbox.getUserNamespaces(null);
                if (ufldrs != null) {
                    LOG.info("Found " + ufldrs.length + " user namespace folders");
                    for (Folder ufldr : ufldrs) {
                        this.folders.add(ufldr);
                    }
                }
            }
            catch (MessagingException me) {
                LOG.warn("Messaging exception retrieving user namespaces: " + me.getMessage());
            }
        }

        private void getSharedFolders() {
            try {
                Folder[] sfldrs = this.mailbox.getSharedNamespaces();
                if (sfldrs != null) {
                    LOG.info("Found " + sfldrs.length + " shared namespace folders");
                    for (Folder sfldr : sfldrs) {
                        this.folders.add(sfldr);
                    }
                }
            }
            catch (MessagingException me) {
                LOG.warn("Messaging exception retrieving shared namespaces: " + me.getMessage());
            }
        }

        private boolean excludeFolder(String name) {
            for (String s : MailEntityProcessor.this.exclude) {
                if (!name.matches(s)) continue;
                return true;
            }
            for (String s : MailEntityProcessor.this.include) {
                if (!name.matches(s)) continue;
                return false;
            }
            return MailEntityProcessor.this.include.size() > 0;
        }
    }

    public static interface CustomFilter {
        public SearchTerm getCustomSearch(Folder var1);
    }
}

