/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DebugLogger;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.plugin.SolrCoreAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataImportHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger LOG = Logger.getLogger(DataImportHandler.class.getName());
    private DataImporter importer;
    private Map<String, String> variables = new HashMap<String, String>();
    private NamedList initArgs;
    private Map<String, Properties> dataSources = new HashMap<String, Properties>();
    private DataImporter.RequestParams requestParams;
    private List<SolrInputDocument> debugDocuments;
    private DebugLogger debugLogger;
    private boolean debugEnabled = true;
    public static final String ENABLE_DEBUG = "enableDebug";

    public void init(NamedList args) {
        super.init(args);
        this.initArgs = args;
    }

    public void inform(SolrCore core) {
        try {
            String configLoc;
            NamedList defaults;
            String debug = (String)this.initArgs.get(ENABLE_DEBUG);
            if (debug != null && "no".equals(debug)) {
                this.debugEnabled = false;
            }
            if ((defaults = (NamedList)this.initArgs.get("defaults")) != null && (configLoc = (String)defaults.get("config")) != null && configLoc.length() != 0) {
                this.processConfiguration(defaults);
                this.importer = new DataImporter(SolrWriter.getResourceAsString(core.getResourceLoader().openResource(configLoc)), core, this.dataSources);
            }
        }
        catch (Throwable e) {
            SolrConfig.severeErrors.add(e);
            LOG.log(Level.SEVERE, "Exception while loading DataImporter", e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FATAL: Could not create importer. DataImporter config invalid", e);
        }
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.setHttpCaching(false);
        SolrParams params = req.getParams();
        this.requestParams = new DataImporter.RequestParams(this.getParamsMap(params));
        String command = this.requestParams.command;
        if ("show-config".equals(command)) {
            ModifiableSolrParams rawParams = new ModifiableSolrParams(req.getParams());
            rawParams.set("wt", new String[]{"raw"});
            req.setParams((SolrParams)rawParams);
            String dataConfigFile = this.defaults.get("config");
            ContentStreamBase.StringStream content = new ContentStreamBase.StringStream(SolrWriter.getResourceAsString(req.getCore().getResourceLoader().openResource(dataConfigFile)));
            rsp.add("content", (Object)content);
            return;
        }
        rsp.add("initArgs", (Object)this.initArgs);
        String message = "";
        if (command != null) {
            rsp.add("command", (Object)command);
        }
        if (this.requestParams.debug) {
            this.importer = null;
            if (this.requestParams.dataConfig != null) {
                try {
                    this.processConfiguration((NamedList)this.initArgs.get("defaults"));
                    this.importer = new DataImporter(this.requestParams.dataConfig, req.getCore(), this.dataSources);
                }
                catch (RuntimeException e) {
                    rsp.add("exception", (Object)DebugLogger.getStacktraceString(e));
                    this.importer = null;
                    return;
                }
            } else {
                this.inform(req.getCore());
            }
            message = "Configuration Re-loaded sucessfully";
        }
        if (this.importer == null) {
            rsp.add("status", (Object)"DataImportHandler started. Not Initialized. No commands can be run");
            return;
        }
        if (command != null && "abort".equals(command)) {
            this.importer.runCmd(this.requestParams, null, null);
        } else if (this.importer.getStatus() != DataImporter.Status.IDLE) {
            message = "A command is still running...";
        } else if (command != null) {
            if ("full-import".equals(command) || "delta-import".equals(command)) {
                UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessingChain(params.get("update.processor"));
                UpdateRequestProcessor processor = processorChain.createProcessor(req, rsp);
                SolrResourceLoader loader = req.getCore().getResourceLoader();
                SolrWriter sw = this.getSolrWriter(processor, loader, req.getSchema());
                if (this.requestParams.debug) {
                    if (this.debugEnabled) {
                        this.importer.runCmd(this.requestParams, sw, this.variables);
                        rsp.add("mode", (Object)"debug");
                        rsp.add("documents", this.debugDocuments);
                        if (this.debugLogger != null) {
                            rsp.add("verbose-output", (Object)this.debugLogger.output);
                        }
                        this.debugLogger = null;
                        this.debugDocuments = null;
                    } else {
                        message = "Debug not enabled. Add a tag <str name=\"enableDebug\">true</str> in solrconfig.xml";
                    }
                } else {
                    this.importer.runAsync(this.requestParams, sw, this.variables);
                }
            } else if ("reload-config".equals(command)) {
                this.importer = null;
                this.inform(req.getCore());
                message = "Configuration Re-loaded sucessfully";
            }
        }
        rsp.add("status", (Object)(this.importer.getStatus() == DataImporter.Status.IDLE ? "idle" : "busy"));
        rsp.add("importResponse", (Object)message);
        rsp.add("statusMessages", this.importer.getStatusMessages());
        RequestHandlerUtils.addExperimentalFormatWarning((SolrQueryResponse)rsp);
    }

    private Map<String, Object> getParamsMap(SolrParams params) {
        Iterator names = params.getParameterNamesIterator();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (names.hasNext()) {
            String s = (String)names.next();
            String[] val = params.getParams(s);
            if (val == null || val.length < 1) continue;
            if (val.length == 1) {
                result.put(s, val[0]);
                continue;
            }
            result.put(s, Arrays.asList(val));
        }
        return result;
    }

    private void processConfiguration(NamedList defaults) {
        if (defaults == null) {
            LOG.info("No configuration specified in solrconfig.xml for DataImportHandler");
            return;
        }
        LOG.info("Processing configuration from solrconfig.xml: " + defaults);
        this.dataSources = new HashMap<String, Properties>();
        this.variables = new HashMap<String, String>();
        for (int position = 0; position < defaults.size() && defaults.getName(position) != null; ++position) {
            String name = defaults.getName(position);
            if (name.equals("datasource")) {
                NamedList dsConfig = (NamedList)defaults.getVal(position);
                Properties props = new Properties();
                for (int i = 0; i < dsConfig.size(); ++i) {
                    props.put(dsConfig.getName(i), dsConfig.getVal(i));
                }
                LOG.info("Adding properties to datasource: " + props);
                this.dataSources.put((String)dsConfig.get("name"), props);
                continue;
            }
            if (name.equals("config")) continue;
            String value = (String)defaults.getVal(position);
            this.variables.put(name, value);
        }
    }

    private SolrWriter getSolrWriter(UpdateRequestProcessor processor, SolrResourceLoader loader, IndexSchema schema) {
        return new SolrWriter(processor, loader.getConfigDir()){

            public boolean upload(SolrWriter.SolrDoc d) {
                try {
                    SolrInputDocument document = ((SolrDocumentWrapper)d).doc;
                    if (((DataImportHandler)DataImportHandler.this).requestParams.debug) {
                        if (DataImportHandler.this.debugDocuments == null) {
                            DataImportHandler.this.debugDocuments = new ArrayList();
                        }
                        DataImportHandler.this.debugDocuments.add(document);
                        if (DataImportHandler.this.debugDocuments.size() >= ((DataImportHandler)DataImportHandler.this).requestParams.rows) {
                            DataImportHandler.this.importer.getDocBuilder().abort();
                        }
                    }
                    return super.upload(document);
                }
                catch (RuntimeException e) {
                    LOG.log(Level.SEVERE, "Exception while adding: " + d, e);
                    return false;
                }
            }

            public void log(int event, String name, Object row) {
                if (DataImportHandler.this.debugLogger == null) {
                    DataImportHandler.this.debugLogger = new DebugLogger();
                }
                DataImportHandler.this.debugLogger.log(event, name, row);
            }

            public SolrWriter.SolrDoc getSolrDocInstance() {
                return new SolrDocumentWrapper();
            }
        };
    }

    public NamedList getStatistics() {
        if (this.importer == null) {
            return super.getStatistics();
        }
        DocBuilder.Statistics cumulative = this.importer.cumulativeStatistics;
        NamedList result = new NamedList();
        result.add("Status", (Object)this.importer.getStatus().toString());
        if (this.importer.docBuilder != null) {
            DocBuilder.Statistics running = this.importer.docBuilder.importStatistics;
            result.add("Documents Processed", (Object)running.docCount);
            result.add("Requests made to DataSource", (Object)running.queryCount);
            result.add("Rows Fetched", (Object)running.rowsCount);
            result.add("Documents Deleted", (Object)running.deletedDocCount);
            result.add("Documents Skipped", (Object)running.skipDocCount);
        }
        result.add("Total Documents Processed", (Object)cumulative.docCount);
        result.add("Total Requests made to DataSource", (Object)cumulative.queryCount);
        result.add("Total Rows Fetched", (Object)cumulative.rowsCount);
        result.add("Total Documents Deleted", (Object)cumulative.deletedDocCount);
        result.add("Total Documents Skipped", (Object)cumulative.skipDocCount);
        NamedList requestStatistics = super.getStatistics();
        if (requestStatistics != null) {
            for (int i = 0; i < requestStatistics.size(); ++i) {
                result.add(requestStatistics.getName(i), requestStatistics.getVal(i));
            }
        }
        return result;
    }

    public String getDescription() {
        return "Manage data import from databases to Solr";
    }

    public String getSourceId() {
        return "$Id: DataImportHandler.java 690134 2008-08-29 07:18:52Z shalin $";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/contrib/dataimporthandler/src/main/java/org/apache/solr/handler/dataimport/DataImportHandler.java $";
    }

    static class SolrDocumentWrapper
    implements SolrWriter.SolrDoc {
        SolrInputDocument doc = new SolrInputDocument();

        public void setDocumentBoost(float boost) {
            this.doc.setDocumentBoost(boost);
        }

        public Object getField(String field) {
            return this.doc.getField(field);
        }

        public void addField(String name, Object value, float boost) {
            this.doc.addField(name, value, boost);
        }

        public String toString() {
            return this.doc.toString();
        }
    }
}

