/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.apache.solr.handler.dataimport.TemplateString;
import org.apache.solr.handler.dataimport.XPathRecordReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathEntityProcessor
extends EntityProcessorBase {
    private static final Logger LOG = Logger.getLogger(XPathEntityProcessor.class.getName());
    protected List<String> placeHolderVariables;
    protected List<String> commonFields;
    private String pk;
    private XPathRecordReader xpathReader;
    protected DataSource<Reader> dataSource;
    protected Transformer xslTransformer;
    protected boolean useSolrAddXml = false;
    protected boolean streamRows = false;
    private int batchSz = 1000;
    public static final String URL = "url";
    public static final String HAS_MORE = "$hasMore";
    public static final String NEXT_URL = "$nextUrl";
    public static final String XPATH_FIELD_NAME = "$forEach";
    public static final String FOR_EACH = "forEach";
    public static final String XPATH = "xpath";
    public static final String COMMON_FIELD = "commonField";
    public static final String USE_SOLR_ADD_SCHEMA = "useSolrAddSchema";
    public static final String XSL = "xsl";
    public static final String STREAM = "stream";

    @Override
    public void init(Context context) {
        super.init(context);
        if (this.xpathReader == null) {
            this.initXpathReader();
        }
        this.pk = context.getEntityAttribute("pk");
        this.dataSource = context.getDataSource();
    }

    private void initXpathReader() {
        String xslt;
        this.useSolrAddXml = Boolean.parseBoolean(this.context.getEntityAttribute(USE_SOLR_ADD_SCHEMA));
        this.streamRows = Boolean.parseBoolean(this.context.getEntityAttribute(STREAM));
        if (this.context.getEntityAttribute("batchSize") != null) {
            this.batchSz = Integer.parseInt(this.context.getEntityAttribute("batchSize"));
        }
        if ((xslt = this.context.getEntityAttribute(XSL)) != null) {
            xslt = this.resolver.replaceTokens(xslt);
            try {
                StreamSource xsltSource = new StreamSource(xslt);
                TransformerFactory transFact = TransformerFactory.newInstance();
                this.xslTransformer = transFact.newTransformer(xsltSource);
                LOG.info("Using xslTransformer: " + this.xslTransformer.getClass().getName());
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Error initializing XSL ", e);
            }
        }
        if (this.useSolrAddXml) {
            this.xpathReader = new XPathRecordReader("/add/doc");
            this.xpathReader.addField("name", "/add/doc/field/@name", true);
            this.xpathReader.addField("value", "/add/doc/field", true);
        } else {
            String forEachXpath = this.context.getEntityAttribute(FOR_EACH);
            if (forEachXpath == null) {
                throw new DataImportHandlerException(500, "Entity : " + this.context.getEntityAttribute("name") + " must have a 'forEach' attribute");
            }
            try {
                this.xpathReader = new XPathRecordReader(forEachXpath);
                for (Map<String, String> map : this.context.getAllEntityFields()) {
                    if (map.get(XPATH) == null) continue;
                    this.xpathReader.addField(map.get("column"), map.get(XPATH), Boolean.parseBoolean(map.get("multiValued")));
                }
            }
            catch (RuntimeException e) {
                throw new DataImportHandlerException(500, "Exception while reading xpaths for fields", e);
            }
        }
        List<String> l = TemplateString.getVariables(this.context.getEntityAttribute(URL));
        for (String string : l) {
            if (!string.startsWith(this.entityName + ".")) continue;
            if (this.placeHolderVariables == null) {
                this.placeHolderVariables = new ArrayList<String>();
            }
            this.placeHolderVariables.add(string.substring(this.entityName.length() + 1));
        }
        for (Map map : this.context.getAllEntityFields()) {
            if (map.get(COMMON_FIELD) == null || !"true".equals(map.get(COMMON_FIELD))) continue;
            if (this.commonFields == null) {
                this.commonFields = new ArrayList<String>();
            }
            this.commonFields.add((String)map.get("column"));
        }
    }

    @Override
    public Map<String, Object> nextRow() {
        Map<String, Object> result;
        if (!this.context.isRootEntity()) {
            return this.fetchNextRow();
        }
        do {
            if ((result = this.fetchNextRow()) != null) continue;
            return null;
        } while (this.pk != null && result.get(this.pk) == null);
        return result;
    }

    private Map<String, Object> fetchNextRow() {
        Map<String, Object> r = null;
        do {
            if (this.rowcache != null) {
                return this.getFromRowCache();
            }
            if (this.rowIterator == null) {
                this.initQuery(this.resolver.replaceTokens(this.context.getEntityAttribute(URL)));
            }
            if ((r = this.getNext()) != null) continue;
            Object hasMore = this.getSessionAttribute(HAS_MORE);
            if ("true".equals(hasMore) || Boolean.TRUE.equals(hasMore)) {
                Map namespace;
                String url = (String)this.getSessionAttribute(NEXT_URL);
                if (url == null) {
                    url = this.context.getEntityAttribute(URL);
                }
                if ((namespace = (Map)this.getSessionAttribute(this.entityName)) != null) {
                    this.resolver.addNamespace(this.entityName, namespace);
                }
                this.clearSession();
                this.initQuery(this.resolver.replaceTokens(url));
                r = this.getNext();
                if (r != null) continue;
                return null;
            }
            return null;
        } while ((r = this.applyTransformer(r)) == null);
        return this.readUsefulVars(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initQuery(String s) {
        Reader data = null;
        try {
            final ArrayList rows = new ArrayList();
            data = this.dataSource.getData(s);
            if (this.xslTransformer != null) {
                try {
                    SimpleCharArrayReader caw = new SimpleCharArrayReader();
                    this.xslTransformer.transform(new StreamSource(data), new StreamResult(caw));
                    data = caw.getReader();
                }
                catch (TransformerException e) {
                    throw new DataImportHandlerException(500, "Exception in applying XSL Transformeation", e);
                }
            }
            if (this.streamRows) {
                this.rowIterator = this.getRowIterator(data);
            } else {
                this.xpathReader.streamRecords(data, new XPathRecordReader.Handler(){

                    @Override
                    public void handle(Map<String, Object> record, String xpath) {
                        rows.add(XPathEntityProcessor.this.readRow(record, xpath));
                    }
                });
                this.rowIterator = rows.iterator();
            }
            if (!this.streamRows) {
                this.closeIt(data);
            }
        }
        catch (Throwable throwable) {
            if (!this.streamRows) {
                this.closeIt(data);
            }
            throw throwable;
        }
    }

    private void closeIt(Reader data) {
        try {
            data.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, Object> readRow(Map<String, Object> record, String xpath) {
        if (this.useSolrAddXml) {
            List names = (List)record.get("name");
            List values = (List)record.get("value");
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 0; i < names.size(); ++i) {
                if (row.containsKey(names.get(i))) {
                    ArrayList<Object> list;
                    Object existing = row.get(names.get(i));
                    if (existing instanceof List) {
                        list = (ArrayList<Object>)existing;
                        list.add(values.get(i));
                        continue;
                    }
                    list = new ArrayList<Object>();
                    list.add(existing);
                    list.add(values.get(i));
                    row.put((String)names.get(i), list);
                    continue;
                }
                row.put((String)names.get(i), values.get(i));
            }
            return row;
        }
        record.put(XPATH_FIELD_NAME, xpath);
        return record;
    }

    private Map<String, Object> readUsefulVars(Map<String, Object> r) {
        Object val = r.get(HAS_MORE);
        if (val != null) {
            this.setSessionAttribute(HAS_MORE, val);
        }
        if ((val = r.get(NEXT_URL)) != null) {
            this.setSessionAttribute(NEXT_URL, val);
        }
        if (this.placeHolderVariables != null) {
            Map namespace = this.getNameSpace();
            for (String s : this.placeHolderVariables) {
                val = r.get(s);
                if (val == null) continue;
                namespace.put(s, val);
            }
        }
        if (this.commonFields != null) {
            for (String s : this.commonFields) {
                Object commonVal = r.get(s);
                if (commonVal != null) {
                    this.setSessionAttribute(s, commonVal);
                    this.getNameSpace().put(s, commonVal);
                    continue;
                }
                commonVal = this.getSessionAttribute(s);
                if (commonVal == null) continue;
                r.put(s, commonVal);
            }
        }
        return r;
    }

    private Iterator<Map<String, Object>> getRowIterator(final Reader data) {
        final ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(this.batchSz);
        final AtomicBoolean isEnd = new AtomicBoolean(false);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    XPathEntityProcessor.this.xpathReader.streamRecords(data, new XPathRecordReader.Handler(){

                        @Override
                        public void handle(Map<String, Object> record, String xpath) {
                            if (isEnd.get()) {
                                return;
                            }
                            try {
                                blockingQueue.offer(XPathEntityProcessor.this.readRow(record, xpath), 10L, TimeUnit.SECONDS);
                            }
                            catch (Exception e) {
                                isEnd.set(true);
                            }
                        }
                    });
                }
                finally {
                    XPathEntityProcessor.this.closeIt(data);
                    try {
                        blockingQueue.offer(Collections.EMPTY_MAP, 10L, TimeUnit.SECONDS);
                    }
                    catch (Exception exception) {}
                }
            }
        }.start();
        return new Iterator<Map<String, Object>>(){

            @Override
            public boolean hasNext() {
                return !isEnd.get();
            }

            @Override
            public Map<String, Object> next() {
                try {
                    Map row = (Map)blockingQueue.poll(10L, TimeUnit.SECONDS);
                    if (row == null || row == Collections.EMPTY_MAP) {
                        isEnd.set(true);
                        return null;
                    }
                    return row;
                }
                catch (InterruptedException e) {
                    isEnd.set(true);
                    return null;
                }
            }

            @Override
            public void remove() {
            }
        };
    }

    private Map getNameSpace() {
        HashMap namespace = (HashMap)this.getSessionAttribute(this.entityName);
        if (namespace == null) {
            namespace = new HashMap();
            this.setSessionAttribute(this.entityName, namespace);
        }
        return namespace;
    }

    private static class SimpleCharArrayReader
    extends CharArrayWriter {
        private SimpleCharArrayReader() {
        }

        public Reader getReader() {
            return new CharArrayReader(this.buf, 0, this.count);
        }
    }
}

