/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConfig {
    static final Logger LOG = LoggerFactory.getLogger(DataConfig.class);
    public Document document;
    public List<Map<String, String>> functions = new ArrayList<Map<String, String>>();
    public Script script;
    public Map<String, Properties> dataSources = new HashMap<String, Properties>();
    public Map<String, SchemaField> lowerNameVsSchemaField = new HashMap<String, SchemaField>();
    boolean isMultiThreaded = false;
    public static final String SCRIPT = "script";
    public static final String NAME = "name";
    public static final String PROCESSOR = "processor";
    @Deprecated
    public static final String IMPORTER_NS = "dataimporter";
    public static final String IMPORTER_NS_SHORT = "dih";
    public static final String ROOT_ENTITY = "rootEntity";
    public static final String FUNCTION = "function";
    public static final String CLASS = "class";
    public static final String DATA_SRC = "dataSource";
    private static final Set<String> RESERVED_WORDS = new HashSet<String>();

    public void readFromXml(Element e) {
        block8: {
            Element element;
            Iterator<Object> i$;
            List<Element> n = DataConfig.getChildNodes(e, "document");
            if (n.isEmpty()) {
                throw new DataImportHandlerException(500, "DataImportHandler configuration file must have one <document> node.");
            }
            this.document = new Document(n.get(0));
            n = DataConfig.getChildNodes(e, SCRIPT);
            if (!n.isEmpty()) {
                this.script = new Script(n.get(0));
            }
            if (!(n = DataConfig.getChildNodes(e, FUNCTION)).isEmpty()) {
                i$ = n.iterator();
                while (i$.hasNext()) {
                    element = i$.next();
                    String func = DataConfig.getStringAttribute(element, NAME, null);
                    String clz = DataConfig.getStringAttribute(element, CLASS, null);
                    if (func == null || clz == null) {
                        throw new DataImportHandlerException(500, "<function> must have a 'name' and 'class' attributes");
                    }
                    this.functions.add(DataConfig.getAllAttributes(element));
                }
            }
            if (!(n = DataConfig.getChildNodes(e, DATA_SRC)).isEmpty()) {
                i$ = n.iterator();
                while (i$.hasNext()) {
                    element = i$.next();
                    Properties p = new Properties();
                    HashMap<String, String> attrs = DataConfig.getAllAttributes(element);
                    for (Map.Entry<String, String> entry : attrs.entrySet()) {
                        p.setProperty(entry.getKey(), entry.getValue());
                    }
                    this.dataSources.put(p.getProperty(NAME), p);
                }
            }
            if (this.dataSources.get(null) != null || !(i$ = this.dataSources.values().iterator()).hasNext()) break block8;
            Properties properties = (Properties)i$.next();
            this.dataSources.put(null, properties);
        }
    }

    private static String getStringAttribute(Element e, String name, String def) {
        String r = e.getAttribute(name);
        if (r == null || "".equals(r.trim())) {
            r = def;
        }
        return r;
    }

    private static HashMap<String, String> getAllAttributes(Element e) {
        HashMap<String, String> m = new HashMap<String, String>();
        NamedNodeMap nnm = e.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            m.put(nnm.item(i).getNodeName(), nnm.item(i).getNodeValue());
        }
        return m;
    }

    public static String getTxt(Node elem, StringBuilder buffer) {
        if (elem.getNodeType() != 4) {
            NodeList childs = elem.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                short childType = child.getNodeType();
                if (childType == 8 || childType == 7) continue;
                DataConfig.getTxt(child, buffer);
            }
        } else {
            buffer.append(elem.getNodeValue());
        }
        return buffer.toString();
    }

    public static List<Element> getChildNodes(Element e, String byName) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList l = e.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (!e.equals(l.item(i).getParentNode()) || !byName.equals(l.item(i).getNodeName())) continue;
            result.add((Element)l.item(i));
        }
        return result;
    }

    public void clearCaches() {
        for (Entity entity : this.document.entities) {
            entity.clearCache();
        }
    }

    static {
        RESERVED_WORDS.add(IMPORTER_NS);
        RESERVED_WORDS.add(IMPORTER_NS_SHORT);
        RESERVED_WORDS.add("request");
        RESERVED_WORDS.add("delta");
        RESERVED_WORDS.add("functions");
        RESERVED_WORDS.add("session");
        RESERVED_WORDS.add("last_index_time");
    }

    public static class Field {
        public String column;
        public String name;
        public Float boost = Float.valueOf(1.0f);
        public boolean toWrite = true;
        public boolean multiValued = false;
        boolean dynamicName;
        public Map<String, String> allAttributes = new HashMap<String, String>(){

            @Override
            public String put(String key, String value) {
                if (super.containsKey(key)) {
                    return (String)super.get(key);
                }
                return super.put(key, value);
            }
        };
        public Entity entity;

        public Field() {
        }

        public Field(Element e) {
            this.name = DataConfig.getStringAttribute(e, DataConfig.NAME, null);
            this.column = DataConfig.getStringAttribute(e, "column", null);
            if (this.column == null) {
                throw new DataImportHandlerException(500, "Field must have a column attribute");
            }
            this.boost = Float.valueOf(Float.parseFloat(DataConfig.getStringAttribute(e, "boost", "1.0f")));
            this.allAttributes.putAll(DataConfig.getAllAttributes(e));
        }

        public String getName() {
            return this.name == null ? this.column : this.name;
        }
    }

    public static class Script {
        public String language;
        public String text;

        public Script() {
        }

        public Script(Element e) {
            this.language = DataConfig.getStringAttribute(e, "language", "JavaScript");
            StringBuilder buffer = new StringBuilder();
            String script = DataConfig.getTxt(e, buffer);
            if (script != null) {
                this.text = script.trim();
            }
        }
    }

    public static class Entity {
        public String name;
        public String pk;
        public String pkMappingFromSchema;
        public String dataSource;
        public Map<String, String> allAttributes;
        public String proc;
        public String docRoot;
        public boolean isDocRoot = false;
        public List<Field> fields = new ArrayList<Field>();
        public List<Map<String, String>> allFieldsList = new ArrayList<Map<String, String>>();
        public List<Entity> entities;
        public Entity parentEntity;
        public EntityProcessorWrapper processor;
        public DataSource dataSrc;
        public Map<String, List<Field>> colNameVsField = new HashMap<String, List<Field>>();

        public Entity() {
        }

        public Entity(Element element) {
            this.name = DataConfig.getStringAttribute(element, DataConfig.NAME, null);
            if (this.name == null) {
                LOG.warn("Entity does not have a name");
                this.name = "" + System.nanoTime();
            }
            if (this.name.indexOf(".") != -1) {
                throw new DataImportHandlerException(500, "Entity name must not have period (.): '" + this.name);
            }
            if (RESERVED_WORDS.contains(this.name)) {
                throw new DataImportHandlerException(500, "Entity name : '" + this.name + "' is a reserved keyword. Reserved words are: " + RESERVED_WORDS);
            }
            this.pk = DataConfig.getStringAttribute(element, "pk", null);
            this.docRoot = DataConfig.getStringAttribute(element, DataConfig.ROOT_ENTITY, null);
            this.proc = DataConfig.getStringAttribute(element, DataConfig.PROCESSOR, null);
            this.dataSource = DataConfig.getStringAttribute(element, DataConfig.DATA_SRC, null);
            this.allAttributes = DataConfig.getAllAttributes(element);
            List<Element> n = DataConfig.getChildNodes(element, "field");
            for (Element elem : n) {
                Field field = new Field(elem);
                this.fields.add(field);
                List<Field> l = this.colNameVsField.get(field.column);
                if (l == null) {
                    l = new ArrayList<Field>();
                }
                boolean alreadyFound = false;
                for (Field f : l) {
                    if (!f.getName().equals(field.getName())) continue;
                    alreadyFound = true;
                    break;
                }
                if (!alreadyFound) {
                    l.add(field);
                }
                this.colNameVsField.put(field.column, l);
            }
            n = DataConfig.getChildNodes(element, "entity");
            if (!n.isEmpty()) {
                this.entities = new ArrayList<Entity>();
            }
            for (Element elem : n) {
                this.entities.add(new Entity(elem));
            }
        }

        public void clearCache() {
            if (this.entities != null) {
                for (Entity entity : this.entities) {
                    entity.clearCache();
                }
            }
            try {
                this.processor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.processor = null;
            if (this.dataSrc != null) {
                this.dataSrc.close();
            }
            this.dataSrc = null;
        }

        public String getPk() {
            return this.pk == null ? this.pkMappingFromSchema : this.pk;
        }

        public String getSchemaPk() {
            return this.pkMappingFromSchema != null ? this.pkMappingFromSchema : this.pk;
        }
    }

    public static class Document {
        public String deleteQuery;
        public List<Entity> entities = new ArrayList<Entity>();
        public String onImportStart;
        public String onImportEnd;

        public Document() {
        }

        public Document(Element element) {
            this.deleteQuery = DataConfig.getStringAttribute(element, "deleteQuery", null);
            this.onImportStart = DataConfig.getStringAttribute(element, "onImportStart", null);
            this.onImportEnd = DataConfig.getStringAttribute(element, "onImportEnd", null);
            List<Element> l = DataConfig.getChildNodes(element, "entity");
            for (Element e : l) {
                this.entities.add(new Entity(e));
            }
        }
    }
}

