/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DebugLogger;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrWriter {
    private static final Logger log = LoggerFactory.getLogger(SolrWriter.class);
    static final String IMPORTER_PROPERTIES = "dataimport.properties";
    static final String LAST_INDEX_KEY = "last_index_time";
    private final UpdateRequestProcessor processor;
    private final String configDir;
    private String persistFilename = "dataimport.properties";
    DebugLogger debugLogger;
    public static final int START_ENTITY = 1;
    public static final int END_ENTITY = 2;
    public static final int TRANSFORMED_ROW = 3;
    public static final int ENTITY_META = 4;
    public static final int PRE_TRANSFORMER_ROW = 5;
    public static final int START_DOC = 6;
    public static final int END_DOC = 7;
    public static final int ENTITY_OUT = 8;
    public static final int ROW_END = 9;
    public static final int TRANSFORMER_EXCEPTION = 10;
    public static final int ENTITY_EXCEPTION = 11;
    public static final int DISABLE_LOGGING = 12;
    public static final int ENABLE_LOGGING = 13;

    public SolrWriter(UpdateRequestProcessor processor, String confDir) {
        this.processor = processor;
        this.configDir = confDir;
    }

    public SolrWriter(UpdateRequestProcessor processor, String confDir, String filePrefix) {
        this.processor = processor;
        this.configDir = confDir;
        if (filePrefix != null) {
            this.persistFilename = filePrefix + ".properties";
        }
    }

    public boolean upload(SolrInputDocument d) {
        try {
            AddUpdateCommand command = new AddUpdateCommand();
            command.solrDoc = d;
            command.allowDups = false;
            command.overwritePending = true;
            command.overwriteCommitted = true;
            this.processor.processAdd(command);
        }
        catch (Exception e) {
            log.warn("Error creating document : " + d, (Throwable)e);
            return false;
        }
        return true;
    }

    public void deleteDoc(Object id) {
        try {
            log.info("Deleting document: " + id);
            DeleteUpdateCommand delCmd = new DeleteUpdateCommand();
            delCmd.id = id.toString();
            delCmd.fromPending = true;
            delCmd.fromCommitted = true;
            this.processor.processDelete(delCmd);
        }
        catch (IOException e) {
            log.error("Exception while deleteing: " + id, (Throwable)e);
        }
    }

    void persist(Properties p) {
        OutputStream propOutput = null;
        Properties props = this.readIndexerProperties();
        try {
            props.putAll((Map<?, ?>)p);
            File persistFile = this.getPersistFile();
            propOutput = new FileOutputStream(persistFile);
            props.store(propOutput, null);
            log.info("Wrote last indexed time to " + persistFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new DataImportHandlerException(500, "Unable to persist Index Start Time", e);
        }
        catch (IOException e) {
            throw new DataImportHandlerException(500, "Unable to persist Index Start Time", e);
        }
        finally {
            try {
                if (propOutput != null) {
                    propOutput.close();
                }
            }
            catch (IOException e) {
                propOutput = null;
            }
        }
    }

    File getPersistFile() {
        String filePath = this.configDir;
        if (this.configDir != null && !this.configDir.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        filePath = filePath + this.persistFilename;
        return new File(filePath);
    }

    void finish() {
        try {
            this.processor.finish();
        }
        catch (IOException e) {
            throw new DataImportHandlerException(500, "Unable to call finish() on UpdateRequestProcessor", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties readIndexerProperties() {
        Properties props = new Properties();
        InputStream propInput = null;
        try {
            propInput = new FileInputStream(this.configDir + this.persistFilename);
            props.load(propInput);
            log.info("Read " + this.persistFilename);
        }
        catch (Exception e) {
            log.warn("Unable to read: " + this.persistFilename);
        }
        finally {
            try {
                if (propInput != null) {
                    propInput.close();
                }
            }
            catch (IOException e) {
                propInput = null;
            }
        }
        return props;
    }

    public void deleteByQuery(String query) {
        try {
            log.info("Deleting documents from Solr with query: " + query);
            DeleteUpdateCommand delCmd = new DeleteUpdateCommand();
            delCmd.query = query;
            delCmd.fromCommitted = true;
            delCmd.fromPending = true;
            this.processor.processDelete(delCmd);
        }
        catch (IOException e) {
            log.error("Exception while deleting by query: " + query, (Throwable)e);
        }
    }

    public void commit(boolean optimize) {
        try {
            CommitUpdateCommand commit = new CommitUpdateCommand(optimize);
            this.processor.processCommit(commit);
        }
        catch (Throwable t) {
            log.error("Exception while solr commit.", t);
        }
    }

    public void rollback() {
        try {
            RollbackUpdateCommand rollback = new RollbackUpdateCommand();
            this.processor.processRollback(rollback);
        }
        catch (Throwable t) {
            log.error("Exception while solr rollback.", t);
        }
    }

    public void doDeleteAll() {
        try {
            DeleteUpdateCommand deleteCommand = new DeleteUpdateCommand();
            deleteCommand.query = "*:*";
            deleteCommand.fromCommitted = true;
            deleteCommand.fromPending = true;
            this.processor.processDelete(deleteCommand);
        }
        catch (IOException e) {
            throw new DataImportHandlerException(500, "Exception in full dump while deleting all documents.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getResourceAsString(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        byte[] buf = new byte[1024];
        int sz = 0;
        try {
            while ((sz = in.read(buf)) != -1) {
                baos.write(buf, 0, sz);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return new String(baos.toByteArray(), "UTF-8");
    }

    static String getDocCount() {
        if (DocBuilder.INSTANCE.get() != null) {
            return "" + (DocBuilder.INSTANCE.get().importStatistics.docCount.get() + 1L);
        }
        return null;
    }

    public DebugLogger getDebugLogger() {
        if (this.debugLogger == null) {
            this.debugLogger = new DebugLogger(this);
        }
        return this.debugLogger;
    }

    public void log(int event, String name, Object row) {
        this.getDebugLogger().log(event, name, row);
    }
}

