/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.VariableResolver;

public class ThreadedContext
extends ContextImpl {
    private DocBuilder.EntityRunner entityRunner;
    private boolean limitedContext = false;

    public ThreadedContext(DocBuilder.EntityRunner entityRunner, DocBuilder docBuilder) {
        super(entityRunner.entity, null, null, null, docBuilder.session, null, docBuilder);
        this.entityRunner = entityRunner;
    }

    public VariableResolver getVariableResolver() {
        this.checkLimited();
        return this.entityRunner.currentEntityProcWrapper.get().resolver;
    }

    public Context getParentContext() {
        ThreadedContext ctx = new ThreadedContext(this.entityRunner.parent, this.docBuilder);
        ctx.limitedContext = true;
        return ctx;
    }

    public String currentProcess() {
        return this.entityRunner.currentProcess;
    }

    public EntityProcessor getEntityProcessor() {
        return this.entityRunner.currentEntityProcWrapper.get().delegate;
    }

    public DataSource getDataSource() {
        this.checkLimited();
        return super.getDataSource();
    }

    private void checkLimited() {
        if (this.limitedContext) {
            throw new RuntimeException("parentContext does not support this method");
        }
    }

    public String getResolvedEntityAttribute(String name) {
        this.checkLimited();
        return this.entity == null ? null : this.getVariableResolver().replaceTokens(this.entity.allAttributes.get(name));
    }

    public void setSessionAttribute(String name, Object val, String scope) {
        this.checkLimited();
        super.setSessionAttribute(name, val, scope);
    }

    public Object resolve(String var) {
        return this.getVariableResolver().resolve(var);
    }

    public String replaceTokens(String template) {
        return this.getVariableResolver().replaceTokens(template);
    }
}

