/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.VariableResolverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedEntityProcessorWrapper
extends EntityProcessorWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadedEntityProcessorWrapper.class);
    final DocBuilder.EntityRunner entityRunner;
    final Map<DataConfig.Entity, DocBuilder.EntityRunner> children;

    public ThreadedEntityProcessorWrapper(EntityProcessor delegate, DocBuilder docBuilder, DocBuilder.EntityRunner entityRunner, VariableResolverImpl resolver) {
        super(delegate, docBuilder);
        this.entityRunner = entityRunner;
        this.resolver = resolver;
        if (entityRunner.entity.entities == null) {
            this.children = Collections.emptyMap();
        } else {
            this.children = new HashMap<DataConfig.Entity, DocBuilder.EntityRunner>(entityRunner.entity.entities.size());
            for (DataConfig.Entity e : entityRunner.entity.entities) {
                DocBuilder.EntityRunner runner = docBuilder.createRunner(e, entityRunner);
                this.children.put(e, runner);
            }
        }
    }

    void threadedInit(Context context) {
        this.rowcache = null;
        this.context = context;
        this.resolver = (VariableResolverImpl)context.getVariableResolver();
        if (this.entityName == null) {
            this.onError = this.resolver.replaceTokens(context.getEntityAttribute("onError"));
            if (this.onError == null) {
                this.onError = "abort";
            }
            this.entityName = context.getEntityAttribute("name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> nextRow() {
        Map<String, Object> arow;
        if (this.rowcache != null) {
            return this.getFromRowCache();
        }
        do {
            arow = null;
            EntityProcessor entityProcessor = this.delegate;
            synchronized (entityProcessor) {
                if (this.entityRunner.entityEnded.get()) {
                    return null;
                }
                try {
                    arow = this.delegate.nextRow();
                }
                catch (Exception e) {
                    if ("abort".equals(this.onError)) {
                        DataImportHandlerException.wrapAndThrow(500, e);
                    }
                    LOG.error("Exception in entity : " + this.entityName, (Throwable)e);
                    return null;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("arow : " + arow);
                }
                if (arow == null) {
                    this.entityRunner.entityEnded.set(true);
                }
            }
            if (arow != null) continue;
            return null;
        } while ((arow = this.applyTransformer(arow)) == null);
        this.delegate.postTransform(arow);
        return arow;
    }

    public void init(DocBuilder.EntityRow rows) {
        DocBuilder.EntityRow row = rows;
        while (row != null) {
            this.resolver.addNamespace(row.name, row.row);
            row = row.tail;
        }
    }
}

