/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DIHLogLevels;
import org.apache.solr.handler.dataimport.DIHPropertiesWriter;
import org.apache.solr.handler.dataimport.DIHWriter;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DebugLogger;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.EvaluatorBag;
import org.apache.solr.handler.dataimport.EventListener;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.SqlEntityProcessor;
import org.apache.solr.handler.dataimport.ThreadedContext;
import org.apache.solr.handler.dataimport.ThreadedEntityProcessorWrapper;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.VariableResolverImpl;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DocBuilder.class);
    private static final Date EPOCH = new Date(0L);
    DataImporter dataImporter;
    private DataConfig.Document document;
    private DataConfig.Entity root;
    private Map statusMessages = Collections.synchronizedMap(new LinkedHashMap());
    public Statistics importStatistics = new Statistics();
    DIHWriter writer;
    DataImporter.RequestParams requestParameters;
    boolean verboseDebug = false;
    Map<String, Object> session = new ConcurrentHashMap<String, Object>();
    static final ThreadLocal<DocBuilder> INSTANCE = new ThreadLocal();
    Map<String, Object> functionsNamespace;
    private Properties persistedProperties;
    private DIHPropertiesWriter propWriter;
    private static final String PARAM_WRITER_IMPL = "writerImpl";
    private static final String DEFAULT_WRITER_NAME = "SolrWriter";
    private DebugLogger debugLogger;
    private DataImporter.RequestParams reqParams;
    ThreadPoolExecutor executorSvc = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private AtomicBoolean stop = new AtomicBoolean(false);
    public static final String TIME_ELAPSED = "Time Elapsed";
    public static final String LAST_INDEX_TIME = "last_index_time";
    public static final String INDEX_START_TIME = "index_start_time";

    public DocBuilder(DataImporter dataImporter, SolrWriter solrWriter, DIHPropertiesWriter propWriter, DataImporter.RequestParams reqParams) {
        INSTANCE.set(this);
        this.dataImporter = dataImporter;
        this.reqParams = reqParams;
        this.propWriter = propWriter;
        DataImporter.QUERY_COUNT.set(this.importStatistics.queryCount);
        this.requestParameters = reqParams;
        this.verboseDebug = this.requestParameters.debug && this.requestParameters.verbose;
        this.functionsNamespace = EvaluatorBag.getFunctionsNamespace(this.dataImporter.getConfig().functions, this);
        this.persistedProperties = propWriter.readIndexerProperties();
        String writerClassStr = null;
        if (reqParams != null && reqParams.requestParams != null) {
            writerClassStr = (String)reqParams.requestParams.get(PARAM_WRITER_IMPL);
        }
        if (writerClassStr != null && !writerClassStr.equals(DEFAULT_WRITER_NAME) && !writerClassStr.equals(DocBuilder.class.getPackage().getName() + "." + DEFAULT_WRITER_NAME)) {
            try {
                Class writerClass = DocBuilder.loadClass(writerClassStr, dataImporter.getCore());
                this.writer = (DIHWriter)writerClass.newInstance();
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Unable to load Writer implementation:" + writerClassStr, e);
            }
        } else {
            this.writer = solrWriter;
        }
        ContextImpl ctx = new ContextImpl(null, null, null, null, reqParams.requestParams, null, this);
        this.writer.init(ctx);
    }

    DebugLogger getDebugLogger() {
        if (this.debugLogger == null) {
            this.debugLogger = new DebugLogger();
        }
        return this.debugLogger;
    }

    public VariableResolverImpl getVariableResolver() {
        try {
            VariableResolverImpl resolver = null;
            resolver = this.dataImporter != null && this.dataImporter.getCore() != null && this.dataImporter.getCore().getResourceLoader().getCoreProperties() != null ? new VariableResolverImpl(this.dataImporter.getCore().getResourceLoader().getCoreProperties()) : new VariableResolverImpl();
            HashMap<String, Object> indexerNamespace = new HashMap<String, Object>();
            if (this.persistedProperties.getProperty(LAST_INDEX_TIME) != null) {
                indexerNamespace.put(LAST_INDEX_TIME, this.persistedProperties.getProperty(LAST_INDEX_TIME));
            } else {
                indexerNamespace.put(LAST_INDEX_TIME, DataImporter.DATE_TIME_FORMAT.get().format(EPOCH));
            }
            indexerNamespace.put(INDEX_START_TIME, this.dataImporter.getIndexStartTime());
            indexerNamespace.put("request", this.requestParameters.requestParams);
            indexerNamespace.put("functions", this.functionsNamespace);
            for (DataConfig.Entity entity : this.dataImporter.getConfig().document.entities) {
                String key = entity.name + "." + LAST_INDEX_TIME;
                String lastIndex = this.persistedProperties.getProperty(key);
                if (lastIndex != null) {
                    indexerNamespace.put(key, lastIndex);
                    continue;
                }
                indexerNamespace.put(key, DataImporter.DATE_TIME_FORMAT.get().format(EPOCH));
            }
            resolver.addNamespace("dih", indexerNamespace);
            resolver.addNamespace("dataimporter", indexerNamespace);
            return resolver;
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e);
            return null;
        }
    }

    private void invokeEventListener(String className) {
        try {
            EventListener listener = (EventListener)DocBuilder.loadClass(className, this.dataImporter.getCore()).newInstance();
            this.notifyListener(listener);
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Unable to load class : " + className);
        }
    }

    private void notifyListener(EventListener listener) {
        String currentProcess = this.dataImporter.getStatus() == DataImporter.Status.RUNNING_DELTA_DUMP ? "DELTA_DUMP" : "FULL_DUMP";
        listener.onEvent(new ContextImpl(null, this.getVariableResolver(), null, currentProcess, this.session, null, this));
    }

    public void execute() {
        try {
            this.dataImporter.store("status-messages", this.statusMessages);
            this.document = this.dataImporter.getConfig().document;
            final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());
            this.statusMessages.put(TIME_ELAPSED, new Object(){

                public String toString() {
                    return DocBuilder.getTimeElapsedSince(startTime.get());
                }
            });
            this.statusMessages.put("Total Requests made to DataSource", this.importStatistics.queryCount);
            this.statusMessages.put("Total Rows Fetched", this.importStatistics.rowsCount);
            this.statusMessages.put("Total Documents Processed", this.importStatistics.docCount);
            this.statusMessages.put("Total Documents Skipped", this.importStatistics.skipDocCount);
            List<String> entities = this.requestParameters.entities;
            if (this.document.onImportStart != null) {
                this.invokeEventListener(this.document.onImportStart);
            }
            AtomicBoolean fullCleanDone = new AtomicBoolean(false);
            Properties lastIndexTimeProps = new Properties();
            lastIndexTimeProps.setProperty(LAST_INDEX_TIME, DataImporter.DATE_TIME_FORMAT.get().format(this.dataImporter.getIndexStartTime()));
            for (DataConfig.Entity e : this.document.entities) {
                if (entities != null && !entities.contains(e.name)) continue;
                lastIndexTimeProps.setProperty(e.name + "." + LAST_INDEX_TIME, DataImporter.DATE_TIME_FORMAT.get().format(new Date()));
                this.root = e;
                String delQuery = e.allAttributes.get("preImportDeleteQuery");
                if (this.dataImporter.getStatus() == DataImporter.Status.RUNNING_DELTA_DUMP) {
                    this.cleanByQuery(delQuery, fullCleanDone);
                    this.doDelta();
                    delQuery = e.allAttributes.get("postImportDeleteQuery");
                    if (delQuery != null) {
                        fullCleanDone.set(false);
                        this.cleanByQuery(delQuery, fullCleanDone);
                    }
                } else {
                    this.cleanByQuery(delQuery, fullCleanDone);
                    this.doFullDump();
                    delQuery = e.allAttributes.get("postImportDeleteQuery");
                    if (delQuery != null) {
                        fullCleanDone.set(false);
                        this.cleanByQuery(delQuery, fullCleanDone);
                    }
                }
                this.statusMessages.remove("Total Documents Processed");
            }
            if (this.stop.get()) {
                this.statusMessages.put("Aborted", DataImporter.DATE_TIME_FORMAT.get().format(new Date()));
                this.rollback();
            } else {
                if (!this.requestParameters.clean) {
                    if (this.importStatistics.docCount.get() > 0L || this.importStatistics.deletedDocCount.get() > 0L) {
                        this.finish(lastIndexTimeProps);
                    }
                } else {
                    this.finish(lastIndexTimeProps);
                }
                if (this.document.onImportEnd != null) {
                    this.invokeEventListener(this.document.onImportEnd);
                }
            }
            this.statusMessages.remove(TIME_ELAPSED);
            this.statusMessages.put("Total Documents Processed", "" + this.importStatistics.docCount.get());
            if (this.importStatistics.failedDocCount.get() > 0L) {
                this.statusMessages.put("Total Documents Failed", "" + this.importStatistics.failedDocCount.get());
            }
            this.statusMessages.put("Time taken", DocBuilder.getTimeElapsedSince(startTime.get()));
            LOG.info("Time taken = " + DocBuilder.getTimeElapsedSince(startTime.get()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.requestParameters.debug) {
                this.requestParameters.debugVerboseOutput = this.getDebugLogger().output;
            }
        }
    }

    private void finish(Properties lastIndexTimeProps) {
        LOG.info("Import completed successfully");
        this.statusMessages.put("", "Indexing completed. Added/Updated: " + this.importStatistics.docCount + " documents. Deleted " + this.importStatistics.deletedDocCount + " documents.");
        if (this.requestParameters.commit) {
            this.writer.commit(this.requestParameters.optimize);
            this.addStatusMessage("Committed");
            if (this.requestParameters.optimize) {
                this.addStatusMessage("Optimized");
            }
        }
        try {
            this.propWriter.persist(lastIndexTimeProps);
        }
        catch (Exception e) {
            LOG.error("Could not write property file", (Throwable)e);
            this.statusMessages.put("error", "Could not write property file. Delta imports will not work. Make sure your conf directory is writable");
        }
    }

    void rollback() {
        this.writer.rollback();
        this.statusMessages.put("", "Indexing failed. Rolled back all changes.");
        this.addStatusMessage("Rolledback");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doFullDump() {
        this.addStatusMessage("Full Dump Started");
        if (this.dataImporter.getConfig().isMultiThreaded && !this.verboseDebug) {
            ArrayList<EntityRunner> closure2222;
            EntityRunner entityRunner = null;
            try {
                try {
                    LOG.info("running multithreaded full-import");
                    entityRunner = new EntityRunner(this.root, null, this.createProcessor(this.root));
                    entityRunner.run(null, "FULL_DUMP", null, 0);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error in multi-threaded import", e);
                }
                Object var4_2 = null;
                if (entityRunner == null) return;
                closure2222 = new ArrayList<EntityRunner>();
                closure2222.add(entityRunner);
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (entityRunner == null) throw throwable;
                ArrayList<EntityRunner> closure2222 = new ArrayList<EntityRunner>();
                closure2222.add(entityRunner);
                for (int i = 0; i < closure2222.size(); ++i) {
                    assert (!((EntityRunner)closure2222.get(i)).entityProcessorWrapper.isEmpty());
                    closure2222.addAll(((ThreadedEntityProcessorWrapper)((EntityRunner)((EntityRunner)closure2222.get((int)i))).entityProcessorWrapper.iterator().next()).children.values());
                }
                for (EntityRunner er : closure2222) {
                    er.entityProcessor.destroy();
                }
                throw throwable;
            }
            for (int i = 0; i < closure2222.size(); ++i) {
                assert (!((EntityRunner)closure2222.get(i)).entityProcessorWrapper.isEmpty());
                closure2222.addAll(((ThreadedEntityProcessorWrapper)((EntityRunner)((EntityRunner)closure2222.get((int)i))).entityProcessorWrapper.iterator().next()).children.values());
            }
            for (EntityRunner er : closure2222) {
                er.entityProcessor.destroy();
            }
            return;
        }
        this.buildDocument(this.getVariableResolver(), null, null, this.root, true, null);
    }

    private void doDelta() {
        this.addStatusMessage("Delta Dump started");
        VariableResolverImpl resolver = this.getVariableResolver();
        if (this.document.deleteQuery != null) {
            this.writer.deleteByQuery(this.document.deleteQuery);
        }
        this.addStatusMessage("Identifying Delta");
        LOG.info("Starting delta collection.");
        HashSet<Map<String, Object>> deletedKeys = new HashSet<Map<String, Object>>();
        Set<Map<String, Object>> allPks = this.collectDelta(this.root, resolver, deletedKeys);
        if (this.stop.get()) {
            return;
        }
        this.addStatusMessage("Deltas Obtained");
        this.addStatusMessage("Building documents");
        if (!deletedKeys.isEmpty()) {
            allPks.removeAll(deletedKeys);
            this.deleteAll(deletedKeys);
        }
        deletedKeys = null;
        this.writer.setDeltaKeys(allPks);
        this.statusMessages.put("Total Changed Documents", allPks.size());
        VariableResolverImpl vri = this.getVariableResolver();
        Iterator<Map<String, Object>> pkIter = allPks.iterator();
        while (pkIter.hasNext()) {
            Map<String, Object> map = pkIter.next();
            vri.addNamespace("dih.delta", map);
            this.buildDocument(vri, null, map, this.root, true, null);
            pkIter.remove();
            if (!this.stop.get()) continue;
            break;
        }
        if (!this.stop.get()) {
            LOG.info("Delta Import completed successfully");
        }
    }

    private void deleteAll(Set<Map<String, Object>> deletedKeys) {
        LOG.info("Deleting stale documents ");
        Iterator<Map<String, Object>> iter = deletedKeys.iterator();
        while (iter.hasNext()) {
            String keyName;
            Map<String, Object> map = iter.next();
            Object key = map.get(keyName = this.root.isDocRoot ? this.root.getPk() : this.root.getSchemaPk());
            if (key == null) {
                keyName = this.findMatchingPkColumn(keyName, map);
                key = map.get(keyName);
            }
            if (key == null) {
                LOG.warn("no key was available for deleted pk query. keyName = " + keyName);
                continue;
            }
            this.writer.deleteDoc(key);
            this.importStatistics.deletedDocCount.incrementAndGet();
            iter.remove();
        }
    }

    public void addStatusMessage(String msg) {
        this.statusMessages.put(msg, DataImporter.DATE_TIME_FORMAT.get().format(new Date()));
    }

    EntityRunner createRunner(DataConfig.Entity entity, EntityRunner parent, EntityProcessor processor) {
        return new EntityRunner(entity, parent, processor);
    }

    private void resetEntity(DataConfig.Entity entity) {
        entity.initalized = false;
        if (entity.entities != null) {
            for (DataConfig.Entity child : entity.entities) {
                this.resetEntity(child);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildDocument(VariableResolverImpl vr, DocWrapper doc, Map<String, Object> pk, DataConfig.Entity entity, boolean isRoot, ContextImpl parentCtx) {
        Iterator i$2;
        ArrayList<EntityProcessorWrapper> entitiesToDestroy = new ArrayList<EntityProcessorWrapper>();
        try {
            try {
                this.buildDocument(vr, doc, pk, entity, isRoot, parentCtx, entitiesToDestroy);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object var10_8 = null;
            i$2 = entitiesToDestroy.iterator();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Iterator i$2 = entitiesToDestroy.iterator();
            while (true) {
                if (!i$2.hasNext()) {
                    this.resetEntity(entity);
                    throw throwable;
                }
                EntityProcessorWrapper entityWrapper = (EntityProcessorWrapper)i$2.next();
                entityWrapper.destroy();
            }
        }
        while (i$2.hasNext()) {
            EntityProcessorWrapper entityWrapper = (EntityProcessorWrapper)i$2.next();
            entityWrapper.destroy();
        }
        this.resetEntity(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildDocument(VariableResolverImpl vr, DocWrapper doc, Map<String, Object> pk, DataConfig.Entity entity, boolean isRoot, ContextImpl parentCtx, List<EntityProcessorWrapper> entitiesToDestroy) {
        block42: {
            block48: {
                entityProcessor = this.getEntityProcessor(entity);
                ctx = new ContextImpl(entity, vr, null, pk == null ? "FULL_DUMP" : "DELTA_DUMP", this.session, parentCtx, this);
                entityProcessor.init(ctx);
                Context.CURRENT_CONTEXT.set(ctx);
                if (!entity.initalized) {
                    entitiesToDestroy.add(entityProcessor);
                    entity.initalized = true;
                }
                if (this.requestParameters.start > 0) {
                    this.getDebugLogger().log(DIHLogLevels.DISABLE_LOGGING, null, null);
                }
                if (this.verboseDebug) {
                    this.getDebugLogger().log(DIHLogLevels.START_ENTITY, entity.name, null);
                }
                seenDocCount = 0;
                try lbl-1000:
                // 3 sources

                {
                    block46: {
                        while (true) {
                            block47: {
                                block45: {
                                    block44: {
                                        block43: {
                                            if (this.stop.get()) {
                                                var17_18 = null;
                                                if (this.verboseDebug == false) return;
                                                this.getDebugLogger().log(DIHLogLevels.END_ENTITY, null, null);
                                                return;
                                            }
                                            if (this.importStatistics.docCount.get() > (long)this.requestParameters.start + this.requestParameters.rows) break block42;
                                            try {
                                                if (++seenDocCount > this.requestParameters.start) {
                                                    this.getDebugLogger().log(DIHLogLevels.ENABLE_LOGGING, null, null);
                                                }
                                                if (this.verboseDebug && entity.isDocRoot) {
                                                    this.getDebugLogger().log(DIHLogLevels.START_DOC, entity.name, null);
                                                }
                                                if (doc == null && entity.isDocRoot) {
                                                    doc = new DocWrapper();
                                                    ctx.setDoc(doc);
                                                    e = entity;
                                                    while (e.parentEntity != null) {
                                                        this.addFields(e.parentEntity, doc, (Map)vr.resolve(e.parentEntity.name), vr);
                                                        e = e.parentEntity;
                                                    }
                                                }
                                                if ((arow = entityProcessor.nextRow()) == null) {
                                                    var15_17 = null;
                                                    if (!this.verboseDebug) break block42;
                                                    break block43;
                                                }
                                                if (entity.isDocRoot) {
                                                    if (seenDocCount <= this.requestParameters.start) {
                                                        break block44;
                                                    }
                                                    if ((long)seenDocCount > (long)this.requestParameters.start + this.requestParameters.rows) {
                                                        DocBuilder.LOG.info("Indexing stopped at docCount = " + this.importStatistics.docCount);
                                                        break block45;
                                                    }
                                                }
                                                if (this.verboseDebug) {
                                                    this.getDebugLogger().log(DIHLogLevels.ENTITY_OUT, entity.name, arow);
                                                }
                                                this.importStatistics.rowsCount.incrementAndGet();
                                                if (doc != null) {
                                                    this.handleSpecialCommands(arow, doc);
                                                    this.addFields(entity, doc, arow, vr);
                                                }
                                                if (entity.entities != null) {
                                                    vr.addNamespace(entity.name, arow);
                                                    for (DataConfig.Entity child : entity.entities) {
                                                        this.buildDocument(vr, doc, child.isDocRoot != false ? pk : null, child, false, ctx, entitiesToDestroy);
                                                    }
                                                    vr.removeNamespace(entity.name);
                                                }
                                                Context.CURRENT_CONTEXT.set(ctx);
                                                if (!entity.isDocRoot) break block46;
                                                if (!this.stop.get()) break;
                                                break block47;
                                            }
                                            catch (DataImportHandlerException e) {
                                                if (this.verboseDebug) {
                                                    this.getDebugLogger().log(DIHLogLevels.ENTITY_EXCEPTION, entity.name, e);
                                                }
                                                if (e.getErrCode() == 301) {
                                                    var15_17 = null;
                                                    if (!this.verboseDebug) continue;
                                                    this.getDebugLogger().log(DIHLogLevels.ROW_END, entity.name, null);
                                                    if (entity.isDocRoot) {
                                                        this.getDebugLogger().log(DIHLogLevels.END_DOC, null, null);
                                                    }
                                                    Context.CURRENT_CONTEXT.remove();
                                                    continue;
                                                }
                                                if (isRoot == false) throw e;
                                                if (e.getErrCode() == 300) {
                                                    this.importStatistics.skipDocCount.getAndIncrement();
                                                    doc = null;
                                                } else {
                                                    SolrException.log((Logger)DocBuilder.LOG, (String)("Exception while processing: " + entity.name + " document : " + (Object)doc), (Throwable)e);
                                                }
                                                if (e.getErrCode() == 500) {
                                                    throw e;
                                                }
                                                var15_17 = null;
                                                if (!this.verboseDebug) continue;
                                                this.getDebugLogger().log(DIHLogLevels.ROW_END, entity.name, null);
                                                if (entity.isDocRoot) {
                                                    this.getDebugLogger().log(DIHLogLevels.END_DOC, null, null);
                                                }
                                                Context.CURRENT_CONTEXT.remove();
                                                continue;
                                            }
                                            catch (Throwable t) {
                                                if (this.verboseDebug == false) throw new DataImportHandlerException(500, t);
                                                this.getDebugLogger().log(DIHLogLevels.ENTITY_EXCEPTION, entity.name, t);
                                                throw new DataImportHandlerException(500, t);
                                            }
                                            catch (Throwable var14_22) {
                                                var15_17 = null;
                                                if (this.verboseDebug == false) throw var14_22;
                                                this.getDebugLogger().log(DIHLogLevels.ROW_END, entity.name, null);
                                                if (entity.isDocRoot) {
                                                    this.getDebugLogger().log(DIHLogLevels.END_DOC, null, null);
                                                }
                                                Context.CURRENT_CONTEXT.remove();
                                                throw var14_22;
                                            }
                                        }
                                        this.getDebugLogger().log(DIHLogLevels.ROW_END, entity.name, null);
                                        if (entity.isDocRoot) {
                                            this.getDebugLogger().log(DIHLogLevels.END_DOC, null, null);
                                        }
                                        Context.CURRENT_CONTEXT.remove();
                                        break block42;
                                    }
                                    var15_17 = null;
                                    if (!this.verboseDebug) continue;
                                    this.getDebugLogger().log(DIHLogLevels.ROW_END, entity.name, null);
                                    if (entity.isDocRoot) {
                                        this.getDebugLogger().log(DIHLogLevels.END_DOC, null, null);
                                    }
                                    Context.CURRENT_CONTEXT.remove();
                                    continue;
                                }
                                var15_17 = null;
                                if (this.verboseDebug) {
                                    this.getDebugLogger().log(DIHLogLevels.ROW_END, entity.name, null);
                                    if (entity.isDocRoot) {
                                        this.getDebugLogger().log(DIHLogLevels.END_DOC, null, null);
                                    }
                                    Context.CURRENT_CONTEXT.remove();
                                }
                                break block42;
                            }
                            var15_17 = null;
                            if (!this.verboseDebug) break block48;
                            this.getDebugLogger().log(DIHLogLevels.ROW_END, entity.name, null);
                            if (entity.isDocRoot) {
                                this.getDebugLogger().log(DIHLogLevels.END_DOC, null, null);
                            }
                            Context.CURRENT_CONTEXT.remove();
                            break block48;
                            break;
                        }
                        {
                            if (doc.isEmpty()) break block46;
                            result = this.writer.upload(doc);
                            if (this.reqParams.debug) {
                                this.reqParams.debugDocuments.add(doc);
                            }
                            doc = null;
                            if (result) {
                                this.importStatistics.docCount.incrementAndGet();
                                break block46;
                            }
                            this.importStatistics.failedDocCount.incrementAndGet();
                        }
                    }
                    var15_17 = null;
                    if (!this.verboseDebug) ** GOTO lbl-1000
                    this.getDebugLogger().log(DIHLogLevels.ROW_END, entity.name, null);
                    if (entity.isDocRoot) {
                        this.getDebugLogger().log(DIHLogLevels.END_DOC, null, null);
                    }
                    Context.CURRENT_CONTEXT.remove();
                    ** continue;
                }
                catch (Throwable var16_23) {
                    var17_21 = null;
                    if (this.verboseDebug == false) throw var16_23;
                    this.getDebugLogger().log(DIHLogLevels.END_ENTITY, null, null);
                    throw var16_23;
                }
            }
            var17_19 = null;
            if (this.verboseDebug == false) return;
            this.getDebugLogger().log(DIHLogLevels.END_ENTITY, null, null);
            return;
        }
        var17_20 = null;
        if (this.verboseDebug == false) return;
        this.getDebugLogger().log(DIHLogLevels.END_ENTITY, null, null);
    }

    private void handleSpecialCommands(Map<String, Object> arow, DocWrapper doc) {
        Collection collection;
        Object value = arow.get("$deleteDocById");
        if (value != null) {
            if (value instanceof Collection) {
                collection = (Collection)value;
                for (Object o : collection) {
                    this.writer.deleteDoc(o.toString());
                    this.importStatistics.deletedDocCount.incrementAndGet();
                }
            } else {
                this.writer.deleteDoc(value);
                this.importStatistics.deletedDocCount.incrementAndGet();
            }
        }
        if ((value = arow.get("$deleteDocByQuery")) != null) {
            if (value instanceof Collection) {
                collection = (Collection)value;
                for (Object o : collection) {
                    this.writer.deleteByQuery(o.toString());
                    this.importStatistics.deletedDocCount.incrementAndGet();
                }
            } else {
                this.writer.deleteByQuery(value.toString());
                this.importStatistics.deletedDocCount.incrementAndGet();
            }
        }
        if ((value = arow.get("$docBoost")) != null) {
            float value1 = 1.0f;
            value1 = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
            doc.setDocumentBoost(value1);
        }
        if ((value = arow.get("$skipDoc")) != null && Boolean.parseBoolean(value.toString())) {
            throw new DataImportHandlerException(300, "Document skipped :" + arow);
        }
        value = arow.get("$skipRow");
        if (value != null && Boolean.parseBoolean(value.toString())) {
            throw new DataImportHandlerException(301);
        }
    }

    private void addFields(DataConfig.Entity entity, DocWrapper doc, Map<String, Object> arow, VariableResolver vr) {
        for (Map.Entry<String, Object> entry : arow.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || key.startsWith("$")) continue;
            List<DataConfig.Field> field = entity.colNameVsField.get(key);
            if (field == null && this.dataImporter.getSchema() != null) {
                SchemaField sf = this.dataImporter.getSchema().getFieldOrNull(key);
                if (sf == null) {
                    sf = this.dataImporter.getConfig().lowerNameVsSchemaField.get(key.toLowerCase(Locale.ENGLISH));
                }
                if (sf == null) continue;
                this.addFieldToDoc(entry.getValue(), sf.getName(), 1.0f, sf.multiValued(), doc);
                continue;
            }
            if (field == null) continue;
            for (DataConfig.Field f : field) {
                String name = f.getName();
                if (f.dynamicName) {
                    name = vr.replaceTokens(name);
                }
                if (!f.toWrite) continue;
                this.addFieldToDoc(entry.getValue(), name, f.boost.floatValue(), f.multiValued, doc);
            }
        }
    }

    private void addFieldToDoc(Object value, String name, float boost, boolean multiValued, DocWrapper doc) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (multiValued) {
                for (Object o : collection) {
                    if (o == null) continue;
                    doc.addField(name, o, boost);
                }
            } else if (doc.getField(name) == null) {
                for (Object o : collection) {
                    if (o == null) continue;
                    doc.addField(name, o, boost);
                    break;
                }
            }
        } else if (multiValued) {
            if (value != null) {
                doc.addField(name, value, boost);
            }
        } else if (doc.getField(name) == null && value != null) {
            doc.addField(name, value, boost);
        }
    }

    private EntityProcessorWrapper getEntityProcessor(DataConfig.Entity entity) {
        if (entity.processor != null) {
            return entity.processor;
        }
        EntityProcessor entityProcessor = null;
        if (entity.proc == null) {
            entityProcessor = new SqlEntityProcessor();
        } else {
            try {
                entityProcessor = (EntityProcessor)DocBuilder.loadClass(entity.proc, this.dataImporter.getCore()).newInstance();
            }
            catch (Exception e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Unable to load EntityProcessor implementation for entity:" + entity.name);
            }
        }
        entity.processor = new EntityProcessorWrapper(entityProcessor, this);
        return entity.processor;
    }

    private String findMatchingPkColumn(String pk, Map<String, Object> row) {
        if (row.containsKey(pk)) {
            throw new IllegalArgumentException(String.format("deltaQuery returned a row with null for primary key %s", pk));
        }
        String resolvedPk = null;
        for (String columnName : row.keySet()) {
            if (!columnName.endsWith("." + pk) && !pk.endsWith("." + columnName)) continue;
            if (resolvedPk != null) {
                throw new IllegalArgumentException(String.format("deltaQuery has more than one column (%s and %s) that might resolve to declared primary key pk='%s'", resolvedPk, columnName, pk));
            }
            resolvedPk = columnName;
        }
        if (resolvedPk == null) {
            throw new IllegalArgumentException(String.format("deltaQuery has no column to resolve to declared primary key pk='%s'", pk));
        }
        LOG.info(String.format("Resolving deltaQuery column '%s' to match entity's declared pk '%s'", resolvedPk, pk));
        return resolvedPk;
    }

    public Set<Map<String, Object>> collectDelta(DataConfig.Entity entity, VariableResolverImpl resolver, Set<Map<String, Object>> deletedRows) {
        Map<String, Object> row;
        Map<String, Object> row2;
        if (this.stop.get()) {
            return new HashSet<Map<String, Object>>();
        }
        EntityProcessorWrapper entityProcessor = this.getEntityProcessor(entity);
        ContextImpl context1 = new ContextImpl(entity, resolver, null, "FIND_DELTA", this.session, null, this);
        ((EntityProcessor)entityProcessor).init(context1);
        HashSet<Map<String, Object>> myModifiedPks = new HashSet<Map<String, Object>>();
        if (entity.entities != null) {
            for (DataConfig.Entity entity1 : entity.entities) {
                myModifiedPks.addAll(this.collectDelta(entity1, resolver, deletedRows));
                if (!this.stop.get()) continue;
                return new HashSet<Map<String, Object>>();
            }
        }
        HashMap<String, Map<String, Object>> deltaSet = new HashMap<String, Map<String, Object>>();
        LOG.info("Running ModifiedRowKey() for Entity: " + entity.name);
        String pk = entity.getPk();
        while ((row2 = ((EntityProcessor)entityProcessor).nextModifiedRowKey()) != null) {
            Object pkValue = row2.get(pk);
            if (pkValue == null) {
                pk = this.findMatchingPkColumn(pk, row2);
                pkValue = row2.get(pk);
            }
            deltaSet.put(pkValue.toString(), row2);
            this.importStatistics.rowsCount.incrementAndGet();
            if (!this.stop.get()) continue;
            return new HashSet<Map<String, Object>>();
        }
        ((EntityProcessor)entityProcessor).init(context1);
        HashSet<Map<String, Object>> deletedSet = new HashSet<Map<String, Object>>();
        while ((row = ((EntityProcessor)entityProcessor).nextDeletedRowKey()) != null) {
            String string;
            deletedSet.add(row);
            Object pkValue = row.get(pk);
            if (pkValue == null) {
                pk = this.findMatchingPkColumn(pk, row);
                pkValue = row.get(pk);
            }
            if (deltaSet.containsKey(string = pkValue.toString())) {
                deltaSet.remove(string);
            }
            this.importStatistics.rowsCount.incrementAndGet();
            if (!this.stop.get()) continue;
            return new HashSet<Map<String, Object>>();
        }
        LOG.info("Completed ModifiedRowKey for Entity: " + entity.name + " rows obtained : " + deltaSet.size());
        LOG.info("Completed DeletedRowKey for Entity: " + entity.name + " rows obtained : " + deletedSet.size());
        myModifiedPks.addAll(deltaSet.values());
        HashSet<Map<String, Object>> parentKeyList = new HashSet<Map<String, Object>>();
        if (entity.parentEntity != null) {
            ((EntityProcessor)entityProcessor).init(context1);
            for (Map map : myModifiedPks) {
                this.getModifiedParentRows(resolver.addNamespace(entity.name, map), entity.name, entityProcessor, parentKeyList);
                if (!this.stop.get()) continue;
                return new HashSet<Map<String, Object>>();
            }
            ((EntityProcessor)entityProcessor).init(context1);
            for (Map map : deletedSet) {
                this.getModifiedParentRows(resolver.addNamespace(entity.name, map), entity.name, entityProcessor, parentKeyList);
                if (!this.stop.get()) continue;
                return new HashSet<Map<String, Object>>();
            }
        }
        LOG.info("Completed parentDeltaQuery for Entity: " + entity.name);
        if (entity.isDocRoot) {
            deletedRows.addAll(deletedSet);
        }
        return entity.parentEntity == null ? myModifiedPks : new HashSet<Map<String, Object>>(parentKeyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getModifiedParentRows(VariableResolverImpl resolver, String entity, EntityProcessor entityProcessor, Set<Map<String, Object>> parentKeyList) {
        try {
            Map<String, Object> parentRow;
            while ((parentRow = entityProcessor.nextModifiedParentRowKey()) != null) {
                parentKeyList.add(parentRow);
                this.importStatistics.rowsCount.incrementAndGet();
                if (!this.stop.get()) continue;
                Object var7_6 = null;
                resolver.removeNamespace(entity);
                return;
            }
            Object var7_7 = null;
            resolver.removeNamespace(entity);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            resolver.removeNamespace(entity);
            throw throwable;
        }
    }

    public void abort() {
        this.stop.set(true);
    }

    static String getTimeElapsedSince(long l) {
        l = System.currentTimeMillis() - l;
        return l / 3600000L + ":" + l / 60000L % 60L + ":" + l / 1000L % 60L + "." + l % 1000L;
    }

    static Class loadClass(String name, SolrCore core) throws ClassNotFoundException {
        try {
            return core != null ? core.getResourceLoader().findClass(name, new String[0]) : Class.forName(name);
        }
        catch (Exception e) {
            try {
                String n = DocBuilder.class.getPackage().getName() + "." + name;
                return core != null ? core.getResourceLoader().findClass(n, new String[0]) : Class.forName(n);
            }
            catch (Exception e1) {
                throw new ClassNotFoundException("Unable to load " + name + " or " + DocBuilder.class.getPackage().getName() + "." + name, e);
            }
        }
    }

    private void cleanByQuery(String delQuery, AtomicBoolean completeCleanDone) {
        delQuery = this.getVariableResolver().replaceTokens(delQuery);
        if (this.requestParameters.clean) {
            if (delQuery == null && !completeCleanDone.get()) {
                this.writer.doDeleteAll();
                completeCleanDone.set(true);
            } else if (delQuery != null) {
                this.writer.deleteByQuery(delQuery);
            }
        }
    }

    protected EntityProcessor createProcessor(DataConfig.Entity entity) {
        EntityProcessor processor = null;
        if (entity.proc == null) {
            processor = new SqlEntityProcessor();
        } else {
            try {
                processor = (EntityProcessor)DocBuilder.loadClass(entity.proc, this.dataImporter.getCore()).newInstance();
            }
            catch (Exception e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Unable to load EntityProcessor implementation for entity:" + entity.name);
            }
        }
        return processor;
    }

    public void destroy() {
        this.executorSvc.shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Statistics {
        public AtomicLong docCount = new AtomicLong();
        public AtomicLong deletedDocCount = new AtomicLong();
        public AtomicLong failedDocCount = new AtomicLong();
        public AtomicLong rowsCount = new AtomicLong();
        public AtomicLong queryCount = new AtomicLong();
        public AtomicLong skipDocCount = new AtomicLong();

        public Statistics add(Statistics stats) {
            this.docCount.addAndGet(stats.docCount.get());
            this.deletedDocCount.addAndGet(stats.deletedDocCount.get());
            this.rowsCount.addAndGet(stats.rowsCount.get());
            this.queryCount.addAndGet(stats.queryCount.get());
            return this;
        }

        public Map<String, Object> getStatsSnapshot() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("docCount", this.docCount.get());
            result.put("deletedDocCount", this.deletedDocCount.get());
            result.put("rowCount", this.rowsCount.get());
            result.put("queryCount", this.rowsCount.get());
            result.put("skipDocCount", this.skipDocCount.get());
            return result;
        }
    }

    static class DocWrapper
    extends SolrInputDocument {
        Map<String, Object> session;

        DocWrapper() {
        }

        public void setSessionAttribute(String key, Object val) {
            if (this.session == null) {
                this.session = new HashMap<String, Object>();
            }
            this.session.put(key, val);
        }

        public Object getSessionAttribute(String key) {
            return this.session == null ? null : this.session.get(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntityRow {
        final Map<String, Object> row;
        final EntityRow tail;
        final String name;

        EntityRow(Map<String, Object> row, EntityRow tail, String name) {
            this.row = row;
            this.tail = tail;
            this.name = name;
        }
    }

    class EntityRunner {
        final DataConfig.Entity entity;
        private EntityProcessor entityProcessor;
        private final List<ThreadedEntityProcessorWrapper> entityProcessorWrapper = new ArrayList<ThreadedEntityProcessorWrapper>();
        private volatile boolean entityInitialized;
        String currentProcess;
        final ThreadLocal<ThreadedEntityProcessorWrapper> currentEntityProcWrapper = new ThreadLocal();
        private ContextImpl context;
        final EntityRunner parent;
        private Exception exception;

        public EntityRunner(DataConfig.Entity entity, EntityRunner parent, EntityProcessor processor) {
            this.parent = parent;
            this.entity = entity;
            this.entityProcessor = processor;
            int threads = 1;
            String rootEntityThreads = ((DocBuilder)DocBuilder.this).root.allAttributes.get("threads");
            if (rootEntityThreads != null) {
                threads = Integer.parseInt(rootEntityThreads);
            }
            List<Object> childrenEntities = entity.entities == null ? Collections.emptyList() : entity.entities;
            LinkedHashMap<DataConfig.Entity, EntityRunner> childrenRunners = new LinkedHashMap<DataConfig.Entity, EntityRunner>(childrenEntities.size());
            for (DataConfig.Entity entity2 : childrenEntities) {
                childrenRunners.put(entity2, DocBuilder.this.createRunner(entity2, this, DocBuilder.this.createProcessor(entity2)));
            }
            for (int i = 0; i < threads; ++i) {
                ThreadedEntityProcessorWrapper threadedEntityProcessorWrapper = new ThreadedEntityProcessorWrapper(this.entityProcessor, DocBuilder.this, this, DocBuilder.this.getVariableResolver(), childrenRunners, i);
                this.entityProcessorWrapper.add(threadedEntityProcessorWrapper);
            }
            this.context = new ThreadedContext(this, DocBuilder.this, DocBuilder.this.getVariableResolver());
        }

        public void run(final DocWrapper docWrapper, final String currProcess, final EntityRow rows, int threadedWrapperNumber) throws Exception {
            boolean singleWrapperOnly;
            this.entityInitialized = false;
            this.currentProcess = currProcess;
            boolean bl = singleWrapperOnly = this.entityProcessorWrapper.size() == 1;
            if (singleWrapperOnly || !this.entity.isDocRoot) {
                ThreadedEntityProcessorWrapper currentWrapper = this.entityProcessorWrapper.get(threadedWrapperNumber);
                this.runAThread(currentWrapper, docWrapper, rows, currProcess);
            } else {
                final CountDownLatch latch = new CountDownLatch(this.entityProcessorWrapper.size());
                for (final ThreadedEntityProcessorWrapper processorWrapper : this.entityProcessorWrapper) {
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                EntityRunner.this.runAThread(processorWrapper, docWrapper, rows, currProcess);
                            }
                            catch (Exception e) {
                                EntityRunner.this.exception = e;
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    };
                    DocBuilder.this.executorSvc.execute(runnable);
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                Exception copy = this.exception;
                if (copy != null) {
                    this.exception = null;
                    throw copy;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void runAThread(ThreadedEntityProcessorWrapper epw, DocWrapper parentDocWrapper, EntityRow rows, String currProcess) throws Exception {
            this.currentEntityProcWrapper.set(epw);
            epw.threadedInit(this.context);
            try {
                Context.CURRENT_CONTEXT.set(this.context);
                epw.init(rows);
                DocWrapper docWrapper = parentDocWrapper;
                while (true) {
                    if (DocBuilder.this.stop.get()) {
                        return;
                    }
                    try {
                        Map<String, Object> arow = epw.nextRow();
                        if (arow == null) {
                            return;
                        }
                        DocBuilder.this.importStatistics.rowsCount.incrementAndGet();
                        if (docWrapper == null && this.entity.isDocRoot) {
                            docWrapper = new DocWrapper();
                            this.context.setDoc(docWrapper);
                            DataConfig.Entity e = this.entity.parentEntity;
                            EntityRow row = rows;
                            while (row != null && e != null) {
                                DocBuilder.this.addFields(e, docWrapper, row.row, epw.resolver);
                                row = row.tail;
                                e = e.parentEntity;
                            }
                        }
                        if (docWrapper != null) {
                            DocBuilder.this.handleSpecialCommands(arow, docWrapper);
                            DocBuilder.this.addFields(this.entity, docWrapper, arow, epw.resolver);
                        }
                        if (this.entity.entities != null) {
                            EntityRow nextRow = new EntityRow(arow, rows, this.entity.name);
                            for (DataConfig.Entity e : this.entity.entities) {
                                epw.children.get(e).run(docWrapper, currProcess, nextRow, epw.getNumber());
                            }
                        }
                        if (!this.entity.isDocRoot) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("a row on docroot" + (Object)((Object)docWrapper));
                        }
                        if (docWrapper.isEmpty()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("adding a doc " + (Object)((Object)docWrapper));
                        }
                        boolean result = DocBuilder.this.writer.upload(docWrapper);
                        if (((DocBuilder)DocBuilder.this).reqParams.debug) {
                            ((DocBuilder)DocBuilder.this).reqParams.debugDocuments.add(docWrapper);
                        }
                        docWrapper = null;
                        if (result) {
                            DocBuilder.this.importStatistics.docCount.incrementAndGet();
                            continue;
                        }
                        DocBuilder.this.importStatistics.failedDocCount.incrementAndGet();
                        continue;
                    }
                    catch (DataImportHandlerException dihe) {
                        this.exception = dihe;
                        if (dihe.getErrCode() == 301 || dihe.getErrCode() == 300) {
                            DocBuilder.this.importStatistics.skipDocCount.getAndIncrement();
                            this.exception = null;
                            continue;
                        }
                        if (!this.entity.isDocRoot) throw dihe;
                        if (dihe.getErrCode() == 300) {
                            DocBuilder.this.importStatistics.skipDocCount.getAndIncrement();
                            this.exception = null;
                        } else {
                            SolrException.log((Logger)LOG, (String)("Exception while processing: " + this.entity.name + " document : " + (Object)((Object)docWrapper)), (Throwable)dihe);
                        }
                        if (dihe.getErrCode() == 500) throw dihe;
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException r) {
                throw r;
            }
            finally {
                this.currentEntityProcWrapper.remove();
                Context.CURRENT_CONTEXT.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initEntity() {
            if (!this.entityInitialized) {
                EntityRunner entityRunner = this;
                synchronized (entityRunner) {
                    if (!this.entityInitialized) {
                        this.entityProcessor.init(this.context);
                        this.entityInitialized = true;
                    }
                }
            }
        }
    }
}

