/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.util.Properties;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.FieldReaderDataSource;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldStreamDataSource
extends DataSource<InputStream> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldReaderDataSource.class);
    protected VariableResolver vr;
    protected String dataField;
    private EntityProcessorWrapper wrapper;

    @Override
    public void init(Context context, Properties initProps) {
        this.dataField = context.getEntityAttribute("dataField");
        this.wrapper = (EntityProcessorWrapper)context.getEntityProcessor();
    }

    @Override
    public InputStream getData(String query) {
        Object o = this.wrapper.getVariableResolver().resolve(this.dataField);
        if (o == null) {
            throw new DataImportHandlerException(500, "No field available for name : " + this.dataField);
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            try {
                Method m = blob.getClass().getDeclaredMethod("getBinaryStream", new Class[0]);
                if (Modifier.isPublic(m.getModifiers())) {
                    return (InputStream)m.invoke((Object)blob, new Object[0]);
                }
                m.setAccessible(true);
                return (InputStream)m.invoke((Object)blob, new Object[0]);
            }
            catch (Exception e) {
                LOG.info("Unable to get data from BLOB");
                return null;
            }
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            return new ByteArrayInputStream(bytes);
        }
        throw new RuntimeException("unsupported type : " + o.getClass());
    }

    @Override
    public void close() {
    }
}

