/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.EntityProcessorBase;

public class LineEntityProcessor
extends EntityProcessorBase {
    private Pattern acceptLineRegex;
    private Pattern skipLineRegex;
    private String url;
    private BufferedReader reader;
    public static final String URL = "url";
    public static final String ACCEPT_LINE_REGEX = "acceptLineRegex";
    public static final String SKIP_LINE_REGEX = "skipLineRegex";

    @Override
    public void init(Context context) {
        super.init(context);
        String s = context.getResolvedEntityAttribute(ACCEPT_LINE_REGEX);
        if (s != null) {
            this.acceptLineRegex = Pattern.compile(s);
        }
        if ((s = context.getResolvedEntityAttribute(SKIP_LINE_REGEX)) != null) {
            this.skipLineRegex = Pattern.compile(s);
        }
        this.url = context.getResolvedEntityAttribute(URL);
        if (this.url == null) {
            throw new DataImportHandlerException(500, "'url' is a required attribute");
        }
    }

    @Override
    public Map<String, Object> nextRow() {
        String line;
        if (this.reader == null) {
            this.reader = new BufferedReader((Reader)this.context.getDataSource().getData(this.url));
        }
        do {
            try {
                line = this.reader.readLine();
            }
            catch (IOException exp) {
                throw new DataImportHandlerException(500, "Problem reading from input", exp);
            }
            if (line != null) continue;
            return null;
        } while (this.acceptLineRegex != null && !this.acceptLineRegex.matcher(line).find() || this.skipLineRegex != null && this.skipLineRegex.matcher(line).find());
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("rawLine", line);
        return row;
    }

    @Override
    public void destroy() {
        if (this.reader != null) {
            IOUtils.closeQuietly((Reader)this.reader);
        }
        this.reader = null;
        super.destroy();
    }
}

