/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataSource
extends DataSource<Reader> {
    public static final String BASE_PATH = "basePath";
    protected String basePath;
    protected String encoding = null;
    private static final Logger LOG = LoggerFactory.getLogger(FileDataSource.class);

    @Override
    public void init(Context context, Properties initProps) {
        this.basePath = initProps.getProperty(BASE_PATH);
        if (initProps.get("encoding") != null) {
            this.encoding = initProps.getProperty("encoding");
        }
    }

    @Override
    public Reader getData(String query) {
        File f = FileDataSource.getFile(this.basePath, query);
        try {
            return this.openStream(f);
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Unable to open File : " + f.getAbsolutePath());
            return null;
        }
    }

    static File getFile(String basePath, String query) {
        try {
            File file0;
            File file = file0 = new File(query);
            if (!file.isAbsolute()) {
                file = new File(basePath + query);
            }
            if (file.isFile() && file.canRead()) {
                LOG.debug("Accessing File: " + file.toString());
                return file;
            }
            if (file != file0 && file0.isFile() && file0.canRead()) {
                LOG.debug("Accessing File0: " + file0.toString());
                return file0;
            }
            throw new FileNotFoundException("Could not find file: " + query);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Reader openStream(File file) throws FileNotFoundException, UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(new FileInputStream(file));
        }
        return new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
    }

    @Override
    public void close() {
    }
}

