/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.config.Script;

public class ContextImpl
extends Context {
    protected EntityProcessorWrapper epw;
    private ContextImpl parent;
    private VariableResolver resolver;
    private DataSource ds;
    private String currProcess;
    private Map<String, Object> requestParams;
    private DataImporter dataImporter;
    private Map<String, Object> entitySession;
    private Map<String, Object> globalSession;
    DocBuilder.DocWrapper doc;
    DocBuilder docBuilder;
    Exception lastException = null;

    public ContextImpl(EntityProcessorWrapper epw, VariableResolver resolver, DataSource ds, String currProcess, Map<String, Object> global, ContextImpl parentContext, DocBuilder docBuilder) {
        this.epw = epw;
        this.docBuilder = docBuilder;
        this.resolver = resolver;
        this.ds = ds;
        this.currProcess = currProcess;
        if (docBuilder != null) {
            this.requestParams = docBuilder.getReqParams().getRawParams();
            this.dataImporter = docBuilder.dataImporter;
        }
        this.globalSession = global;
        this.parent = parentContext;
    }

    @Override
    public String getEntityAttribute(String name) {
        return this.epw == null || this.epw.getEntity() == null ? null : this.epw.getEntity().getAllAttributes().get(name);
    }

    @Override
    public String getResolvedEntityAttribute(String name) {
        return this.epw == null || this.epw.getEntity() == null ? null : this.resolver.replaceTokens(this.epw.getEntity().getAllAttributes().get(name));
    }

    @Override
    public List<Map<String, String>> getAllEntityFields() {
        return this.epw == null || this.epw.getEntity() == null ? Collections.EMPTY_LIST : this.epw.getEntity().getAllFieldsList();
    }

    @Override
    public VariableResolver getVariableResolver() {
        return this.resolver;
    }

    @Override
    public DataSource getDataSource() {
        if (this.ds != null) {
            return this.ds;
        }
        if (this.epw == null) {
            return null;
        }
        if (this.epw != null && this.epw.getDatasource() == null) {
            this.epw.setDatasource(this.dataImporter.getDataSourceInstance(this.epw.getEntity(), this.epw.getEntity().getDataSourceName(), this));
        }
        if (this.epw != null && this.epw.getDatasource() != null && this.docBuilder != null && this.docBuilder.verboseDebug && "FULL_DUMP".equals(this.currentProcess())) {
            this.epw.setDatasource(this.docBuilder.getDebugLogger().wrapDs(this.epw.getDatasource()));
        }
        return this.epw.getDatasource();
    }

    @Override
    public DataSource getDataSource(String name) {
        return this.dataImporter.getDataSourceInstance(this.epw == null ? null : this.epw.getEntity(), name, this);
    }

    @Override
    public boolean isRootEntity() {
        return this.epw == null ? false : this.epw.getEntity().isDocRoot();
    }

    @Override
    public String currentProcess() {
        return this.currProcess;
    }

    @Override
    public Map<String, Object> getRequestParameters() {
        return this.requestParams;
    }

    @Override
    public EntityProcessor getEntityProcessor() {
        return this.epw;
    }

    @Override
    public void setSessionAttribute(String name, Object val, String scope) {
        if (name == null) {
            return;
        }
        if ("entity".equals(scope)) {
            if (this.entitySession == null) {
                this.entitySession = new HashMap<String, Object>();
            }
            this.entitySession.put(name, val);
        } else if ("global".equals(scope)) {
            if (this.globalSession != null) {
                this.globalSession.put(name, val);
            }
        } else if ("document".equals(scope)) {
            DocBuilder.DocWrapper doc = this.getDocument();
            if (doc != null) {
                doc.setSessionAttribute(name, val);
            }
        } else if ("solrcore".equals(scope) && this.dataImporter != null) {
            this.dataImporter.putToCoreScopeSession(name, val);
        }
    }

    @Override
    public Object getSessionAttribute(String name, String scope) {
        if ("entity".equals(scope)) {
            if (this.entitySession == null) {
                return null;
            }
            return this.entitySession.get(name);
        }
        if ("global".equals(scope)) {
            if (this.globalSession != null) {
                return this.globalSession.get(name);
            }
        } else {
            if ("document".equals(scope)) {
                DocBuilder.DocWrapper doc = this.getDocument();
                return doc == null ? null : doc.getSessionAttribute(name);
            }
            if ("solrcore".equals(scope)) {
                return this.dataImporter == null ? null : this.dataImporter.getFromCoreScopeSession(name);
            }
        }
        return null;
    }

    @Override
    public Context getParentContext() {
        return this.parent;
    }

    private DocBuilder.DocWrapper getDocument() {
        ContextImpl c = this;
        while (true) {
            if (c.doc != null) {
                return c.doc;
            }
            if (c.parent == null) break;
            c = c.parent;
        }
        return null;
    }

    void setDoc(DocBuilder.DocWrapper docWrapper) {
        this.doc = docWrapper;
    }

    @Override
    public SolrCore getSolrCore() {
        return this.dataImporter == null ? null : this.dataImporter.getCore();
    }

    @Override
    public Map<String, Object> getStats() {
        return this.docBuilder != null ? this.docBuilder.importStatistics.getStatsSnapshot() : Collections.emptyMap();
    }

    @Override
    public String getScript() {
        if (this.dataImporter != null) {
            Script script = this.dataImporter.getConfig().getScript();
            return script == null ? null : script.getText();
        }
        return null;
    }

    @Override
    public String getScriptLanguage() {
        if (this.dataImporter != null) {
            Script script = this.dataImporter.getConfig().getScript();
            return script == null ? null : script.getLanguage();
        }
        return null;
    }

    @Override
    public void deleteDoc(String id) {
        if (this.docBuilder != null) {
            this.docBuilder.writer.deleteDoc(id);
        }
    }

    @Override
    public void deleteDocByQuery(String query) {
        if (this.docBuilder != null) {
            this.docBuilder.writer.deleteByQuery(query);
        }
    }

    DocBuilder getDocBuilder() {
        return this.docBuilder;
    }

    @Override
    public Object resolve(String var) {
        return this.resolver.resolve(var);
    }

    @Override
    public String replaceTokens(String template) {
        return this.resolver.replaceTokens(template);
    }
}

