/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.RequestInfo;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImportHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger LOG = LoggerFactory.getLogger(DataImportHandler.class);
    private DataImporter importer;
    private boolean debugEnabled = true;
    private String myName = "dataimport";
    public static final String ENABLE_DEBUG = "enableDebug";

    public void init(NamedList args) {
        super.init(args);
    }

    public void inform(SolrCore core) {
        try {
            for (Map.Entry e : core.getRequestHandlers().entrySet()) {
                SolrRequestHandler handler = (SolrRequestHandler)e.getValue();
                if (this != handler) continue;
                String name = (String)e.getKey();
                if (name.startsWith("/")) {
                    this.myName = name.substring(1);
                }
                this.myName = this.myName.replaceAll("/", "_");
            }
            this.debugEnabled = StrUtils.parseBool((String)((String)this.initArgs.get(ENABLE_DEBUG)), (boolean)true);
            this.importer = new DataImporter(core, this.myName);
        }
        catch (Throwable e) {
            LOG.error("Exception while loading DataImporter", e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception while loading DataImporter", e);
        }
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Iterator i$;
        rsp.setHttpCaching(false);
        ContentStream contentStream = null;
        Iterable streams = req.getContentStreams();
        if (streams != null && (i$ = streams.iterator()).hasNext()) {
            ContentStream stream;
            contentStream = stream = (ContentStream)i$.next();
        }
        SolrParams params = req.getParams();
        NamedList defaultParams = (NamedList)this.initArgs.get("defaults");
        RequestInfo requestParams = new RequestInfo(req, this.getParamsMap(params), contentStream);
        String command = requestParams.getCommand();
        if ("show-config".equals(command)) {
            String dataConfigFile = params.get("config");
            String dataConfig = params.get("dataConfig");
            if (dataConfigFile != null) {
                dataConfig = SolrWriter.getResourceAsString(req.getCore().getResourceLoader().openResource(dataConfigFile));
            }
            if (dataConfig == null) {
                rsp.add("status", (Object)"Configuration not found");
            } else {
                ModifiableSolrParams rawParams = new ModifiableSolrParams(req.getParams());
                rawParams.set("wt", new String[]{"raw"});
                req.setParams((SolrParams)rawParams);
                ContentStreamBase.StringStream content = new ContentStreamBase.StringStream(dataConfig);
                rsp.add("content", (Object)content);
            }
            return;
        }
        rsp.add("initArgs", (Object)this.initArgs);
        String message = "";
        if (command != null) {
            rsp.add("command", (Object)command);
        }
        if (this.importer == null) {
            rsp.add("status", (Object)"DataImportHandler started. Not Initialized. No commands can be run");
            return;
        }
        if (command != null && "abort".equals(command)) {
            this.importer.runCmd(requestParams, null);
        } else if (this.importer.isBusy()) {
            message = "A command is still running...";
        } else if (command != null) {
            if ("full-import".equals(command) || "delta-import".equals(command) || "import".equals(command)) {
                this.importer.maybeReloadConfiguration(requestParams, defaultParams);
                UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessingChain(params.get("update.chain"));
                UpdateRequestProcessor processor = processorChain.createProcessor(req, rsp);
                SolrResourceLoader loader = req.getCore().getResourceLoader();
                SolrWriter sw = this.getSolrWriter(processor, loader, requestParams, req);
                if (requestParams.isDebug()) {
                    if (this.debugEnabled) {
                        this.importer.runCmd(requestParams, sw);
                        rsp.add("mode", (Object)"debug");
                        rsp.add("documents", requestParams.getDebugInfo().debugDocuments);
                        if (requestParams.getDebugInfo().debugVerboseOutput != null) {
                            rsp.add("verbose-output", requestParams.getDebugInfo().debugVerboseOutput);
                        }
                    } else {
                        message = "Debug not enabled. Add a tag <str name=\"enableDebug\">true</str> in solrconfig.xml";
                    }
                } else if (requestParams.getContentStream() == null && !requestParams.isSyncMode()) {
                    this.importer.runAsync(requestParams, sw);
                } else {
                    this.importer.runCmd(requestParams, sw);
                }
            } else if ("reload-config".equals(command)) {
                message = this.importer.maybeReloadConfiguration(requestParams, defaultParams) ? "Configuration Re-loaded sucessfully" : "Configuration NOT Re-loaded...Data Importer is busy.";
            }
        }
        rsp.add("status", (Object)(this.importer.isBusy() ? "busy" : "idle"));
        rsp.add("importResponse", (Object)message);
        rsp.add("statusMessages", this.importer.getStatusMessages());
        RequestHandlerUtils.addExperimentalFormatWarning((SolrQueryResponse)rsp);
    }

    private Map<String, Object> getParamsMap(SolrParams params) {
        Iterator names = params.getParameterNamesIterator();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (names.hasNext()) {
            String s = (String)names.next();
            String[] val = params.getParams(s);
            if (val == null || val.length < 1) continue;
            if (val.length == 1) {
                result.put(s, val[0]);
                continue;
            }
            result.put(s, Arrays.asList(val));
        }
        return result;
    }

    private SolrWriter getSolrWriter(UpdateRequestProcessor processor, SolrResourceLoader loader, RequestInfo requestParams, SolrQueryRequest req) {
        return new SolrWriter(processor, req){

            @Override
            public boolean upload(SolrInputDocument document) {
                try {
                    return super.upload(document);
                }
                catch (RuntimeException e) {
                    LOG.error("Exception while adding: " + document, (Throwable)e);
                    return false;
                }
            }
        };
    }

    public NamedList getStatistics() {
        if (this.importer == null) {
            return super.getStatistics();
        }
        DocBuilder.Statistics cumulative = this.importer.cumulativeStatistics;
        SimpleOrderedMap result = new SimpleOrderedMap();
        result.add("Status", (Object)this.importer.getStatus().toString());
        if (this.importer.docBuilder != null) {
            DocBuilder.Statistics running = this.importer.docBuilder.importStatistics;
            result.add("Documents Processed", (Object)running.docCount);
            result.add("Requests made to DataSource", (Object)running.queryCount);
            result.add("Rows Fetched", (Object)running.rowsCount);
            result.add("Documents Deleted", (Object)running.deletedDocCount);
            result.add("Documents Skipped", (Object)running.skipDocCount);
        }
        result.add("Total Documents Processed", (Object)cumulative.docCount);
        result.add("Total Requests made to DataSource", (Object)cumulative.queryCount);
        result.add("Total Rows Fetched", (Object)cumulative.rowsCount);
        result.add("Total Documents Deleted", (Object)cumulative.deletedDocCount);
        result.add("Total Documents Skipped", (Object)cumulative.skipDocCount);
        NamedList requestStatistics = super.getStatistics();
        if (requestStatistics != null) {
            for (int i = 0; i < requestStatistics.size(); ++i) {
                result.add(requestStatistics.getName(i), requestStatistics.getVal(i));
            }
        }
        return result;
    }

    public String getDescription() {
        return "Manage data import from databases to Solr";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_6/solr/contrib/dataimporthandler/src/java/org/apache/solr/handler/dataimport/DataImportHandler.java $";
    }
}

