/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.Transformer;

public class ScriptTransformer
extends Transformer {
    private Invocable engine;
    private String functionName;

    @Override
    public Object transformRow(Map<String, Object> row, Context context) {
        try {
            if (this.engine == null) {
                this.initEngine(context);
            }
            if (this.engine == null) {
                return row;
            }
            return this.engine.invokeFunction(this.functionName, row, context);
        }
        catch (DataImportHandlerException e) {
            throw e;
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Error invoking script for entity " + context.getEntityAttribute("name"));
            return null;
        }
    }

    private void initEngine(Context context) {
        String scriptText = context.getScript();
        String scriptLang = context.getScriptLanguage();
        if (scriptText == null) {
            throw new DataImportHandlerException(500, "<script> tag is not present under <dataConfig>");
        }
        ScriptEngineManager scriptEngineMgr = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineMgr.getEngineByName(scriptLang);
        if (scriptEngine == null) {
            throw new DataImportHandlerException(500, "Cannot load Script Engine for language: " + scriptLang);
        }
        if (!(scriptEngine instanceof Invocable)) {
            throw new DataImportHandlerException(500, "The installed ScriptEngine for: " + scriptLang + " does not implement Invocable.  Class is " + scriptEngine.getClass().getName());
        }
        this.engine = (Invocable)((Object)scriptEngine);
        try {
            scriptEngine.eval(scriptText);
        }
        catch (ScriptException e) {
            DataImportHandlerException.wrapAndThrow(500, e, "'eval' failed with language: " + scriptLang + " and script: \n" + scriptText);
        }
    }

    public void setFunctionName(String methodName) {
        this.functionName = methodName;
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

