/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.util.Cache;
import org.apache.solr.common.util.MapBackedCache;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.update.processor.TemplateUpdateProcessorFactory;

public class VariableResolver {
    private static final Pattern DOT_PATTERN = Pattern.compile("[.]");
    private static final Pattern EVALUATOR_FORMAT_PATTERN = Pattern.compile("^(\\w*?)\\((.*?)\\)$");
    private Map<String, Object> rootNamespace;
    private Map<String, Evaluator> evaluators;
    private Cache<String, TemplateUpdateProcessorFactory.Resolved> cache = new MapBackedCache(new WeakHashMap());
    private Function<String, Object> fun = this::resolve;
    public static final String FUNCTIONS_NAMESPACE = "dataimporter.functions.";
    public static final String FUNCTIONS_NAMESPACE_SHORT = "dih.functions.";

    public VariableResolver() {
        this.rootNamespace = new HashMap<String, Object>();
    }

    public VariableResolver(Properties defaults) {
        this.rootNamespace = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : defaults.entrySet()) {
            this.rootNamespace.put(entry.getKey().toString(), entry.getValue());
        }
    }

    public VariableResolver(Map<String, Object> defaults) {
        this.rootNamespace = new HashMap<String, Object>(defaults);
    }

    public Object resolve(String name) {
        Object r = null;
        if (name != null) {
            String[] nameParts = DOT_PATTERN.split(name);
            CurrentLevel cr = this.currentLevelMap(nameParts, this.rootNamespace, false);
            Map<String, Object> currentLevel = cr.map;
            r = currentLevel.get(nameParts[nameParts.length - 1]);
            if (r == null && name.startsWith(FUNCTIONS_NAMESPACE) && name.length() > FUNCTIONS_NAMESPACE.length()) {
                return this.resolveEvaluator(FUNCTIONS_NAMESPACE, name);
            }
            if (r == null && name.startsWith(FUNCTIONS_NAMESPACE_SHORT) && name.length() > FUNCTIONS_NAMESPACE_SHORT.length()) {
                return this.resolveEvaluator(FUNCTIONS_NAMESPACE_SHORT, name);
            }
            if (r == null) {
                StringBuilder sb = new StringBuilder();
                for (int i = cr.level; i < nameParts.length; ++i) {
                    if (sb.length() > 0) {
                        sb.append(".");
                    }
                    sb.append(nameParts[i]);
                }
                r = cr.map.get(sb.toString());
            }
            if (r == null) {
                r = System.getProperty(name);
            }
        }
        return r == null ? "" : r;
    }

    private Object resolveEvaluator(String namespace, String name) {
        if (this.evaluators == null) {
            return "";
        }
        Matcher m = EVALUATOR_FORMAT_PATTERN.matcher(name.substring(namespace.length()));
        if (m.find()) {
            String fname = m.group(1);
            Evaluator evaluator = this.evaluators.get(fname);
            if (evaluator == null) {
                return "";
            }
            ContextImpl ctx = new ContextImpl(null, this, null, null, null, null, null);
            String g2 = m.group(2);
            return evaluator.evaluate(g2, ctx);
        }
        return "";
    }

    public String replaceTokens(String template) {
        return TemplateUpdateProcessorFactory.replaceTokens((String)template, this.cache, this.fun);
    }

    public void addNamespace(String name, Map<String, Object> newMap) {
        if (newMap != null) {
            if (name != null) {
                String[] nameParts = DOT_PATTERN.split(name);
                Map<String, Object> nameResolveLevel = this.currentLevelMap((String[])nameParts, this.rootNamespace, (boolean)false).map;
                nameResolveLevel.put(nameParts[nameParts.length - 1], newMap);
            } else {
                for (Map.Entry<String, Object> entry : newMap.entrySet()) {
                    String[] keyParts = DOT_PATTERN.split(entry.getKey());
                    Map<String, Object> currentLevel = this.rootNamespace;
                    currentLevel = this.currentLevelMap((String[])keyParts, currentLevel, (boolean)false).map;
                    currentLevel.put(keyParts[keyParts.length - 1], entry.getValue());
                }
            }
        }
    }

    public List<String> getVariables(String expr) {
        return TemplateUpdateProcessorFactory.getVariables((String)expr, this.cache);
    }

    private CurrentLevel currentLevelMap(String[] keyParts, Map<String, Object> currentLevel, boolean includeLastLevel) {
        int j = includeLastLevel ? keyParts.length : keyParts.length - 1;
        for (int i = 0; i < j; ++i) {
            HashMap<String, Object> nextLevel;
            Object o = currentLevel.get(keyParts[i]);
            if (o == null) {
                if (i == j - 1) {
                    nextLevel = new HashMap<String, Object>();
                    currentLevel.put(keyParts[i], nextLevel);
                    currentLevel = nextLevel;
                    continue;
                }
                return new CurrentLevel(i, currentLevel);
            }
            if (o instanceof Map) {
                currentLevel = nextLevel = (HashMap<String, Object>)o;
                continue;
            }
            throw new AssertionError((Object)"Non-leaf nodes should be of type java.util.Map");
        }
        return new CurrentLevel(j - 1, currentLevel);
    }

    public void removeNamespace(String name) {
        this.rootNamespace.remove(name);
    }

    public void setEvaluators(Map<String, Evaluator> evaluators) {
        this.evaluators = evaluators;
    }

    static class CurrentLevel {
        final Map<String, Object> map;
        final int level;

        CurrentLevel(int level, Map<String, Object> map) {
            this.level = level;
            this.map = map;
        }
    }
}

