/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import org.apache.solr.common.cloud.ZkNodeProps;

public class ZkCoreNodeProps {
    private ZkNodeProps nodeProps;

    public ZkCoreNodeProps(ZkNodeProps nodeProps) {
        this.nodeProps = nodeProps;
    }

    public String getCoreUrl() {
        return ZkCoreNodeProps.getCoreUrl(this.nodeProps.get("base_url"), this.nodeProps.get("core"));
    }

    public String getNodeName() {
        return this.nodeProps.get("node_name");
    }

    public String getState() {
        return this.nodeProps.get("state");
    }

    public String getBaseUrl() {
        return this.nodeProps.get("base_url");
    }

    public String getCoreName() {
        return this.nodeProps.get("core");
    }

    public static String getCoreUrl(String baseUrl, String coreName) {
        StringBuilder sb = new StringBuilder();
        if (baseUrl == null) {
            return null;
        }
        if (coreName == null) {
            return null;
        }
        sb.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            sb.append("/");
        }
        sb.append(coreName == null ? "" : coreName);
        if (!sb.substring(sb.length() - 1).equals("/")) {
            sb.append("/");
        }
        return sb.toString();
    }

    public String toString() {
        return this.nodeProps.toString();
    }

    public String getCoreNodeName() {
        return this.getNodeName() + "_" + this.getCoreName();
    }

    public ZkNodeProps getNodeProps() {
        return this.nodeProps;
    }
}

