/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.zookeeper.SolrZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionManager
implements Watcher {
    protected static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private final String name;
    private CountDownLatch clientConnected;
    private Watcher.Event.KeeperState state;
    private boolean connected;
    private final ZkClientConnectionStrategy connectionStrategy;
    private String zkServerAddress;
    private int zkClientTimeout;
    private SolrZkClient client;
    private OnReconnect onReconnect;
    private volatile boolean isClosed = false;

    public ConnectionManager(String name, SolrZkClient client, String zkServerAddress, int zkClientTimeout, ZkClientConnectionStrategy strat, OnReconnect onConnect) {
        this.name = name;
        this.client = client;
        this.connectionStrategy = strat;
        this.zkServerAddress = zkServerAddress;
        this.zkClientTimeout = zkClientTimeout;
        this.onReconnect = onConnect;
        this.reset();
    }

    private synchronized void reset() {
        this.clientConnected = new CountDownLatch(1);
        this.state = Watcher.Event.KeeperState.Disconnected;
        this.connected = false;
    }

    public synchronized void process(WatchedEvent event) {
        if (log.isInfoEnabled()) {
            log.info("Watcher " + this + " name:" + this.name + " got event " + event + " path:" + event.getPath() + " type:" + event.getType());
        }
        this.checkClosed();
        this.state = event.getState();
        if (this.state == Watcher.Event.KeeperState.SyncConnected) {
            this.connected = true;
            this.clientConnected.countDown();
        } else if (this.state == Watcher.Event.KeeperState.Expired) {
            this.connected = false;
            log.info("Attempting to reconnect to recover relationship with ZooKeeper...");
            try {
                this.connectionStrategy.reconnect(this.zkServerAddress, this.zkClientTimeout, this, new ZkClientConnectionStrategy.ZkUpdate(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void update(SolrZooKeeper keeper) throws TimeoutException {
                        ZkClientConnectionStrategy zkClientConnectionStrategy = ConnectionManager.this.connectionStrategy;
                        synchronized (zkClientConnectionStrategy) {
                            ConnectionManager.this.checkClosed();
                            try {
                                ConnectionManager.this.waitForConnected(30000L);
                                ConnectionManager.this.checkClosed();
                                ConnectionManager.this.client.updateKeeper(keeper);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException("Giving up on connecting - we were interrupted");
                            }
                            ConnectionManager.this.checkClosed();
                            if (ConnectionManager.this.onReconnect != null) {
                                ConnectionManager.this.onReconnect.command();
                            }
                            ConnectionManager connectionManager = ConnectionManager.this;
                            synchronized (connectionManager) {
                                ConnectionManager.this.connected = true;
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                SolrException.log(log, "", e);
            }
            log.info("Connected:" + this.connected);
        } else {
            this.connected = this.state == Watcher.Event.KeeperState.Disconnected ? false : false;
        }
        this.notifyAll();
    }

    public synchronized boolean isConnected() {
        return !this.isClosed && this.connected;
    }

    public void close() {
        this.isClosed = true;
    }

    public synchronized Watcher.Event.KeeperState state() {
        return this.state;
    }

    public synchronized void waitForConnected(long waitForConnection) throws InterruptedException, TimeoutException {
        long expire = System.currentTimeMillis() + waitForConnection;
        long left = waitForConnection;
        while (!this.connected && left > 0L) {
            this.wait(left);
            this.checkClosed();
            left = expire - System.currentTimeMillis();
        }
        if (!this.connected) {
            throw new TimeoutException("Could not connect to ZooKeeper " + this.zkServerAddress + " within " + waitForConnection + " ms");
        }
    }

    private synchronized void checkClosed() {
        if (this.isClosed) {
            log.info("Not acting because I am closed");
            return;
        }
    }

    public synchronized void waitForDisconnected(long timeout) throws InterruptedException, TimeoutException {
        long expire = System.currentTimeMillis() + timeout;
        long left = timeout;
        while (this.connected && left > 0L) {
            this.wait(left);
            left = expire - System.currentTimeMillis();
        }
        if (this.connected) {
            throw new TimeoutException("Did not disconnect");
        }
    }
}

