/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.params.SolrParams;

public class HttpClientConfigurer {
    protected void configure(DefaultHttpClient httpClient, SolrParams config) {
        if (config.get("maxConnections") != null) {
            HttpClientUtil.setMaxConnections((HttpClient)httpClient, config.getInt("maxConnections"));
        }
        if (config.get("maxConnectionsPerHost") != null) {
            HttpClientUtil.setMaxConnectionsPerHost((HttpClient)httpClient, config.getInt("maxConnectionsPerHost"));
        }
        if (config.get("connTimeout") != null) {
            HttpClientUtil.setConnectionTimeout((HttpClient)httpClient, config.getInt("connTimeout"));
        }
        if (config.get("socketTimeout") != null) {
            HttpClientUtil.setSoTimeout((HttpClient)httpClient, config.getInt("socketTimeout"));
        }
        if (config.get("retry") != null) {
            HttpClientUtil.setUseRetry(httpClient, config.getBool("retry"));
        }
        if (config.get("followRedirects") != null) {
            HttpClientUtil.setFollowRedirects((HttpClient)httpClient, config.getBool("followRedirects"));
        }
        String basicAuthUser = config.get("httpBasicAuthUser");
        String basicAuthPass = config.get("httpBasicAuthPassword");
        HttpClientUtil.setBasicAuth(httpClient, basicAuthUser, basicAuthPass);
        if (config.get("allowCompression") != null) {
            HttpClientUtil.setAllowCompression(httpClient, config.getBool("allowCompression"));
        }
    }
}

