/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSolrServer
extends SolrServer {
    private static final String UTF_8 = "UTF-8";
    private static final String DEFAULT_PATH = "/select";
    private static final long serialVersionUID = -946812319974801896L;
    public static final String AGENT = "Solr[" + HttpSolrServer.class.getName() + "] 1.0";
    private static Logger log = LoggerFactory.getLogger(HttpSolrServer.class);
    protected String baseUrl;
    protected ModifiableSolrParams invariantParams;
    protected volatile ResponseParser parser;
    protected volatile RequestWriter requestWriter = new RequestWriter();
    private final HttpClient httpClient;
    private boolean followRedirects = false;
    private int maxRetries = 0;
    private boolean useMultiPartPost;
    private final boolean internalClient;
    private Set<String> queryParams = Collections.emptySet();

    public HttpSolrServer(String baseURL) {
        this(baseURL, null, new BinaryResponseParser());
    }

    public HttpSolrServer(String baseURL, HttpClient client) {
        this(baseURL, client, new BinaryResponseParser());
    }

    public HttpSolrServer(String baseURL, HttpClient client, ResponseParser parser) {
        this.baseUrl = baseURL;
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.baseUrl.indexOf(63) >= 0) {
            throw new RuntimeException("Invalid base url for solrj.  The base URL must not contain parameters: " + this.baseUrl);
        }
        if (client != null) {
            this.httpClient = client;
            this.internalClient = false;
        } else {
            this.internalClient = true;
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("maxConnections", 128);
            params.set("maxConnectionsPerHost", 32);
            params.set("followRedirects", this.followRedirects);
            this.httpClient = HttpClientUtil.createClient(params);
        }
        this.parser = parser;
    }

    public Set<String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Set<String> queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this.parser;
        }
        return this.request(request, responseParser);
    }

    /*
     * Exception decompiling
     */
    public NamedList<Object> request(SolrRequest request, ResponseParser processor) throws SolrServerException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 36[WHILELOOP]], but top level block is 70[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ModifiableSolrParams getInvariantParams() {
        return this.invariantParams;
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    public void setBaseURL(String baseURL) {
        this.baseUrl = baseURL;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    public void setParser(ResponseParser processor) {
        this.parser = processor;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectionTimeout(int timeout) {
        HttpClientUtil.setConnectionTimeout(this.httpClient, timeout);
    }

    public void setSoTimeout(int timeout) {
        HttpClientUtil.setSoTimeout(this.httpClient, timeout);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        HttpClientUtil.setFollowRedirects(this.httpClient, followRedirects);
    }

    public void setAllowCompression(boolean allowCompression) {
        if (!(this.httpClient instanceof DefaultHttpClient)) {
            throw new UnsupportedOperationException("HttpClient instance was not of type DefaultHttpClient");
        }
        HttpClientUtil.setAllowCompression((DefaultHttpClient)this.httpClient, allowCompression);
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries > 1) {
            log.warn("HttpSolrServer: maximum Retries " + maxRetries + " > 1. Maximum recommended retries is 1.");
        }
        this.maxRetries = maxRetries;
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    public UpdateResponse add(Iterator<SolrInputDocument> docIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(docIterator);
        return req.process(this);
    }

    public UpdateResponse addBeans(final Iterator<?> beanIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(new Iterator<SolrInputDocument>(){

            @Override
            public boolean hasNext() {
                return beanIterator.hasNext();
            }

            @Override
            public SolrInputDocument next() {
                Object o = beanIterator.next();
                if (o == null) {
                    return null;
                }
                return HttpSolrServer.this.getBinder().toSolrInputDocument(o);
            }

            @Override
            public void remove() {
                beanIterator.remove();
            }
        });
        return req.process(this);
    }

    @Override
    public void shutdown() {
        if (this.httpClient != null && this.internalClient) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    public void setDefaultMaxConnectionsPerHost(int max) {
        if (!this.internalClient) {
            throw new UnsupportedOperationException("Client was created outside of HttpSolrServer");
        }
        HttpClientUtil.setMaxConnectionsPerHost(this.httpClient, max);
    }

    public void setMaxTotalConnections(int max) {
        if (!this.internalClient) {
            throw new UnsupportedOperationException("Client was created outside of HttpSolrServer");
        }
        HttpClientUtil.setMaxConnections(this.httpClient, max);
    }

    public boolean isUseMultiPartPost() {
        return this.useMultiPartPost;
    }

    public void setUseMultiPartPost(boolean useMultiPartPost) {
        this.useMultiPartPost = useMultiPartPost;
    }

    public static class RemoteSolrException
    extends SolrException {
        public RemoteSolrException(int code, String msg, Throwable th) {
            super(code, msg, th);
        }
    }
}

