/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public class LukeRequest
extends SolrRequest {
    private List<String> fields;
    private int numTerms = -1;
    private boolean showSchema = false;

    public LukeRequest() {
        super(SolrRequest.METHOD.GET, "/admin/luke");
    }

    public LukeRequest(String path) {
        super(SolrRequest.METHOD.GET, path);
    }

    public void addField(String f) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(f);
    }

    public void setFields(List<String> f) {
        this.fields = f;
    }

    public boolean isShowSchema() {
        return this.showSchema;
    }

    public void setShowSchema(boolean showSchema) {
        this.showSchema = showSchema;
    }

    public int getNumTerms() {
        return this.numTerms;
    }

    public void setNumTerms(int count) {
        this.numTerms = count;
    }

    @Override
    public Collection<ContentStream> getContentStreams() {
        return null;
    }

    @Override
    public SolrParams getParams() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (this.fields != null && this.fields.size() > 0) {
            params.add("fl", this.fields.toArray(new String[this.fields.size()]));
        }
        if (this.numTerms >= 0) {
            params.add("numTerms", this.numTerms + "");
        }
        if (this.showSchema) {
            params.add("show", "schema");
        }
        return params;
    }

    @Override
    public LukeResponse process(SolrClient client) throws SolrServerException, IOException {
        long startTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        LukeResponse res = new LukeResponse();
        res.setResponse(client.request(this));
        long endTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        res.setElapsedTime(endTime - startTime);
        return res;
    }
}

