/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;

public class SolrPing
extends SolrRequest {
    private static final long serialVersionUID = 5828246236669090017L;
    private ModifiableSolrParams params = new ModifiableSolrParams();

    public SolrPing() {
        super(SolrRequest.METHOD.GET, "/admin/ping");
    }

    @Override
    public Collection<ContentStream> getContentStreams() {
        return null;
    }

    @Override
    public ModifiableSolrParams getParams() {
        return this.params;
    }

    @Override
    public SolrPingResponse process(SolrClient client) throws SolrServerException, IOException {
        long startTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        SolrPingResponse res = new SolrPingResponse();
        res.setResponse(client.request(this));
        long endTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        res.setElapsedTime(endTime - startTime);
        return res;
    }

    public SolrPing removeAction() {
        this.params.remove("action");
        return this;
    }

    public SolrPing setActionDisable() {
        this.params.set("action", "disable");
        return this;
    }

    public SolrPing setActionEnable() {
        this.params.set("action", "enable");
        return this;
    }

    public SolrPing setActionPing() {
        this.params.set("action", "ping");
        return this;
    }
}

