/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ExpressibleComparator;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.stream.ExpressibleStream;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ReducerStream
extends TupleStream
implements ExpressibleStream {
    private static final long serialVersionUID = 1L;
    private PushBackStream tupleStream;
    private Comparator<Tuple> comp;
    private transient Tuple currentGroupHead;

    public ReducerStream(TupleStream tupleStream, Comparator<Tuple> comp) {
        this.tupleStream = new PushBackStream(tupleStream);
        this.comp = comp;
    }

    public ReducerStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, ExpressibleStream.class, TupleStream.class);
        StreamExpressionNamedParameter byExpression = factory.getNamedOperand(expression, "by");
        if (expression.getParameters().size() != streamExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        this.tupleStream = new PushBackStream(factory.constructStream(streamExpressions.get(0)));
        if (null == byExpression || !(byExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'by' parameter listing fields to group by but didn't find one", expression));
        }
        this.comp = factory.constructComparator(((StreamExpressionValue)byExpression.getParameter()).getValue(), FieldComparator.class);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.tupleStream.toExpression(factory));
        if (!(this.comp instanceof ExpressibleComparator)) {
            throw new IOException("This ReducerStream contains a non-expressible comparator - it cannot be converted to an expression");
        }
        expression.addParameter(new StreamExpressionNamedParameter("by", ((ExpressibleComparator)((Object)this.comp)).toExpression(factory)));
        return expression;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.tupleStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.tupleStream.open();
    }

    @Override
    public void close() throws IOException {
        this.tupleStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        Tuple t;
        ArrayList<Map> maps = new ArrayList<Map>();
        while (true) {
            t = this.tupleStream.read();
            if (t.EOF) {
                if (maps.size() > 0) {
                    this.tupleStream.pushBack(t);
                    Map map1 = (Map)maps.get(0);
                    HashMap map2 = new HashMap();
                    map2.putAll(map1);
                    Tuple groupHead = new Tuple(map2);
                    groupHead.setMaps(maps);
                    return groupHead;
                }
                return t;
            }
            if (this.currentGroupHead == null) {
                this.currentGroupHead = t;
                maps.add(t.getMap());
                continue;
            }
            if (this.comp.compare(this.currentGroupHead, t) != 0) break;
            maps.add(t.getMap());
        }
        Tuple groupHead = this.currentGroupHead.clone();
        this.tupleStream.pushBack(t);
        this.currentGroupHead = null;
        groupHead.setMaps(maps);
        return groupHead;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

