/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientCache
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, SolrClient> solrClients = new HashMap<String, SolrClient>();

    public synchronized CloudSolrClient getCloudSolrClient(String zkHost) {
        CloudSolrClient client;
        if (this.solrClients.containsKey(zkHost)) {
            client = (CloudSolrClient)this.solrClients.get(zkHost);
        } else {
            client = new CloudSolrClient(zkHost);
            client.connect();
            this.solrClients.put(zkHost, client);
        }
        return client;
    }

    public synchronized HttpSolrClient getHttpSolrClient(String host) {
        HttpSolrClient client;
        if (this.solrClients.containsKey(host)) {
            client = (HttpSolrClient)this.solrClients.get(host);
        } else {
            client = new HttpSolrClient(host);
            this.solrClients.put(host, client);
        }
        return client;
    }

    public void close() {
        for (Map.Entry<String, SolrClient> entry : this.solrClients.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Error closing SolrClient for " + entry.getKey(), (Throwable)e);
            }
        }
    }
}

