/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.apache.solr.client.solrj.io.sql.ConnectionImpl;
import org.apache.solr.client.solrj.io.sql.ResultSetImpl;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;

class StatementImpl
implements Statement {
    private final ConnectionImpl connection;
    private boolean closed;
    private String currentSQL;
    private ResultSetImpl currentResultSet;
    private SQLWarning currentWarning;
    private int maxRows;

    StatementImpl(ConnectionImpl connection) {
        this.connection = connection;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
                this.currentResultSet = null;
            }
            if (this.maxRows > 0 && !this.containsLimit(sql)) {
                sql = sql + " limit " + Integer.toString(this.maxRows);
            }
            this.closed = false;
            this.currentResultSet = new ResultSetImpl(this, this.constructStream(sql));
            return this.currentResultSet;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected SolrStream constructStream(String sql) throws IOException {
        try {
            ZkStateReader zkStateReader = this.connection.getClient().getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Collection<Slice> slices = clusterState.getActiveSlices(this.connection.getCollection());
            if (slices == null) {
                throw new Exception("Collection not found:" + this.connection.getCollection());
            }
            ArrayList<Replica> shuffler = new ArrayList<Replica>();
            for (Slice slice : slices) {
                Collection<Replica> replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    shuffler.add(replica);
                }
            }
            Collections.shuffle(shuffler, new Random());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("qt", "/sql");
            params.put("stmt", sql);
            for (String propertyName : this.connection.getProperties().stringPropertyNames()) {
                params.put(propertyName, this.connection.getProperties().getProperty(propertyName));
            }
            Replica replica = (Replica)shuffler.get(0);
            ZkCoreNodeProps zkProps = new ZkCoreNodeProps(replica);
            String url = zkProps.getCoreUrl();
            return new SolrStream(url, params);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return 0;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancel() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed.");
        }
        return this.currentWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed.");
        }
        this.currentWarning = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
            this.currentResultSet = null;
        }
        this.currentSQL = sql;
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.executeQuery(this.currentSQL);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed");
        }
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed");
        }
        this.currentResultSet.close();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private boolean containsLimit(String sql) {
        String[] tokens = sql.split("\\s+");
        String secondToLastToken = tokens[tokens.length - 2];
        return "limit".equalsIgnoreCase(secondToLastToken);
    }
}

