/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.HashJoinStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class OuterHashJoinStream
extends HashJoinStream
implements Expressible {
    private static final long serialVersionUID = 1L;

    public OuterHashJoinStream(TupleStream fullStream, TupleStream hashStream, List<String> hashOn) throws IOException {
        super(fullStream, hashStream, hashOn);
    }

    public OuterHashJoinStream(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (!(this.hashStream instanceof Expressible) || !(this.fullStream instanceof Expressible)) {
            throw new IOException("This OuterHashJoinStream contains a non-expressible TupleStream - it cannot be converted to an expression");
        }
        expression.addParameter(((Expressible)((Object)this.fullStream)).toExpression(factory));
        expression.addParameter(new StreamExpressionNamedParameter("hashed", ((Expressible)((Object)this.hashStream)).toExpression(factory)));
        StringBuilder sb = new StringBuilder();
        for (String part : this.hashOn) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(part);
        }
        expression.addParameter(new StreamExpressionNamedParameter("on", sb.toString()));
        return expression;
    }

    @Override
    public Tuple read() throws IOException {
        if (null == this.workingFullTuple) {
            Tuple fullTuple = this.fullStream.read();
            if (fullTuple.EOF) {
                return fullTuple;
            }
            Integer fullHash = this.calculateHash(fullTuple);
            if (null == fullHash || !this.hashedTuples.containsKey(fullHash)) {
                return fullTuple.clone();
            }
            this.workingFullTuple = fullTuple;
            this.workingFullHash = fullHash;
            this.workngHashSetIdx = 0;
        }
        List matches = (List)this.hashedTuples.get(this.workingFullHash);
        Tuple returnTuple = this.workingFullTuple.clone();
        returnTuple.merge((Tuple)matches.get(this.workngHashSetIdx));
        ++this.workngHashSetIdx;
        if (this.workngHashSetIdx >= matches.size()) {
            this.workingFullTuple = null;
            this.workingFullHash = null;
            this.workngHashSetIdx = 0;
        }
        return returnTuple;
    }
}

