/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.util;

import java.util.Locale;
import java.util.regex.Pattern;

public class SolrIdentifierValidator {
    static final Pattern identifierPattern = Pattern.compile("^(?!\\-)[\\._A-Za-z0-9\\-]*$");

    public static boolean validateShardName(String shardName) {
        return SolrIdentifierValidator.validateIdentifier(shardName);
    }

    public static boolean validateCollectionName(String collectionName) {
        return SolrIdentifierValidator.validateIdentifier(collectionName);
    }

    public static boolean validateCoreName(String name) {
        return SolrIdentifierValidator.validateIdentifier(name);
    }

    private static boolean validateIdentifier(String identifier) {
        return identifier != null && identifierPattern.matcher(identifier).matches();
    }

    public static String getIdentifierMessage(IdentifierType identifierType, String name) {
        return "Invalid " + identifierType.toString().toLowerCase(Locale.ROOT) + ": " + name + ". " + identifierType.toString().toLowerCase(Locale.ROOT) + " names must consist entirely of periods, underscores, hyphens, and alphanumerics";
    }

    public static enum IdentifierType {
        SHARD,
        COLLECTION,
        CORE,
        ALIAS;

    }
}

