/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.ops.BooleanOperation;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class AndOperation
implements BooleanOperation {
    private static final long serialVersionUID = 1L;
    private UUID operationNodeId = UUID.randomUUID();
    protected BooleanOperation leftOperand;
    protected BooleanOperation rightOperand;

    @Override
    public void operate(Tuple tuple) {
        this.leftOperand.operate(tuple);
        this.rightOperand.operate(tuple);
    }

    public AndOperation(BooleanOperation leftOperand, BooleanOperation rightOperand) {
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    public AndOperation(StreamExpression expression, StreamFactory factory) throws IOException {
        StreamOperation rightOp;
        List<StreamExpression> operationExpressions = factory.getExpressionOperandsRepresentingTypes(expression, BooleanOperation.class);
        if (operationExpressions != null && operationExpressions.size() == 2) {
            StreamExpression left = operationExpressions.get(0);
            StreamOperation leftOp = factory.constructOperation(left);
            if (!(leftOp instanceof BooleanOperation)) {
                throw new IOException("The And/Or Operation requires a BooleanOperation.");
            }
            this.leftOperand = (BooleanOperation)leftOp;
            StreamExpression right = operationExpressions.get(1);
            rightOp = factory.constructOperation(right);
            if (!(rightOp instanceof BooleanOperation)) {
                throw new IOException("The And/Or Operation requires a BooleanOperation.");
            }
        } else {
            throw new IOException("The And/Or Operation requires a BooleanOperations.");
        }
        this.rightOperand = (BooleanOperation)rightOp;
    }

    @Override
    public boolean evaluate() {
        return this.leftOperand.evaluate() && this.rightOperand.evaluate();
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (!(this.leftOperand instanceof Expressible)) {
            throw new IOException("This left operand of the AndOperation contains a non-expressible operation - it cannot be converted to an expression");
        }
        expression.addParameter(this.leftOperand.toExpression(factory));
        if (!(this.rightOperand instanceof Expressible)) {
            throw new IOException("This the right operand of the AndOperation contains a non-expressible operation - it cannot be converted to an expression");
        }
        expression.addParameter(this.rightOperand.toExpression(factory));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.operationNodeId.toString()).withExpressionType("operation").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

