/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;

public abstract class TupleStream
implements Closeable,
Serializable,
MapWriter {
    private static final long serialVersionUID = 1L;
    private UUID streamNodeId = UUID.randomUUID();

    public abstract void setStreamContext(StreamContext var1);

    public abstract List<TupleStream> children();

    public abstract void open() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract Tuple read() throws IOException;

    public abstract StreamComparator getStreamSort();

    public abstract Explanation toExplanation(StreamFactory var1) throws IOException;

    public int getCost() {
        return 0;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.open();
        ew.put("docs", iw -> {
            try {
                Tuple tuple;
                while ((tuple = this.read()) != null) {
                    iw.add(tuple);
                    if (!tuple.EOF) continue;
                    this.close();
                    break;
                }
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        });
    }

    public UUID getStreamNodeId() {
        return this.streamNodeId;
    }
}

