/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.NumberEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PowerEvaluator
extends NumberEvaluator {
    protected static final long serialVersionUID = 1L;

    public PowerEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly two values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Number evaluate(Tuple tuple) throws IOException {
        List<BigDecimal> results = this.evaluateAll(tuple);
        if (results.stream().anyMatch(item -> null == item)) {
            return null;
        }
        BigDecimal value = results.get(0);
        BigDecimal exponent = results.get(1);
        double result = Math.pow(value.doubleValue(), exponent.doubleValue());
        if (Double.isNaN(result)) {
            return result;
        }
        return this.normalizeType(BigDecimal.valueOf(result));
    }
}

