/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.List;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CorrelationEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public CorrelationEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Number evaluate(Tuple tuple) throws IOException {
        int i;
        StreamEvaluator colEval1 = (StreamEvaluator)this.subEvaluators.get(0);
        StreamEvaluator colEval2 = (StreamEvaluator)this.subEvaluators.get(1);
        List numbers1 = (List)colEval1.evaluate(tuple);
        List numbers2 = (List)colEval2.evaluate(tuple);
        double[] column1 = new double[numbers1.size()];
        double[] column2 = new double[numbers2.size()];
        for (i = 0; i < numbers1.size(); ++i) {
            column1[i] = ((Number)numbers1.get(i)).doubleValue();
        }
        for (i = 0; i < numbers2.size(); ++i) {
            column2[i] = ((Number)numbers2.get(i)).doubleValue();
        }
        PearsonsCorrelation pearsonsCorrelation = new PearsonsCorrelation();
        return pearsonsCorrelation.correlation(column1, column2);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

